/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.GameSessionDetail;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GameSessionDetailMarshaller {
    private static final MarshallingInfo<StructuredPojo> GAMESESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GameSession").isBinary(false).build();
    private static final MarshallingInfo<String> PROTECTIONPOLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProtectionPolicy").isBinary(false).build();
    private static final GameSessionDetailMarshaller INSTANCE = new GameSessionDetailMarshaller();

    private GameSessionDetailMarshaller() {
    }

    public static GameSessionDetailMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GameSessionDetail gameSessionDetail, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)gameSessionDetail, (String)"gameSessionDetail");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)gameSessionDetail.gameSession(), GAMESESSION_BINDING);
            protocolMarshaller.marshall((Object)gameSessionDetail.protectionPolicyAsString(), PROTECTIONPOLICY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

