/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.gamelift.model.EC2InstanceCounts;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EC2InstanceCountsMarshaller {
    private static final MarshallingInfo<Integer> DESIRED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DESIRED").isBinary(false).build();
    private static final MarshallingInfo<Integer> MINIMUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MINIMUM").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXIMUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MAXIMUM").isBinary(false).build();
    private static final MarshallingInfo<Integer> PENDING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PENDING").isBinary(false).build();
    private static final MarshallingInfo<Integer> ACTIVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ACTIVE").isBinary(false).build();
    private static final MarshallingInfo<Integer> IDLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IDLE").isBinary(false).build();
    private static final MarshallingInfo<Integer> TERMINATING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TERMINATING").isBinary(false).build();
    private static final EC2InstanceCountsMarshaller INSTANCE = new EC2InstanceCountsMarshaller();

    private EC2InstanceCountsMarshaller() {
    }

    public static EC2InstanceCountsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EC2InstanceCounts ec2InstanceCounts, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)ec2InstanceCounts, (String)"ec2InstanceCounts");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)ec2InstanceCounts.desired(), DESIRED_BINDING);
            protocolMarshaller.marshall((Object)ec2InstanceCounts.minimum(), MINIMUM_BINDING);
            protocolMarshaller.marshall((Object)ec2InstanceCounts.maximum(), MAXIMUM_BINDING);
            protocolMarshaller.marshall((Object)ec2InstanceCounts.pending(), PENDING_BINDING);
            protocolMarshaller.marshall((Object)ec2InstanceCounts.active(), ACTIVE_BINDING);
            protocolMarshaller.marshall((Object)ec2InstanceCounts.idle(), IDLE_BINDING);
            protocolMarshaller.marshall((Object)ec2InstanceCounts.terminating(), TERMINATING_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

