/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.PlayerSessionCreationPolicy;
import software.amazon.awssdk.services.gamelift.model.ProtectionPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateGameSessionRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, UpdateGameSessionRequest> {
    private final String gameSessionId;
    private final Integer maximumPlayerSessionCount;
    private final String name;
    private final String playerSessionCreationPolicy;
    private final String protectionPolicy;

    private UpdateGameSessionRequest(BuilderImpl builder) {
        super(builder);
        this.gameSessionId = builder.gameSessionId;
        this.maximumPlayerSessionCount = builder.maximumPlayerSessionCount;
        this.name = builder.name;
        this.playerSessionCreationPolicy = builder.playerSessionCreationPolicy;
        this.protectionPolicy = builder.protectionPolicy;
    }

    public String gameSessionId() {
        return this.gameSessionId;
    }

    public Integer maximumPlayerSessionCount() {
        return this.maximumPlayerSessionCount;
    }

    public String name() {
        return this.name;
    }

    public PlayerSessionCreationPolicy playerSessionCreationPolicy() {
        return PlayerSessionCreationPolicy.fromValue(this.playerSessionCreationPolicy);
    }

    public String playerSessionCreationPolicyAsString() {
        return this.playerSessionCreationPolicy;
    }

    public ProtectionPolicy protectionPolicy() {
        return ProtectionPolicy.fromValue(this.protectionPolicy);
    }

    public String protectionPolicyAsString() {
        return this.protectionPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumPlayerSessionCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerSessionCreationPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.protectionPolicyAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGameSessionRequest)) {
            return false;
        }
        UpdateGameSessionRequest other = (UpdateGameSessionRequest)((Object)obj);
        return Objects.equals(this.gameSessionId(), other.gameSessionId()) && Objects.equals(this.maximumPlayerSessionCount(), other.maximumPlayerSessionCount()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.playerSessionCreationPolicyAsString(), other.playerSessionCreationPolicyAsString()) && Objects.equals(this.protectionPolicyAsString(), other.protectionPolicyAsString());
    }

    public String toString() {
        return ToString.builder((String)"UpdateGameSessionRequest").add("GameSessionId", (Object)this.gameSessionId()).add("MaximumPlayerSessionCount", (Object)this.maximumPlayerSessionCount()).add("Name", (Object)this.name()).add("PlayerSessionCreationPolicy", (Object)this.playerSessionCreationPolicyAsString()).add("ProtectionPolicy", (Object)this.protectionPolicyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameSessionId": {
                return Optional.ofNullable(clazz.cast(this.gameSessionId()));
            }
            case "MaximumPlayerSessionCount": {
                return Optional.ofNullable(clazz.cast(this.maximumPlayerSessionCount()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "PlayerSessionCreationPolicy": {
                return Optional.ofNullable(clazz.cast(this.playerSessionCreationPolicyAsString()));
            }
            case "ProtectionPolicy": {
                return Optional.ofNullable(clazz.cast(this.protectionPolicyAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String gameSessionId;
        private Integer maximumPlayerSessionCount;
        private String name;
        private String playerSessionCreationPolicy;
        private String protectionPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGameSessionRequest model) {
            super(model);
            this.gameSessionId(model.gameSessionId);
            this.maximumPlayerSessionCount(model.maximumPlayerSessionCount);
            this.name(model.name);
            this.playerSessionCreationPolicy(model.playerSessionCreationPolicy);
            this.protectionPolicy(model.protectionPolicy);
        }

        public final String getGameSessionId() {
            return this.gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        public final Integer getMaximumPlayerSessionCount() {
            return this.maximumPlayerSessionCount;
        }

        @Override
        public final Builder maximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
            return this;
        }

        public final void setMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getPlayerSessionCreationPolicy() {
            return this.playerSessionCreationPolicy;
        }

        @Override
        public final Builder playerSessionCreationPolicy(String playerSessionCreationPolicy) {
            this.playerSessionCreationPolicy = playerSessionCreationPolicy;
            return this;
        }

        @Override
        public final Builder playerSessionCreationPolicy(PlayerSessionCreationPolicy playerSessionCreationPolicy) {
            this.playerSessionCreationPolicy(playerSessionCreationPolicy.toString());
            return this;
        }

        public final void setPlayerSessionCreationPolicy(String playerSessionCreationPolicy) {
            this.playerSessionCreationPolicy = playerSessionCreationPolicy;
        }

        public final String getProtectionPolicy() {
            return this.protectionPolicy;
        }

        @Override
        public final Builder protectionPolicy(String protectionPolicy) {
            this.protectionPolicy = protectionPolicy;
            return this;
        }

        @Override
        public final Builder protectionPolicy(ProtectionPolicy protectionPolicy) {
            this.protectionPolicy(protectionPolicy.toString());
            return this;
        }

        public final void setProtectionPolicy(String protectionPolicy) {
            this.protectionPolicy = protectionPolicy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGameSessionRequest build() {
            return new UpdateGameSessionRequest(this);
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    CopyableBuilder<Builder, UpdateGameSessionRequest> {
        public Builder gameSessionId(String var1);

        public Builder maximumPlayerSessionCount(Integer var1);

        public Builder name(String var1);

        public Builder playerSessionCreationPolicy(String var1);

        public Builder playerSessionCreationPolicy(PlayerSessionCreationPolicy var1);

        public Builder protectionPolicy(String var1);

        public Builder protectionPolicy(ProtectionPolicy var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

