/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.transform.MatchmakingRuleSetMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MatchmakingRuleSet
implements StructuredPojo,
ToCopyableBuilder<Builder, MatchmakingRuleSet> {
    private final String ruleSetName;
    private final String ruleSetBody;
    private final Instant creationTime;

    private MatchmakingRuleSet(BuilderImpl builder) {
        this.ruleSetName = builder.ruleSetName;
        this.ruleSetBody = builder.ruleSetBody;
        this.creationTime = builder.creationTime;
    }

    public String ruleSetName() {
        return this.ruleSetName;
    }

    public String ruleSetBody() {
        return this.ruleSetBody;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleSetBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchmakingRuleSet)) {
            return false;
        }
        MatchmakingRuleSet other = (MatchmakingRuleSet)obj;
        return Objects.equals(this.ruleSetName(), other.ruleSetName()) && Objects.equals(this.ruleSetBody(), other.ruleSetBody()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public String toString() {
        return ToString.builder((String)"MatchmakingRuleSet").add("RuleSetName", (Object)this.ruleSetName()).add("RuleSetBody", (Object)this.ruleSetBody()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleSetName": {
                return Optional.ofNullable(clazz.cast(this.ruleSetName()));
            }
            case "RuleSetBody": {
                return Optional.ofNullable(clazz.cast(this.ruleSetBody()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MatchmakingRuleSetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleSetName;
        private String ruleSetBody;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(MatchmakingRuleSet model) {
            this.ruleSetName(model.ruleSetName);
            this.ruleSetBody(model.ruleSetBody);
            this.creationTime(model.creationTime);
        }

        public final String getRuleSetName() {
            return this.ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        public final String getRuleSetBody() {
            return this.ruleSetBody;
        }

        @Override
        public final Builder ruleSetBody(String ruleSetBody) {
            this.ruleSetBody = ruleSetBody;
            return this;
        }

        public final void setRuleSetBody(String ruleSetBody) {
            this.ruleSetBody = ruleSetBody;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public MatchmakingRuleSet build() {
            return new MatchmakingRuleSet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MatchmakingRuleSet> {
        public Builder ruleSetName(String var1);

        public Builder ruleSetBody(String var1);

        public Builder creationTime(Instant var1);
    }
}

