/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.EventCode;
import software.amazon.awssdk.services.gamelift.transform.EventMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Event
implements StructuredPojo,
ToCopyableBuilder<Builder, Event> {
    private final String eventId;
    private final String resourceId;
    private final String eventCode;
    private final String message;
    private final Instant eventTime;
    private final String preSignedLogUrl;

    private Event(BuilderImpl builder) {
        this.eventId = builder.eventId;
        this.resourceId = builder.resourceId;
        this.eventCode = builder.eventCode;
        this.message = builder.message;
        this.eventTime = builder.eventTime;
        this.preSignedLogUrl = builder.preSignedLogUrl;
    }

    public String eventId() {
        return this.eventId;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public EventCode eventCode() {
        return EventCode.fromValue(this.eventCode);
    }

    public String eventCodeAsString() {
        return this.eventCode;
    }

    public String message() {
        return this.message;
    }

    public Instant eventTime() {
        return this.eventTime;
    }

    public String preSignedLogUrl() {
        return this.preSignedLogUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.preSignedLogUrl());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        return Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.eventCodeAsString(), other.eventCodeAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.eventTime(), other.eventTime()) && Objects.equals(this.preSignedLogUrl(), other.preSignedLogUrl());
    }

    public String toString() {
        return ToString.builder((String)"Event").add("EventId", (Object)this.eventId()).add("ResourceId", (Object)this.resourceId()).add("EventCode", (Object)this.eventCodeAsString()).add("Message", (Object)this.message()).add("EventTime", (Object)this.eventTime()).add("PreSignedLogUrl", (Object)this.preSignedLogUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "EventCode": {
                return Optional.ofNullable(clazz.cast(this.eventCodeAsString()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "EventTime": {
                return Optional.ofNullable(clazz.cast(this.eventTime()));
            }
            case "PreSignedLogUrl": {
                return Optional.ofNullable(clazz.cast(this.preSignedLogUrl()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventId;
        private String resourceId;
        private String eventCode;
        private String message;
        private Instant eventTime;
        private String preSignedLogUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(Event model) {
            this.eventId(model.eventId);
            this.resourceId(model.resourceId);
            this.eventCode(model.eventCode);
            this.message(model.message);
            this.eventTime(model.eventTime);
            this.preSignedLogUrl(model.preSignedLogUrl);
        }

        public final String getEventId() {
            return this.eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getEventCode() {
            return this.eventCode;
        }

        @Override
        public final Builder eventCode(String eventCode) {
            this.eventCode = eventCode;
            return this;
        }

        @Override
        public final Builder eventCode(EventCode eventCode) {
            this.eventCode(eventCode.toString());
            return this;
        }

        public final void setEventCode(String eventCode) {
            this.eventCode = eventCode;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Instant getEventTime() {
            return this.eventTime;
        }

        @Override
        public final Builder eventTime(Instant eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public final void setEventTime(Instant eventTime) {
            this.eventTime = eventTime;
        }

        public final String getPreSignedLogUrl() {
            return this.preSignedLogUrl;
        }

        @Override
        public final Builder preSignedLogUrl(String preSignedLogUrl) {
            this.preSignedLogUrl = preSignedLogUrl;
            return this;
        }

        public final void setPreSignedLogUrl(String preSignedLogUrl) {
            this.preSignedLogUrl = preSignedLogUrl;
        }

        public Event build() {
            return new Event(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Event> {
        public Builder eventId(String var1);

        public Builder resourceId(String var1);

        public Builder eventCode(String var1);

        public Builder eventCode(EventCode var1);

        public Builder message(String var1);

        public Builder eventTime(Instant var1);

        public Builder preSignedLogUrl(String var1);
    }
}

