/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.EC2InstanceType;
import software.amazon.awssdk.services.gamelift.transform.EC2InstanceLimitMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EC2InstanceLimit
implements StructuredPojo,
ToCopyableBuilder<Builder, EC2InstanceLimit> {
    private final String ec2InstanceType;
    private final Integer currentInstances;
    private final Integer instanceLimit;

    private EC2InstanceLimit(BuilderImpl builder) {
        this.ec2InstanceType = builder.ec2InstanceType;
        this.currentInstances = builder.currentInstances;
        this.instanceLimit = builder.instanceLimit;
    }

    public EC2InstanceType ec2InstanceType() {
        return EC2InstanceType.fromValue(this.ec2InstanceType);
    }

    public String ec2InstanceTypeAsString() {
        return this.ec2InstanceType;
    }

    public Integer currentInstances() {
        return this.currentInstances;
    }

    public Integer instanceLimit() {
        return this.instanceLimit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentInstances());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceLimit());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2InstanceLimit)) {
            return false;
        }
        EC2InstanceLimit other = (EC2InstanceLimit)obj;
        return Objects.equals(this.ec2InstanceTypeAsString(), other.ec2InstanceTypeAsString()) && Objects.equals(this.currentInstances(), other.currentInstances()) && Objects.equals(this.instanceLimit(), other.instanceLimit());
    }

    public String toString() {
        return ToString.builder((String)"EC2InstanceLimit").add("EC2InstanceType", (Object)this.ec2InstanceTypeAsString()).add("CurrentInstances", (Object)this.currentInstances()).add("InstanceLimit", (Object)this.instanceLimit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EC2InstanceType": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceTypeAsString()));
            }
            case "CurrentInstances": {
                return Optional.ofNullable(clazz.cast(this.currentInstances()));
            }
            case "InstanceLimit": {
                return Optional.ofNullable(clazz.cast(this.instanceLimit()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EC2InstanceLimitMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String ec2InstanceType;
        private Integer currentInstances;
        private Integer instanceLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(EC2InstanceLimit model) {
            this.ec2InstanceType(model.ec2InstanceType);
            this.currentInstances(model.currentInstances);
            this.instanceLimit(model.instanceLimit);
        }

        public final String getEC2InstanceType() {
            return this.ec2InstanceType;
        }

        @Override
        public final Builder ec2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
            return this;
        }

        @Override
        public final Builder ec2InstanceType(EC2InstanceType ec2InstanceType) {
            this.ec2InstanceType(ec2InstanceType.toString());
            return this;
        }

        public final void setEC2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
        }

        public final Integer getCurrentInstances() {
            return this.currentInstances;
        }

        @Override
        public final Builder currentInstances(Integer currentInstances) {
            this.currentInstances = currentInstances;
            return this;
        }

        public final void setCurrentInstances(Integer currentInstances) {
            this.currentInstances = currentInstances;
        }

        public final Integer getInstanceLimit() {
            return this.instanceLimit;
        }

        @Override
        public final Builder instanceLimit(Integer instanceLimit) {
            this.instanceLimit = instanceLimit;
            return this;
        }

        public final void setInstanceLimit(Integer instanceLimit) {
            this.instanceLimit = instanceLimit;
        }

        public EC2InstanceLimit build() {
            return new EC2InstanceLimit(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EC2InstanceLimit> {
        public Builder ec2InstanceType(String var1);

        public Builder ec2InstanceType(EC2InstanceType var1);

        public Builder currentInstances(Integer var1);

        public Builder instanceLimit(Integer var1);
    }
}

