/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteVpcPeeringConnectionRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, DeleteVpcPeeringConnectionRequest> {
    private final String fleetId;
    private final String vpcPeeringConnectionId;

    private DeleteVpcPeeringConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public String vpcPeeringConnectionId() {
        return this.vpcPeeringConnectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcPeeringConnectionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVpcPeeringConnectionRequest)) {
            return false;
        }
        DeleteVpcPeeringConnectionRequest other = (DeleteVpcPeeringConnectionRequest)((Object)obj);
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.vpcPeeringConnectionId(), other.vpcPeeringConnectionId());
    }

    public String toString() {
        return ToString.builder((String)"DeleteVpcPeeringConnectionRequest").add("FleetId", (Object)this.fleetId()).add("VpcPeeringConnectionId", (Object)this.vpcPeeringConnectionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "VpcPeeringConnectionId": {
                return Optional.ofNullable(clazz.cast(this.vpcPeeringConnectionId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String fleetId;
        private String vpcPeeringConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVpcPeeringConnectionRequest model) {
            super(model);
            this.fleetId(model.fleetId);
            this.vpcPeeringConnectionId(model.vpcPeeringConnectionId);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getVpcPeeringConnectionId() {
            return this.vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteVpcPeeringConnectionRequest build() {
            return new DeleteVpcPeeringConnectionRequest(this);
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    CopyableBuilder<Builder, DeleteVpcPeeringConnectionRequest> {
        public Builder fleetId(String var1);

        public Builder vpcPeeringConnectionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

