/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.services.gamelift.model.PlayerSession;
import software.amazon.awssdk.services.gamelift.model.PlayerSessionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePlayerSessionsResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, CreatePlayerSessionsResponse> {
    private final List<PlayerSession> playerSessions;

    private CreatePlayerSessionsResponse(BuilderImpl builder) {
        super(builder);
        this.playerSessions = builder.playerSessions;
    }

    public List<PlayerSession> playerSessions() {
        return this.playerSessions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.playerSessions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlayerSessionsResponse)) {
            return false;
        }
        CreatePlayerSessionsResponse other = (CreatePlayerSessionsResponse)((Object)obj);
        return Objects.equals(this.playerSessions(), other.playerSessions());
    }

    public String toString() {
        return ToString.builder((String)"CreatePlayerSessionsResponse").add("PlayerSessions", this.playerSessions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlayerSessions": {
                return Optional.ofNullable(clazz.cast(this.playerSessions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private List<PlayerSession> playerSessions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlayerSessionsResponse model) {
            super(model);
            this.playerSessions(model.playerSessions);
        }

        public final Collection<PlayerSession.Builder> getPlayerSessions() {
            return this.playerSessions != null ? (Collection)this.playerSessions.stream().map(PlayerSession::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder playerSessions(Collection<PlayerSession> playerSessions) {
            this.playerSessions = PlayerSessionListCopier.copy(playerSessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playerSessions(PlayerSession ... playerSessions) {
            this.playerSessions(Arrays.asList(playerSessions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playerSessions(Consumer<PlayerSession.Builder> ... playerSessions) {
            this.playerSessions(Stream.of(playerSessions).map(c -> (PlayerSession)((PlayerSession.Builder)PlayerSession.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPlayerSessions(Collection<PlayerSession.BuilderImpl> playerSessions) {
            this.playerSessions = PlayerSessionListCopier.copyFromBuilder(playerSessions);
        }

        @Override
        public CreatePlayerSessionsResponse build() {
            return new CreatePlayerSessionsResponse(this);
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    CopyableBuilder<Builder, CreatePlayerSessionsResponse> {
        public Builder playerSessions(Collection<PlayerSession> var1);

        public Builder playerSessions(PlayerSession ... var1);

        public Builder playerSessions(Consumer<PlayerSession.Builder> ... var1);
    }
}

