/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.AcceptanceType;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.MatchmakingPlayerIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AcceptMatchRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, AcceptMatchRequest> {
    private final String ticketId;
    private final List<String> playerIds;
    private final String acceptanceType;

    private AcceptMatchRequest(BuilderImpl builder) {
        super(builder);
        this.ticketId = builder.ticketId;
        this.playerIds = builder.playerIds;
        this.acceptanceType = builder.acceptanceType;
    }

    public String ticketId() {
        return this.ticketId;
    }

    public List<String> playerIds() {
        return this.playerIds;
    }

    public AcceptanceType acceptanceType() {
        return AcceptanceType.fromValue(this.acceptanceType);
    }

    public String acceptanceTypeAsString() {
        return this.acceptanceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ticketId());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptanceTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptMatchRequest)) {
            return false;
        }
        AcceptMatchRequest other = (AcceptMatchRequest)((Object)obj);
        return Objects.equals(this.ticketId(), other.ticketId()) && Objects.equals(this.playerIds(), other.playerIds()) && Objects.equals(this.acceptanceTypeAsString(), other.acceptanceTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"AcceptMatchRequest").add("TicketId", (Object)this.ticketId()).add("PlayerIds", this.playerIds()).add("AcceptanceType", (Object)this.acceptanceTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TicketId": {
                return Optional.ofNullable(clazz.cast(this.ticketId()));
            }
            case "PlayerIds": {
                return Optional.ofNullable(clazz.cast(this.playerIds()));
            }
            case "AcceptanceType": {
                return Optional.ofNullable(clazz.cast(this.acceptanceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String ticketId;
        private List<String> playerIds = DefaultSdkAutoConstructList.getInstance();
        private String acceptanceType;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptMatchRequest model) {
            super(model);
            this.ticketId(model.ticketId);
            this.playerIds(model.playerIds);
            this.acceptanceType(model.acceptanceType);
        }

        public final String getTicketId() {
            return this.ticketId;
        }

        @Override
        public final Builder ticketId(String ticketId) {
            this.ticketId = ticketId;
            return this;
        }

        public final void setTicketId(String ticketId) {
            this.ticketId = ticketId;
        }

        public final Collection<String> getPlayerIds() {
            return this.playerIds;
        }

        @Override
        public final Builder playerIds(Collection<String> playerIds) {
            this.playerIds = MatchmakingPlayerIdListCopier.copy(playerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playerIds(String ... playerIds) {
            this.playerIds(Arrays.asList(playerIds));
            return this;
        }

        public final void setPlayerIds(Collection<String> playerIds) {
            this.playerIds = MatchmakingPlayerIdListCopier.copy(playerIds);
        }

        public final String getAcceptanceType() {
            return this.acceptanceType;
        }

        @Override
        public final Builder acceptanceType(String acceptanceType) {
            this.acceptanceType = acceptanceType;
            return this;
        }

        @Override
        public final Builder acceptanceType(AcceptanceType acceptanceType) {
            this.acceptanceType(acceptanceType.toString());
            return this;
        }

        public final void setAcceptanceType(String acceptanceType) {
            this.acceptanceType = acceptanceType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AcceptMatchRequest build() {
            return new AcceptMatchRequest(this);
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    CopyableBuilder<Builder, AcceptMatchRequest> {
        public Builder ticketId(String var1);

        public Builder playerIds(Collection<String> var1);

        public Builder playerIds(String ... var1);

        public Builder acceptanceType(String var1);

        public Builder acceptanceType(AcceptanceType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

