/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.gamelift.model.VpcPeeringConnection;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class VpcPeeringConnectionMarshaller {
    private static final MarshallingInfo<String> FLEETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FleetId").isBinary(false).build();
    private static final MarshallingInfo<String> IPV4CIDRBLOCK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IpV4CidrBlock").isBinary(false).build();
    private static final MarshallingInfo<String> VPCPEERINGCONNECTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcPeeringConnectionId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<String> PEERVPCID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PeerVpcId").isBinary(false).build();
    private static final MarshallingInfo<String> GAMELIFTVPCID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GameLiftVpcId").isBinary(false).build();
    private static final VpcPeeringConnectionMarshaller INSTANCE = new VpcPeeringConnectionMarshaller();

    private VpcPeeringConnectionMarshaller() {
    }

    public static VpcPeeringConnectionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(VpcPeeringConnection vpcPeeringConnection, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)vpcPeeringConnection, (String)"vpcPeeringConnection");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)vpcPeeringConnection.fleetId(), FLEETID_BINDING);
            protocolMarshaller.marshall((Object)vpcPeeringConnection.ipV4CidrBlock(), IPV4CIDRBLOCK_BINDING);
            protocolMarshaller.marshall((Object)vpcPeeringConnection.vpcPeeringConnectionId(), VPCPEERINGCONNECTIONID_BINDING);
            protocolMarshaller.marshall((Object)vpcPeeringConnection.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)vpcPeeringConnection.peerVpcId(), PEERVPCID_BINDING);
            protocolMarshaller.marshall((Object)vpcPeeringConnection.gameLiftVpcId(), GAMELIFTVPCID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

