/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.gamelift.model.StartGameSessionPlacementRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StartGameSessionPlacementRequestModelMarshaller {
    private static final MarshallingInfo<String> PLACEMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlacementId").isBinary(false).build();
    private static final MarshallingInfo<String> GAMESESSIONQUEUENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GameSessionQueueName").isBinary(false).build();
    private static final MarshallingInfo<List> GAMEPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GameProperties").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXIMUMPLAYERSESSIONCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaximumPlayerSessionCount").isBinary(false).build();
    private static final MarshallingInfo<String> GAMESESSIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GameSessionName").isBinary(false).build();
    private static final MarshallingInfo<List> PLAYERLATENCIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlayerLatencies").isBinary(false).build();
    private static final MarshallingInfo<List> DESIREDPLAYERSESSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DesiredPlayerSessions").isBinary(false).build();
    private static final MarshallingInfo<String> GAMESESSIONDATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GameSessionData").isBinary(false).build();
    private static final StartGameSessionPlacementRequestModelMarshaller INSTANCE = new StartGameSessionPlacementRequestModelMarshaller();

    private StartGameSessionPlacementRequestModelMarshaller() {
    }

    public static StartGameSessionPlacementRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StartGameSessionPlacementRequest startGameSessionPlacementRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)startGameSessionPlacementRequest), (String)"startGameSessionPlacementRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)startGameSessionPlacementRequest.placementId(), PLACEMENTID_BINDING);
            protocolMarshaller.marshall((Object)startGameSessionPlacementRequest.gameSessionQueueName(), GAMESESSIONQUEUENAME_BINDING);
            protocolMarshaller.marshall(startGameSessionPlacementRequest.gameProperties(), GAMEPROPERTIES_BINDING);
            protocolMarshaller.marshall((Object)startGameSessionPlacementRequest.maximumPlayerSessionCount(), MAXIMUMPLAYERSESSIONCOUNT_BINDING);
            protocolMarshaller.marshall((Object)startGameSessionPlacementRequest.gameSessionName(), GAMESESSIONNAME_BINDING);
            protocolMarshaller.marshall(startGameSessionPlacementRequest.playerLatencies(), PLAYERLATENCIES_BINDING);
            protocolMarshaller.marshall(startGameSessionPlacementRequest.desiredPlayerSessions(), DESIREDPLAYERSESSIONS_BINDING);
            protocolMarshaller.marshall((Object)startGameSessionPlacementRequest.gameSessionData(), GAMESESSIONDATA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

