/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.gamelift.model.PlayerSession;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PlayerSessionMarshaller {
    private static final MarshallingInfo<String> PLAYERSESSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlayerSessionId").isBinary(false).build();
    private static final MarshallingInfo<String> PLAYERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlayerId").isBinary(false).build();
    private static final MarshallingInfo<String> GAMESESSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GameSessionId").isBinary(false).build();
    private static final MarshallingInfo<String> FLEETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FleetId").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> TERMINATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TerminationTime").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<String> IPADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IpAddress").isBinary(false).build();
    private static final MarshallingInfo<Integer> PORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Port").isBinary(false).build();
    private static final MarshallingInfo<String> PLAYERDATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlayerData").isBinary(false).build();
    private static final PlayerSessionMarshaller INSTANCE = new PlayerSessionMarshaller();

    private PlayerSessionMarshaller() {
    }

    public static PlayerSessionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PlayerSession playerSession, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)playerSession, (String)"playerSession");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)playerSession.playerSessionId(), PLAYERSESSIONID_BINDING);
            protocolMarshaller.marshall((Object)playerSession.playerId(), PLAYERID_BINDING);
            protocolMarshaller.marshall((Object)playerSession.gameSessionId(), GAMESESSIONID_BINDING);
            protocolMarshaller.marshall((Object)playerSession.fleetId(), FLEETID_BINDING);
            protocolMarshaller.marshall((Object)playerSession.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)playerSession.terminationTime(), TERMINATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)playerSession.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)playerSession.ipAddress(), IPADDRESS_BINDING);
            protocolMarshaller.marshall((Object)playerSession.port(), PORT_BINDING);
            protocolMarshaller.marshall((Object)playerSession.playerData(), PLAYERDATA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

