/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.gamelift.model.MatchmakingRuleSet;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MatchmakingRuleSetMarshaller {
    private static final MarshallingInfo<String> RULESETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RuleSetName").isBinary(false).build();
    private static final MarshallingInfo<String> RULESETBODY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RuleSetBody").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").isBinary(false).build();
    private static final MatchmakingRuleSetMarshaller INSTANCE = new MatchmakingRuleSetMarshaller();

    private MatchmakingRuleSetMarshaller() {
    }

    public static MatchmakingRuleSetMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MatchmakingRuleSet matchmakingRuleSet, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)matchmakingRuleSet, (String)"matchmakingRuleSet");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)matchmakingRuleSet.ruleSetName(), RULESETNAME_BINDING);
            protocolMarshaller.marshall((Object)matchmakingRuleSet.ruleSetBody(), RULESETBODY_BINDING);
            protocolMarshaller.marshall((Object)matchmakingRuleSet.creationTime(), CREATIONTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

