/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EventCode {
    GENERIC_EVENT("GENERIC_EVENT"),
    FLEET_CREATED("FLEET_CREATED"),
    FLEET_DELETED("FLEET_DELETED"),
    FLEET_SCALING_EVENT("FLEET_SCALING_EVENT"),
    FLEET_STATE_DOWNLOADING("FLEET_STATE_DOWNLOADING"),
    FLEET_STATE_VALIDATING("FLEET_STATE_VALIDATING"),
    FLEET_STATE_BUILDING("FLEET_STATE_BUILDING"),
    FLEET_STATE_ACTIVATING("FLEET_STATE_ACTIVATING"),
    FLEET_STATE_ACTIVE("FLEET_STATE_ACTIVE"),
    FLEET_STATE_ERROR("FLEET_STATE_ERROR"),
    FLEET_INITIALIZATION_FAILED("FLEET_INITIALIZATION_FAILED"),
    FLEET_BINARY_DOWNLOAD_FAILED("FLEET_BINARY_DOWNLOAD_FAILED"),
    FLEET_VALIDATION_LAUNCH_PATH_NOT_FOUND("FLEET_VALIDATION_LAUNCH_PATH_NOT_FOUND"),
    FLEET_VALIDATION_EXECUTABLE_RUNTIME_FAILURE("FLEET_VALIDATION_EXECUTABLE_RUNTIME_FAILURE"),
    FLEET_VALIDATION_TIMED_OUT("FLEET_VALIDATION_TIMED_OUT"),
    FLEET_ACTIVATION_FAILED("FLEET_ACTIVATION_FAILED"),
    FLEET_ACTIVATION_FAILED_NO_INSTANCES("FLEET_ACTIVATION_FAILED_NO_INSTANCES"),
    FLEET_NEW_GAME_SESSION_PROTECTION_POLICY_UPDATED("FLEET_NEW_GAME_SESSION_PROTECTION_POLICY_UPDATED"),
    SERVER_PROCESS_INVALID_PATH("SERVER_PROCESS_INVALID_PATH"),
    SERVER_PROCESS_SDK_INITIALIZATION_TIMEOUT("SERVER_PROCESS_SDK_INITIALIZATION_TIMEOUT"),
    SERVER_PROCESS_PROCESS_READY_TIMEOUT("SERVER_PROCESS_PROCESS_READY_TIMEOUT"),
    SERVER_PROCESS_CRASHED("SERVER_PROCESS_CRASHED"),
    SERVER_PROCESS_TERMINATED_UNHEALTHY("SERVER_PROCESS_TERMINATED_UNHEALTHY"),
    SERVER_PROCESS_FORCE_TERMINATED("SERVER_PROCESS_FORCE_TERMINATED"),
    SERVER_PROCESS_PROCESS_EXIT_TIMEOUT("SERVER_PROCESS_PROCESS_EXIT_TIMEOUT"),
    GAME_SESSION_ACTIVATION_TIMEOUT("GAME_SESSION_ACTIVATION_TIMEOUT"),
    FLEET_CREATION_EXTRACTING_BUILD("FLEET_CREATION_EXTRACTING_BUILD"),
    FLEET_CREATION_RUNNING_INSTALLER("FLEET_CREATION_RUNNING_INSTALLER"),
    FLEET_CREATION_VALIDATING_RUNTIME_CONFIG("FLEET_CREATION_VALIDATING_RUNTIME_CONFIG"),
    FLEET_VPC_PEERING_SUCCEEDED("FLEET_VPC_PEERING_SUCCEEDED"),
    FLEET_VPC_PEERING_FAILED("FLEET_VPC_PEERING_FAILED"),
    FLEET_VPC_PEERING_DELETED("FLEET_VPC_PEERING_DELETED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EventCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EventCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventCode> knownValues() {
        return Stream.of(EventCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

