/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.MatchmakingIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeMatchmakingRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, DescribeMatchmakingRequest> {
    private final List<String> ticketIds;

    private DescribeMatchmakingRequest(BuilderImpl builder) {
        super(builder);
        this.ticketIds = builder.ticketIds;
    }

    public List<String> ticketIds() {
        return this.ticketIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ticketIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMatchmakingRequest)) {
            return false;
        }
        DescribeMatchmakingRequest other = (DescribeMatchmakingRequest)((Object)obj);
        return Objects.equals(this.ticketIds(), other.ticketIds());
    }

    public String toString() {
        return ToString.builder((String)"DescribeMatchmakingRequest").add("TicketIds", this.ticketIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TicketIds": {
                return Optional.of(clazz.cast(this.ticketIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private List<String> ticketIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMatchmakingRequest model) {
            super(model);
            this.ticketIds(model.ticketIds);
        }

        public final Collection<String> getTicketIds() {
            return this.ticketIds;
        }

        @Override
        public final Builder ticketIds(Collection<String> ticketIds) {
            this.ticketIds = MatchmakingIdListCopier.copy(ticketIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ticketIds(String ... ticketIds) {
            this.ticketIds(Arrays.asList(ticketIds));
            return this;
        }

        public final void setTicketIds(Collection<String> ticketIds) {
            this.ticketIds = MatchmakingIdListCopier.copy(ticketIds);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeMatchmakingRequest build() {
            return new DescribeMatchmakingRequest(this);
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    CopyableBuilder<Builder, DescribeMatchmakingRequest> {
        public Builder ticketIds(Collection<String> var1);

        public Builder ticketIds(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

