/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.services.gamelift.model.GameSession;
import software.amazon.awssdk.services.gamelift.model.GameSessionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeGameSessionsResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, DescribeGameSessionsResponse> {
    private final List<GameSession> gameSessions;
    private final String nextToken;

    private DescribeGameSessionsResponse(BuilderImpl builder) {
        super(builder);
        this.gameSessions = builder.gameSessions;
        this.nextToken = builder.nextToken;
    }

    public List<GameSession> gameSessions() {
        return this.gameSessions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGameSessionsResponse)) {
            return false;
        }
        DescribeGameSessionsResponse other = (DescribeGameSessionsResponse)((Object)obj);
        return Objects.equals(this.gameSessions(), other.gameSessions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeGameSessionsResponse").add("GameSessions", this.gameSessions()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameSessions": {
                return Optional.of(clazz.cast(this.gameSessions()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private List<GameSession> gameSessions;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGameSessionsResponse model) {
            super(model);
            this.gameSessions(model.gameSessions);
            this.nextToken(model.nextToken);
        }

        public final Collection<GameSession.Builder> getGameSessions() {
            return this.gameSessions != null ? (Collection)this.gameSessions.stream().map(GameSession::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder gameSessions(Collection<GameSession> gameSessions) {
            this.gameSessions = GameSessionListCopier.copy(gameSessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameSessions(GameSession ... gameSessions) {
            this.gameSessions(Arrays.asList(gameSessions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameSessions(Consumer<GameSession.Builder> ... gameSessions) {
            this.gameSessions(Stream.of(gameSessions).map(c -> (GameSession)((GameSession.Builder)GameSession.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGameSessions(Collection<GameSession.BuilderImpl> gameSessions) {
            this.gameSessions = GameSessionListCopier.copyFromBuilder(gameSessions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeGameSessionsResponse build() {
            return new DescribeGameSessionsResponse(this);
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    CopyableBuilder<Builder, DescribeGameSessionsResponse> {
        public Builder gameSessions(Collection<GameSession> var1);

        public Builder gameSessions(GameSession ... var1);

        public Builder gameSessions(Consumer<GameSession.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

