/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.services.gamelift.model.GameSessionQueue;
import software.amazon.awssdk.services.gamelift.model.GameSessionQueueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeGameSessionQueuesResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, DescribeGameSessionQueuesResponse> {
    private final List<GameSessionQueue> gameSessionQueues;
    private final String nextToken;

    private DescribeGameSessionQueuesResponse(BuilderImpl builder) {
        super(builder);
        this.gameSessionQueues = builder.gameSessionQueues;
        this.nextToken = builder.nextToken;
    }

    public List<GameSessionQueue> gameSessionQueues() {
        return this.gameSessionQueues;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionQueues());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGameSessionQueuesResponse)) {
            return false;
        }
        DescribeGameSessionQueuesResponse other = (DescribeGameSessionQueuesResponse)((Object)obj);
        return Objects.equals(this.gameSessionQueues(), other.gameSessionQueues()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeGameSessionQueuesResponse").add("GameSessionQueues", this.gameSessionQueues()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameSessionQueues": {
                return Optional.of(clazz.cast(this.gameSessionQueues()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private List<GameSessionQueue> gameSessionQueues;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGameSessionQueuesResponse model) {
            super(model);
            this.gameSessionQueues(model.gameSessionQueues);
            this.nextToken(model.nextToken);
        }

        public final Collection<GameSessionQueue.Builder> getGameSessionQueues() {
            return this.gameSessionQueues != null ? (Collection)this.gameSessionQueues.stream().map(GameSessionQueue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder gameSessionQueues(Collection<GameSessionQueue> gameSessionQueues) {
            this.gameSessionQueues = GameSessionQueueListCopier.copy(gameSessionQueues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameSessionQueues(GameSessionQueue ... gameSessionQueues) {
            this.gameSessionQueues(Arrays.asList(gameSessionQueues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameSessionQueues(Consumer<GameSessionQueue.Builder> ... gameSessionQueues) {
            this.gameSessionQueues(Stream.of(gameSessionQueues).map(c -> (GameSessionQueue)((GameSessionQueue.Builder)GameSessionQueue.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGameSessionQueues(Collection<GameSessionQueue.BuilderImpl> gameSessionQueues) {
            this.gameSessionQueues = GameSessionQueueListCopier.copyFromBuilder(gameSessionQueues);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeGameSessionQueuesResponse build() {
            return new DescribeGameSessionQueuesResponse(this);
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    CopyableBuilder<Builder, DescribeGameSessionQueuesResponse> {
        public Builder gameSessionQueues(Collection<GameSessionQueue> var1);

        public Builder gameSessionQueues(GameSessionQueue ... var1);

        public Builder gameSessionQueues(Consumer<GameSessionQueue.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

