/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.gamelift.model.FleetCapacity;
import software.amazon.awssdk.services.gamelift.model.FleetCapacityListCopier;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeFleetCapacityResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, DescribeFleetCapacityResponse> {
    private final List<FleetCapacity> fleetCapacity;
    private final String nextToken;

    private DescribeFleetCapacityResponse(BuilderImpl builder) {
        super(builder);
        this.fleetCapacity = builder.fleetCapacity;
        this.nextToken = builder.nextToken;
    }

    public List<FleetCapacity> fleetCapacity() {
        return this.fleetCapacity;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetCapacityResponse)) {
            return false;
        }
        DescribeFleetCapacityResponse other = (DescribeFleetCapacityResponse)((Object)obj);
        return Objects.equals(this.fleetCapacity(), other.fleetCapacity()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeFleetCapacityResponse").add("FleetCapacity", this.fleetCapacity()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetCapacity": {
                return Optional.of(clazz.cast(this.fleetCapacity()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private List<FleetCapacity> fleetCapacity;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetCapacityResponse model) {
            super(model);
            this.fleetCapacity(model.fleetCapacity);
            this.nextToken(model.nextToken);
        }

        public final Collection<FleetCapacity.Builder> getFleetCapacity() {
            return this.fleetCapacity != null ? (Collection)this.fleetCapacity.stream().map(FleetCapacity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fleetCapacity(Collection<FleetCapacity> fleetCapacity) {
            this.fleetCapacity = FleetCapacityListCopier.copy(fleetCapacity);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetCapacity(FleetCapacity ... fleetCapacity) {
            this.fleetCapacity(Arrays.asList(fleetCapacity));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetCapacity(Consumer<FleetCapacity.Builder> ... fleetCapacity) {
            this.fleetCapacity(Stream.of(fleetCapacity).map(c -> (FleetCapacity)((FleetCapacity.Builder)FleetCapacity.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFleetCapacity(Collection<FleetCapacity.BuilderImpl> fleetCapacity) {
            this.fleetCapacity = FleetCapacityListCopier.copyFromBuilder(fleetCapacity);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeFleetCapacityResponse build() {
            return new DescribeFleetCapacityResponse(this);
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    CopyableBuilder<Builder, DescribeFleetCapacityResponse> {
        public Builder fleetCapacity(Collection<FleetCapacity> var1);

        public Builder fleetCapacity(FleetCapacity ... var1);

        public Builder fleetCapacity(Consumer<FleetCapacity.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

