/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.CreateFileSystemLustreConfiguration;
import software.amazon.awssdk.services.fsx.model.CreateFileSystemWindowsConfiguration;
import software.amazon.awssdk.services.fsx.model.FSxRequest;
import software.amazon.awssdk.services.fsx.model.FileSystemType;
import software.amazon.awssdk.services.fsx.model.SecurityGroupIdsCopier;
import software.amazon.awssdk.services.fsx.model.SubnetIdsCopier;
import software.amazon.awssdk.services.fsx.model.Tag;
import software.amazon.awssdk.services.fsx.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFileSystemRequest
extends FSxRequest
implements ToCopyableBuilder<Builder, CreateFileSystemRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateFileSystemRequest.getter(CreateFileSystemRequest::clientRequestToken)).setter(CreateFileSystemRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> FILE_SYSTEM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateFileSystemRequest.getter(CreateFileSystemRequest::fileSystemTypeAsString)).setter(CreateFileSystemRequest.setter(Builder::fileSystemType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemType").build()}).build();
    private static final SdkField<Integer> STORAGE_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateFileSystemRequest.getter(CreateFileSystemRequest::storageCapacity)).setter(CreateFileSystemRequest.setter(Builder::storageCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageCapacity").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateFileSystemRequest.getter(CreateFileSystemRequest::subnetIds)).setter(CreateFileSystemRequest.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateFileSystemRequest.getter(CreateFileSystemRequest::securityGroupIds)).setter(CreateFileSystemRequest.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateFileSystemRequest.getter(CreateFileSystemRequest::tags)).setter(CreateFileSystemRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateFileSystemRequest.getter(CreateFileSystemRequest::kmsKeyId)).setter(CreateFileSystemRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<CreateFileSystemWindowsConfiguration> WINDOWS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateFileSystemRequest.getter(CreateFileSystemRequest::windowsConfiguration)).setter(CreateFileSystemRequest.setter(Builder::windowsConfiguration)).constructor(CreateFileSystemWindowsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowsConfiguration").build()}).build();
    private static final SdkField<CreateFileSystemLustreConfiguration> LUSTRE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateFileSystemRequest.getter(CreateFileSystemRequest::lustreConfiguration)).setter(CreateFileSystemRequest.setter(Builder::lustreConfiguration)).constructor(CreateFileSystemLustreConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LustreConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD, FILE_SYSTEM_TYPE_FIELD, STORAGE_CAPACITY_FIELD, SUBNET_IDS_FIELD, SECURITY_GROUP_IDS_FIELD, TAGS_FIELD, KMS_KEY_ID_FIELD, WINDOWS_CONFIGURATION_FIELD, LUSTRE_CONFIGURATION_FIELD));
    private final String clientRequestToken;
    private final String fileSystemType;
    private final Integer storageCapacity;
    private final List<String> subnetIds;
    private final List<String> securityGroupIds;
    private final List<Tag> tags;
    private final String kmsKeyId;
    private final CreateFileSystemWindowsConfiguration windowsConfiguration;
    private final CreateFileSystemLustreConfiguration lustreConfiguration;

    private CreateFileSystemRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.fileSystemType = builder.fileSystemType;
        this.storageCapacity = builder.storageCapacity;
        this.subnetIds = builder.subnetIds;
        this.securityGroupIds = builder.securityGroupIds;
        this.tags = builder.tags;
        this.kmsKeyId = builder.kmsKeyId;
        this.windowsConfiguration = builder.windowsConfiguration;
        this.lustreConfiguration = builder.lustreConfiguration;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public FileSystemType fileSystemType() {
        return FileSystemType.fromValue(this.fileSystemType);
    }

    public String fileSystemTypeAsString() {
        return this.fileSystemType;
    }

    public Integer storageCapacity() {
        return this.storageCapacity;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public CreateFileSystemWindowsConfiguration windowsConfiguration() {
        return this.windowsConfiguration;
    }

    public CreateFileSystemLustreConfiguration lustreConfiguration() {
        return this.lustreConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.windowsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.lustreConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFileSystemRequest)) {
            return false;
        }
        CreateFileSystemRequest other = (CreateFileSystemRequest)((Object)obj);
        return Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.fileSystemTypeAsString(), other.fileSystemTypeAsString()) && Objects.equals(this.storageCapacity(), other.storageCapacity()) && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.windowsConfiguration(), other.windowsConfiguration()) && Objects.equals(this.lustreConfiguration(), other.lustreConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"CreateFileSystemRequest").add("ClientRequestToken", (Object)this.clientRequestToken()).add("FileSystemType", (Object)this.fileSystemTypeAsString()).add("StorageCapacity", (Object)this.storageCapacity()).add("SubnetIds", this.subnetIds()).add("SecurityGroupIds", this.securityGroupIds()).add("Tags", this.tags()).add("KmsKeyId", (Object)this.kmsKeyId()).add("WindowsConfiguration", (Object)this.windowsConfiguration()).add("LustreConfiguration", (Object)this.lustreConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "FileSystemType": {
                return Optional.ofNullable(clazz.cast(this.fileSystemTypeAsString()));
            }
            case "StorageCapacity": {
                return Optional.ofNullable(clazz.cast(this.storageCapacity()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "WindowsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.windowsConfiguration()));
            }
            case "LustreConfiguration": {
                return Optional.ofNullable(clazz.cast(this.lustreConfiguration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFileSystemRequest, T> g) {
        return obj -> g.apply((CreateFileSystemRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxRequest.BuilderImpl
    implements Builder {
        private String clientRequestToken;
        private String fileSystemType;
        private Integer storageCapacity;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String kmsKeyId;
        private CreateFileSystemWindowsConfiguration windowsConfiguration;
        private CreateFileSystemLustreConfiguration lustreConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFileSystemRequest model) {
            super(model);
            this.clientRequestToken(model.clientRequestToken);
            this.fileSystemType(model.fileSystemType);
            this.storageCapacity(model.storageCapacity);
            this.subnetIds(model.subnetIds);
            this.securityGroupIds(model.securityGroupIds);
            this.tags(model.tags);
            this.kmsKeyId(model.kmsKeyId);
            this.windowsConfiguration(model.windowsConfiguration);
            this.lustreConfiguration(model.lustreConfiguration);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getFileSystemTypeAsString() {
            return this.fileSystemType;
        }

        @Override
        public final Builder fileSystemType(String fileSystemType) {
            this.fileSystemType = fileSystemType;
            return this;
        }

        @Override
        public final Builder fileSystemType(FileSystemType fileSystemType) {
            this.fileSystemType(fileSystemType == null ? null : fileSystemType.toString());
            return this;
        }

        public final void setFileSystemType(String fileSystemType) {
            this.fileSystemType = fileSystemType;
        }

        public final Integer getStorageCapacity() {
            return this.storageCapacity;
        }

        @Override
        public final Builder storageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
            return this;
        }

        public final void setStorageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
        }

        public final Collection<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final CreateFileSystemWindowsConfiguration.Builder getWindowsConfiguration() {
            return this.windowsConfiguration != null ? this.windowsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder windowsConfiguration(CreateFileSystemWindowsConfiguration windowsConfiguration) {
            this.windowsConfiguration = windowsConfiguration;
            return this;
        }

        public final void setWindowsConfiguration(CreateFileSystemWindowsConfiguration.BuilderImpl windowsConfiguration) {
            this.windowsConfiguration = windowsConfiguration != null ? windowsConfiguration.build() : null;
        }

        public final CreateFileSystemLustreConfiguration.Builder getLustreConfiguration() {
            return this.lustreConfiguration != null ? this.lustreConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder lustreConfiguration(CreateFileSystemLustreConfiguration lustreConfiguration) {
            this.lustreConfiguration = lustreConfiguration;
            return this;
        }

        public final void setLustreConfiguration(CreateFileSystemLustreConfiguration.BuilderImpl lustreConfiguration) {
            this.lustreConfiguration = lustreConfiguration != null ? lustreConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFileSystemRequest build() {
            return new CreateFileSystemRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FSxRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFileSystemRequest> {
        public Builder clientRequestToken(String var1);

        public Builder fileSystemType(String var1);

        public Builder fileSystemType(FileSystemType var1);

        public Builder storageCapacity(Integer var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder kmsKeyId(String var1);

        public Builder windowsConfiguration(CreateFileSystemWindowsConfiguration var1);

        default public Builder windowsConfiguration(Consumer<CreateFileSystemWindowsConfiguration.Builder> windowsConfiguration) {
            return this.windowsConfiguration((CreateFileSystemWindowsConfiguration)((CreateFileSystemWindowsConfiguration.Builder)CreateFileSystemWindowsConfiguration.builder().applyMutation(windowsConfiguration)).build());
        }

        public Builder lustreConfiguration(CreateFileSystemLustreConfiguration var1);

        default public Builder lustreConfiguration(Consumer<CreateFileSystemLustreConfiguration.Builder> lustreConfiguration) {
            return this.lustreConfiguration((CreateFileSystemLustreConfiguration)((CreateFileSystemLustreConfiguration.Builder)CreateFileSystemLustreConfiguration.builder().applyMutation(lustreConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

