/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies updates to an FSx for ONTAP storage virtual machine's (SVM) Microsoft Active Directory (AD) configuration.
 * Note that account credentials are not returned in the response payload.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSvmActiveDirectoryConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateSvmActiveDirectoryConfiguration.Builder, UpdateSvmActiveDirectoryConfiguration> {
    private static final SdkField<SelfManagedActiveDirectoryConfigurationUpdates> SELF_MANAGED_ACTIVE_DIRECTORY_CONFIGURATION_FIELD = SdkField
            .<SelfManagedActiveDirectoryConfigurationUpdates> builder(MarshallingType.SDK_POJO)
            .memberName("SelfManagedActiveDirectoryConfiguration")
            .getter(getter(UpdateSvmActiveDirectoryConfiguration::selfManagedActiveDirectoryConfiguration))
            .setter(setter(Builder::selfManagedActiveDirectoryConfiguration))
            .constructor(SelfManagedActiveDirectoryConfigurationUpdates::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SelfManagedActiveDirectoryConfiguration").build()).build();

    private static final SdkField<String> NET_BIOS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetBiosName").getter(getter(UpdateSvmActiveDirectoryConfiguration::netBiosName))
            .setter(setter(Builder::netBiosName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetBiosName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SELF_MANAGED_ACTIVE_DIRECTORY_CONFIGURATION_FIELD, NET_BIOS_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SelfManagedActiveDirectoryConfigurationUpdates selfManagedActiveDirectoryConfiguration;

    private final String netBiosName;

    private UpdateSvmActiveDirectoryConfiguration(BuilderImpl builder) {
        this.selfManagedActiveDirectoryConfiguration = builder.selfManagedActiveDirectoryConfiguration;
        this.netBiosName = builder.netBiosName;
    }

    /**
     * Returns the value of the SelfManagedActiveDirectoryConfiguration property for this object.
     * 
     * @return The value of the SelfManagedActiveDirectoryConfiguration property for this object.
     */
    public final SelfManagedActiveDirectoryConfigurationUpdates selfManagedActiveDirectoryConfiguration() {
        return selfManagedActiveDirectoryConfiguration;
    }

    /**
     * <p>
     * Specifies an updated NetBIOS name of the AD computer object <code>NetBiosName</code> to which an SVM is joined.
     * </p>
     * 
     * @return Specifies an updated NetBIOS name of the AD computer object <code>NetBiosName</code> to which an SVM is
     *         joined.
     */
    public final String netBiosName() {
        return netBiosName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(selfManagedActiveDirectoryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(netBiosName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSvmActiveDirectoryConfiguration)) {
            return false;
        }
        UpdateSvmActiveDirectoryConfiguration other = (UpdateSvmActiveDirectoryConfiguration) obj;
        return Objects.equals(selfManagedActiveDirectoryConfiguration(), other.selfManagedActiveDirectoryConfiguration())
                && Objects.equals(netBiosName(), other.netBiosName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSvmActiveDirectoryConfiguration")
                .add("SelfManagedActiveDirectoryConfiguration", selfManagedActiveDirectoryConfiguration())
                .add("NetBiosName", netBiosName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SelfManagedActiveDirectoryConfiguration":
            return Optional.ofNullable(clazz.cast(selfManagedActiveDirectoryConfiguration()));
        case "NetBiosName":
            return Optional.ofNullable(clazz.cast(netBiosName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SelfManagedActiveDirectoryConfiguration", SELF_MANAGED_ACTIVE_DIRECTORY_CONFIGURATION_FIELD);
        map.put("NetBiosName", NET_BIOS_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSvmActiveDirectoryConfiguration, T> g) {
        return obj -> g.apply((UpdateSvmActiveDirectoryConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateSvmActiveDirectoryConfiguration> {
        /**
         * Sets the value of the SelfManagedActiveDirectoryConfiguration property for this object.
         *
         * @param selfManagedActiveDirectoryConfiguration
         *        The new value for the SelfManagedActiveDirectoryConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfManagedActiveDirectoryConfiguration(
                SelfManagedActiveDirectoryConfigurationUpdates selfManagedActiveDirectoryConfiguration);

        /**
         * Sets the value of the SelfManagedActiveDirectoryConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link SelfManagedActiveDirectoryConfigurationUpdates.Builder} avoiding the need to create one manually via
         * {@link SelfManagedActiveDirectoryConfigurationUpdates#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SelfManagedActiveDirectoryConfigurationUpdates.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #selfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryConfigurationUpdates)}.
         * 
         * @param selfManagedActiveDirectoryConfiguration
         *        a consumer that will call methods on {@link SelfManagedActiveDirectoryConfigurationUpdates.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryConfigurationUpdates)
         */
        default Builder selfManagedActiveDirectoryConfiguration(
                Consumer<SelfManagedActiveDirectoryConfigurationUpdates.Builder> selfManagedActiveDirectoryConfiguration) {
            return selfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryConfigurationUpdates.builder()
                    .applyMutation(selfManagedActiveDirectoryConfiguration).build());
        }

        /**
         * <p>
         * Specifies an updated NetBIOS name of the AD computer object <code>NetBiosName</code> to which an SVM is
         * joined.
         * </p>
         * 
         * @param netBiosName
         *        Specifies an updated NetBIOS name of the AD computer object <code>NetBiosName</code> to which an SVM
         *        is joined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder netBiosName(String netBiosName);
    }

    static final class BuilderImpl implements Builder {
        private SelfManagedActiveDirectoryConfigurationUpdates selfManagedActiveDirectoryConfiguration;

        private String netBiosName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSvmActiveDirectoryConfiguration model) {
            selfManagedActiveDirectoryConfiguration(model.selfManagedActiveDirectoryConfiguration);
            netBiosName(model.netBiosName);
        }

        public final SelfManagedActiveDirectoryConfigurationUpdates.Builder getSelfManagedActiveDirectoryConfiguration() {
            return selfManagedActiveDirectoryConfiguration != null ? selfManagedActiveDirectoryConfiguration.toBuilder() : null;
        }

        public final void setSelfManagedActiveDirectoryConfiguration(
                SelfManagedActiveDirectoryConfigurationUpdates.BuilderImpl selfManagedActiveDirectoryConfiguration) {
            this.selfManagedActiveDirectoryConfiguration = selfManagedActiveDirectoryConfiguration != null ? selfManagedActiveDirectoryConfiguration
                    .build() : null;
        }

        @Override
        public final Builder selfManagedActiveDirectoryConfiguration(
                SelfManagedActiveDirectoryConfigurationUpdates selfManagedActiveDirectoryConfiguration) {
            this.selfManagedActiveDirectoryConfiguration = selfManagedActiveDirectoryConfiguration;
            return this;
        }

        public final String getNetBiosName() {
            return netBiosName;
        }

        public final void setNetBiosName(String netBiosName) {
            this.netBiosName = netBiosName;
        }

        @Override
        public final Builder netBiosName(String netBiosName) {
            this.netBiosName = netBiosName;
            return this;
        }

        @Override
        public UpdateSvmActiveDirectoryConfiguration build() {
            return new UpdateSvmActiveDirectoryConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
