/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the file system user identity that will be used for authorizing all file access requests that are made
 * using the S3 access point.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpenZFSFileSystemIdentity implements SdkPojo, Serializable,
        ToCopyableBuilder<OpenZFSFileSystemIdentity.Builder, OpenZFSFileSystemIdentity> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(OpenZFSFileSystemIdentity::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<OpenZFSPosixFileSystemUser> POSIX_USER_FIELD = SdkField
            .<OpenZFSPosixFileSystemUser> builder(MarshallingType.SDK_POJO).memberName("PosixUser")
            .getter(getter(OpenZFSFileSystemIdentity::posixUser)).setter(setter(Builder::posixUser))
            .constructor(OpenZFSPosixFileSystemUser::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PosixUser").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, POSIX_USER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final OpenZFSPosixFileSystemUser posixUser;

    private OpenZFSFileSystemIdentity(BuilderImpl builder) {
        this.type = builder.type;
        this.posixUser = builder.posixUser;
    }

    /**
     * <p>
     * Specifies the FSx for OpenZFS user identity type, accepts only <code>POSIX</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OpenZFSFileSystemUserType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies the FSx for OpenZFS user identity type, accepts only <code>POSIX</code>.
     * @see OpenZFSFileSystemUserType
     */
    public final OpenZFSFileSystemUserType type() {
        return OpenZFSFileSystemUserType.fromValue(type);
    }

    /**
     * <p>
     * Specifies the FSx for OpenZFS user identity type, accepts only <code>POSIX</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OpenZFSFileSystemUserType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies the FSx for OpenZFS user identity type, accepts only <code>POSIX</code>.
     * @see OpenZFSFileSystemUserType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Specifies the UID and GIDs of the file system POSIX user.
     * </p>
     * 
     * @return Specifies the UID and GIDs of the file system POSIX user.
     */
    public final OpenZFSPosixFileSystemUser posixUser() {
        return posixUser;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(posixUser());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenZFSFileSystemIdentity)) {
            return false;
        }
        OpenZFSFileSystemIdentity other = (OpenZFSFileSystemIdentity) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(posixUser(), other.posixUser());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpenZFSFileSystemIdentity").add("Type", typeAsString()).add("PosixUser", posixUser()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "PosixUser":
            return Optional.ofNullable(clazz.cast(posixUser()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("PosixUser", POSIX_USER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpenZFSFileSystemIdentity, T> g) {
        return obj -> g.apply((OpenZFSFileSystemIdentity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpenZFSFileSystemIdentity> {
        /**
         * <p>
         * Specifies the FSx for OpenZFS user identity type, accepts only <code>POSIX</code>.
         * </p>
         * 
         * @param type
         *        Specifies the FSx for OpenZFS user identity type, accepts only <code>POSIX</code>.
         * @see OpenZFSFileSystemUserType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpenZFSFileSystemUserType
         */
        Builder type(String type);

        /**
         * <p>
         * Specifies the FSx for OpenZFS user identity type, accepts only <code>POSIX</code>.
         * </p>
         * 
         * @param type
         *        Specifies the FSx for OpenZFS user identity type, accepts only <code>POSIX</code>.
         * @see OpenZFSFileSystemUserType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpenZFSFileSystemUserType
         */
        Builder type(OpenZFSFileSystemUserType type);

        /**
         * <p>
         * Specifies the UID and GIDs of the file system POSIX user.
         * </p>
         * 
         * @param posixUser
         *        Specifies the UID and GIDs of the file system POSIX user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder posixUser(OpenZFSPosixFileSystemUser posixUser);

        /**
         * <p>
         * Specifies the UID and GIDs of the file system POSIX user.
         * </p>
         * This is a convenience method that creates an instance of the {@link OpenZFSPosixFileSystemUser.Builder}
         * avoiding the need to create one manually via {@link OpenZFSPosixFileSystemUser#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenZFSPosixFileSystemUser.Builder#build()} is called immediately
         * and its result is passed to {@link #posixUser(OpenZFSPosixFileSystemUser)}.
         * 
         * @param posixUser
         *        a consumer that will call methods on {@link OpenZFSPosixFileSystemUser.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #posixUser(OpenZFSPosixFileSystemUser)
         */
        default Builder posixUser(Consumer<OpenZFSPosixFileSystemUser.Builder> posixUser) {
            return posixUser(OpenZFSPosixFileSystemUser.builder().applyMutation(posixUser).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private OpenZFSPosixFileSystemUser posixUser;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenZFSFileSystemIdentity model) {
            type(model.type);
            posixUser(model.posixUser);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OpenZFSFileSystemUserType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final OpenZFSPosixFileSystemUser.Builder getPosixUser() {
            return posixUser != null ? posixUser.toBuilder() : null;
        }

        public final void setPosixUser(OpenZFSPosixFileSystemUser.BuilderImpl posixUser) {
            this.posixUser = posixUser != null ? posixUser.build() : null;
        }

        @Override
        public final Builder posixUser(OpenZFSPosixFileSystemUser posixUser) {
            this.posixUser = posixUser;
            return this;
        }

        @Override
        public OpenZFSFileSystemIdentity build() {
            return new OpenZFSFileSystemIdentity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
