/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of an Amazon FSx for NetApp ONTAP volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OntapVolumeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<OntapVolumeConfiguration.Builder, OntapVolumeConfiguration> {
    private static final SdkField<String> FLEX_CACHE_ENDPOINT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlexCacheEndpointType").getter(getter(OntapVolumeConfiguration::flexCacheEndpointTypeAsString))
            .setter(setter(Builder::flexCacheEndpointType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlexCacheEndpointType").build())
            .build();

    private static final SdkField<String> JUNCTION_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JunctionPath").getter(getter(OntapVolumeConfiguration::junctionPath))
            .setter(setter(Builder::junctionPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JunctionPath").build()).build();

    private static final SdkField<String> SECURITY_STYLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityStyle").getter(getter(OntapVolumeConfiguration::securityStyleAsString))
            .setter(setter(Builder::securityStyle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityStyle").build()).build();

    private static final SdkField<Integer> SIZE_IN_MEGABYTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SizeInMegabytes").getter(getter(OntapVolumeConfiguration::sizeInMegabytes))
            .setter(setter(Builder::sizeInMegabytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeInMegabytes").build()).build();

    private static final SdkField<Boolean> STORAGE_EFFICIENCY_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StorageEfficiencyEnabled").getter(getter(OntapVolumeConfiguration::storageEfficiencyEnabled))
            .setter(setter(Builder::storageEfficiencyEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEfficiencyEnabled").build())
            .build();

    private static final SdkField<String> STORAGE_VIRTUAL_MACHINE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageVirtualMachineId").getter(getter(OntapVolumeConfiguration::storageVirtualMachineId))
            .setter(setter(Builder::storageVirtualMachineId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageVirtualMachineId").build())
            .build();

    private static final SdkField<Boolean> STORAGE_VIRTUAL_MACHINE_ROOT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("StorageVirtualMachineRoot")
            .getter(getter(OntapVolumeConfiguration::storageVirtualMachineRoot))
            .setter(setter(Builder::storageVirtualMachineRoot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageVirtualMachineRoot").build())
            .build();

    private static final SdkField<TieringPolicy> TIERING_POLICY_FIELD = SdkField
            .<TieringPolicy> builder(MarshallingType.SDK_POJO).memberName("TieringPolicy")
            .getter(getter(OntapVolumeConfiguration::tieringPolicy)).setter(setter(Builder::tieringPolicy))
            .constructor(TieringPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TieringPolicy").build()).build();

    private static final SdkField<String> UUID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UUID")
            .getter(getter(OntapVolumeConfiguration::uuid)).setter(setter(Builder::uuid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UUID").build()).build();

    private static final SdkField<String> ONTAP_VOLUME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OntapVolumeType").getter(getter(OntapVolumeConfiguration::ontapVolumeTypeAsString))
            .setter(setter(Builder::ontapVolumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OntapVolumeType").build()).build();

    private static final SdkField<String> SNAPSHOT_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotPolicy").getter(getter(OntapVolumeConfiguration::snapshotPolicy))
            .setter(setter(Builder::snapshotPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotPolicy").build()).build();

    private static final SdkField<Boolean> COPY_TAGS_TO_BACKUPS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyTagsToBackups").getter(getter(OntapVolumeConfiguration::copyTagsToBackups))
            .setter(setter(Builder::copyTagsToBackups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToBackups").build()).build();

    private static final SdkField<SnaplockConfiguration> SNAPLOCK_CONFIGURATION_FIELD = SdkField
            .<SnaplockConfiguration> builder(MarshallingType.SDK_POJO).memberName("SnaplockConfiguration")
            .getter(getter(OntapVolumeConfiguration::snaplockConfiguration)).setter(setter(Builder::snaplockConfiguration))
            .constructor(SnaplockConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnaplockConfiguration").build())
            .build();

    private static final SdkField<String> VOLUME_STYLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeStyle").getter(getter(OntapVolumeConfiguration::volumeStyleAsString))
            .setter(setter(Builder::volumeStyle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeStyle").build()).build();

    private static final SdkField<AggregateConfiguration> AGGREGATE_CONFIGURATION_FIELD = SdkField
            .<AggregateConfiguration> builder(MarshallingType.SDK_POJO).memberName("AggregateConfiguration")
            .getter(getter(OntapVolumeConfiguration::aggregateConfiguration)).setter(setter(Builder::aggregateConfiguration))
            .constructor(AggregateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregateConfiguration").build())
            .build();

    private static final SdkField<Long> SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("SizeInBytes").getter(getter(OntapVolumeConfiguration::sizeInBytes)).setter(setter(Builder::sizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeInBytes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FLEX_CACHE_ENDPOINT_TYPE_FIELD, JUNCTION_PATH_FIELD, SECURITY_STYLE_FIELD, SIZE_IN_MEGABYTES_FIELD,
            STORAGE_EFFICIENCY_ENABLED_FIELD, STORAGE_VIRTUAL_MACHINE_ID_FIELD, STORAGE_VIRTUAL_MACHINE_ROOT_FIELD,
            TIERING_POLICY_FIELD, UUID_FIELD, ONTAP_VOLUME_TYPE_FIELD, SNAPSHOT_POLICY_FIELD, COPY_TAGS_TO_BACKUPS_FIELD,
            SNAPLOCK_CONFIGURATION_FIELD, VOLUME_STYLE_FIELD, AGGREGATE_CONFIGURATION_FIELD, SIZE_IN_BYTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String flexCacheEndpointType;

    private final String junctionPath;

    private final String securityStyle;

    private final Integer sizeInMegabytes;

    private final Boolean storageEfficiencyEnabled;

    private final String storageVirtualMachineId;

    private final Boolean storageVirtualMachineRoot;

    private final TieringPolicy tieringPolicy;

    private final String uuid;

    private final String ontapVolumeType;

    private final String snapshotPolicy;

    private final Boolean copyTagsToBackups;

    private final SnaplockConfiguration snaplockConfiguration;

    private final String volumeStyle;

    private final AggregateConfiguration aggregateConfiguration;

    private final Long sizeInBytes;

    private OntapVolumeConfiguration(BuilderImpl builder) {
        this.flexCacheEndpointType = builder.flexCacheEndpointType;
        this.junctionPath = builder.junctionPath;
        this.securityStyle = builder.securityStyle;
        this.sizeInMegabytes = builder.sizeInMegabytes;
        this.storageEfficiencyEnabled = builder.storageEfficiencyEnabled;
        this.storageVirtualMachineId = builder.storageVirtualMachineId;
        this.storageVirtualMachineRoot = builder.storageVirtualMachineRoot;
        this.tieringPolicy = builder.tieringPolicy;
        this.uuid = builder.uuid;
        this.ontapVolumeType = builder.ontapVolumeType;
        this.snapshotPolicy = builder.snapshotPolicy;
        this.copyTagsToBackups = builder.copyTagsToBackups;
        this.snaplockConfiguration = builder.snaplockConfiguration;
        this.volumeStyle = builder.volumeStyle;
        this.aggregateConfiguration = builder.aggregateConfiguration;
        this.sizeInBytes = builder.sizeInBytes;
    }

    /**
     * <p>
     * Specifies the FlexCache endpoint type of the volume. Valid values are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code> specifies that the volume doesn't have a FlexCache configuration. <code>NONE</code> is the
     * default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ORIGIN</code> specifies that the volume is the origin volume for a FlexCache volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CACHE</code> specifies that the volume is a FlexCache volume.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #flexCacheEndpointType} will return {@link FlexCacheEndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #flexCacheEndpointTypeAsString}.
     * </p>
     * 
     * @return Specifies the FlexCache endpoint type of the volume. Valid values are the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code> specifies that the volume doesn't have a FlexCache configuration. <code>NONE</code> is
     *         the default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ORIGIN</code> specifies that the volume is the origin volume for a FlexCache volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CACHE</code> specifies that the volume is a FlexCache volume.
     *         </p>
     *         </li>
     * @see FlexCacheEndpointType
     */
    public final FlexCacheEndpointType flexCacheEndpointType() {
        return FlexCacheEndpointType.fromValue(flexCacheEndpointType);
    }

    /**
     * <p>
     * Specifies the FlexCache endpoint type of the volume. Valid values are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code> specifies that the volume doesn't have a FlexCache configuration. <code>NONE</code> is the
     * default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ORIGIN</code> specifies that the volume is the origin volume for a FlexCache volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CACHE</code> specifies that the volume is a FlexCache volume.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #flexCacheEndpointType} will return {@link FlexCacheEndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #flexCacheEndpointTypeAsString}.
     * </p>
     * 
     * @return Specifies the FlexCache endpoint type of the volume. Valid values are the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code> specifies that the volume doesn't have a FlexCache configuration. <code>NONE</code> is
     *         the default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ORIGIN</code> specifies that the volume is the origin volume for a FlexCache volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CACHE</code> specifies that the volume is a FlexCache volume.
     *         </p>
     *         </li>
     * @see FlexCacheEndpointType
     */
    public final String flexCacheEndpointTypeAsString() {
        return flexCacheEndpointType;
    }

    /**
     * <p>
     * Specifies the directory that network-attached storage (NAS) clients use to mount the volume, along with the
     * storage virtual machine (SVM) Domain Name System (DNS) name or IP address. You can create a
     * <code>JunctionPath</code> directly below a parent volume junction or on a directory within a volume. A
     * <code>JunctionPath</code> for a volume named <code>vol3</code> might be <code>/vol1/vol2/vol3</code>, or
     * <code>/vol1/dir2/vol3</code>, or even <code>/dir1/dir2/vol3</code>.
     * </p>
     * 
     * @return Specifies the directory that network-attached storage (NAS) clients use to mount the volume, along with
     *         the storage virtual machine (SVM) Domain Name System (DNS) name or IP address. You can create a
     *         <code>JunctionPath</code> directly below a parent volume junction or on a directory within a volume. A
     *         <code>JunctionPath</code> for a volume named <code>vol3</code> might be <code>/vol1/vol2/vol3</code>, or
     *         <code>/vol1/dir2/vol3</code>, or even <code>/dir1/dir2/vol3</code>.
     */
    public final String junctionPath() {
        return junctionPath;
    }

    /**
     * <p>
     * The security style for the volume, which can be <code>UNIX</code>, <code>NTFS</code>, or <code>MIXED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #securityStyle}
     * will return {@link SecurityStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #securityStyleAsString}.
     * </p>
     * 
     * @return The security style for the volume, which can be <code>UNIX</code>, <code>NTFS</code>, or
     *         <code>MIXED</code>.
     * @see SecurityStyle
     */
    public final SecurityStyle securityStyle() {
        return SecurityStyle.fromValue(securityStyle);
    }

    /**
     * <p>
     * The security style for the volume, which can be <code>UNIX</code>, <code>NTFS</code>, or <code>MIXED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #securityStyle}
     * will return {@link SecurityStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #securityStyleAsString}.
     * </p>
     * 
     * @return The security style for the volume, which can be <code>UNIX</code>, <code>NTFS</code>, or
     *         <code>MIXED</code>.
     * @see SecurityStyle
     */
    public final String securityStyleAsString() {
        return securityStyle;
    }

    /**
     * <p>
     * The configured size of the volume, in megabytes (MBs).
     * </p>
     * 
     * @return The configured size of the volume, in megabytes (MBs).
     */
    public final Integer sizeInMegabytes() {
        return sizeInMegabytes;
    }

    /**
     * <p>
     * The volume's storage efficiency setting.
     * </p>
     * 
     * @return The volume's storage efficiency setting.
     */
    public final Boolean storageEfficiencyEnabled() {
        return storageEfficiencyEnabled;
    }

    /**
     * <p>
     * The ID of the volume's storage virtual machine.
     * </p>
     * 
     * @return The ID of the volume's storage virtual machine.
     */
    public final String storageVirtualMachineId() {
        return storageVirtualMachineId;
    }

    /**
     * <p>
     * A Boolean flag indicating whether this volume is the root volume for its storage virtual machine (SVM). Only one
     * volume on an SVM can be the root volume. This value defaults to <code>false</code>. If this value is
     * <code>true</code>, then this is the SVM root volume.
     * </p>
     * <p>
     * This flag is useful when you're deleting an SVM, because you must first delete all non-root volumes. This flag,
     * when set to <code>false</code>, helps you identify which volumes to delete before you can delete the SVM.
     * </p>
     * 
     * @return A Boolean flag indicating whether this volume is the root volume for its storage virtual machine (SVM).
     *         Only one volume on an SVM can be the root volume. This value defaults to <code>false</code>. If this
     *         value is <code>true</code>, then this is the SVM root volume.</p>
     *         <p>
     *         This flag is useful when you're deleting an SVM, because you must first delete all non-root volumes. This
     *         flag, when set to <code>false</code>, helps you identify which volumes to delete before you can delete
     *         the SVM.
     */
    public final Boolean storageVirtualMachineRoot() {
        return storageVirtualMachineRoot;
    }

    /**
     * <p>
     * The volume's <code>TieringPolicy</code> setting.
     * </p>
     * 
     * @return The volume's <code>TieringPolicy</code> setting.
     */
    public final TieringPolicy tieringPolicy() {
        return tieringPolicy;
    }

    /**
     * <p>
     * The volume's universally unique identifier (UUID).
     * </p>
     * 
     * @return The volume's universally unique identifier (UUID).
     */
    public final String uuid() {
        return uuid;
    }

    /**
     * <p>
     * Specifies the type of volume. Valid values are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RW</code> specifies a read/write volume. <code>RW</code> is the default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DP</code> specifies a data-protection volume. You can protect data by replicating it to data-protection
     * mirror copies. If a disaster occurs, you can use these data-protection mirror copies to recover data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LS</code> specifies a load-sharing mirror volume. A load-sharing mirror reduces the network traffic to a
     * FlexVol volume by providing additional read-only access to clients.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ontapVolumeType}
     * will return {@link OntapVolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ontapVolumeTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of volume. Valid values are the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RW</code> specifies a read/write volume. <code>RW</code> is the default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DP</code> specifies a data-protection volume. You can protect data by replicating it to
     *         data-protection mirror copies. If a disaster occurs, you can use these data-protection mirror copies to
     *         recover data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LS</code> specifies a load-sharing mirror volume. A load-sharing mirror reduces the network traffic
     *         to a FlexVol volume by providing additional read-only access to clients.
     *         </p>
     *         </li>
     * @see OntapVolumeType
     */
    public final OntapVolumeType ontapVolumeType() {
        return OntapVolumeType.fromValue(ontapVolumeType);
    }

    /**
     * <p>
     * Specifies the type of volume. Valid values are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RW</code> specifies a read/write volume. <code>RW</code> is the default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DP</code> specifies a data-protection volume. You can protect data by replicating it to data-protection
     * mirror copies. If a disaster occurs, you can use these data-protection mirror copies to recover data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LS</code> specifies a load-sharing mirror volume. A load-sharing mirror reduces the network traffic to a
     * FlexVol volume by providing additional read-only access to clients.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ontapVolumeType}
     * will return {@link OntapVolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ontapVolumeTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of volume. Valid values are the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RW</code> specifies a read/write volume. <code>RW</code> is the default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DP</code> specifies a data-protection volume. You can protect data by replicating it to
     *         data-protection mirror copies. If a disaster occurs, you can use these data-protection mirror copies to
     *         recover data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LS</code> specifies a load-sharing mirror volume. A load-sharing mirror reduces the network traffic
     *         to a FlexVol volume by providing additional read-only access to clients.
     *         </p>
     *         </li>
     * @see OntapVolumeType
     */
    public final String ontapVolumeTypeAsString() {
        return ontapVolumeType;
    }

    /**
     * <p>
     * Specifies the snapshot policy for the volume. There are three built-in snapshot policies:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>default</code>: This is the default policy. A maximum of six hourly snapshots taken five minutes past the
     * hour. A maximum of two daily snapshots taken Monday through Saturday at 10 minutes after midnight. A maximum of
     * two weekly snapshots taken every Sunday at 15 minutes after midnight.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>default-1weekly</code>: This policy is the same as the <code>default</code> policy except that it only
     * retains one snapshot from the weekly schedule.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>none</code>: This policy does not take any snapshots. This policy can be assigned to volumes to prevent
     * automatic snapshots from being taken.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can also provide the name of a custom policy that you created with the ONTAP CLI or REST API.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies">Snapshot
     * policies</a> in the Amazon FSx for NetApp ONTAP User Guide.
     * </p>
     * 
     * @return Specifies the snapshot policy for the volume. There are three built-in snapshot policies:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>default</code>: This is the default policy. A maximum of six hourly snapshots taken five minutes
     *         past the hour. A maximum of two daily snapshots taken Monday through Saturday at 10 minutes after
     *         midnight. A maximum of two weekly snapshots taken every Sunday at 15 minutes after midnight.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>default-1weekly</code>: This policy is the same as the <code>default</code> policy except that it
     *         only retains one snapshot from the weekly schedule.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>none</code>: This policy does not take any snapshots. This policy can be assigned to volumes to
     *         prevent automatic snapshots from being taken.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can also provide the name of a custom policy that you created with the ONTAP CLI or REST API.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies">Snapshot
     *         policies</a> in the Amazon FSx for NetApp ONTAP User Guide.
     */
    public final String snapshotPolicy() {
        return snapshotPolicy;
    }

    /**
     * <p>
     * A boolean flag indicating whether tags for the volume should be copied to backups. This value defaults to false.
     * If it's set to true, all tags for the volume are copied to all automatic and user-initiated backups where the
     * user doesn't specify tags. If this value is true, and you specify one or more tags, only the specified tags are
     * copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from
     * the volume, regardless of this value.
     * </p>
     * 
     * @return A boolean flag indicating whether tags for the volume should be copied to backups. This value defaults to
     *         false. If it's set to true, all tags for the volume are copied to all automatic and user-initiated
     *         backups where the user doesn't specify tags. If this value is true, and you specify one or more tags,
     *         only the specified tags are copied to backups. If you specify one or more tags when creating a
     *         user-initiated backup, no tags are copied from the volume, regardless of this value.
     */
    public final Boolean copyTagsToBackups() {
        return copyTagsToBackups;
    }

    /**
     * <p>
     * The SnapLock configuration object for an FSx for ONTAP SnapLock volume.
     * </p>
     * 
     * @return The SnapLock configuration object for an FSx for ONTAP SnapLock volume.
     */
    public final SnaplockConfiguration snaplockConfiguration() {
        return snaplockConfiguration;
    }

    /**
     * <p>
     * Use to specify the style of an ONTAP volume. For more information about FlexVols and FlexGroups, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-types.html">Volume types</a> in Amazon FSx for
     * NetApp ONTAP User Guide.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeStyle} will
     * return {@link VolumeStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeStyleAsString}.
     * </p>
     * 
     * @return Use to specify the style of an ONTAP volume. For more information about FlexVols and FlexGroups, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-types.html">Volume types</a> in Amazon FSx
     *         for NetApp ONTAP User Guide.
     * @see VolumeStyle
     */
    public final VolumeStyle volumeStyle() {
        return VolumeStyle.fromValue(volumeStyle);
    }

    /**
     * <p>
     * Use to specify the style of an ONTAP volume. For more information about FlexVols and FlexGroups, see <a
     * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-types.html">Volume types</a> in Amazon FSx for
     * NetApp ONTAP User Guide.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeStyle} will
     * return {@link VolumeStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeStyleAsString}.
     * </p>
     * 
     * @return Use to specify the style of an ONTAP volume. For more information about FlexVols and FlexGroups, see <a
     *         href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-types.html">Volume types</a> in Amazon FSx
     *         for NetApp ONTAP User Guide.
     * @see VolumeStyle
     */
    public final String volumeStyleAsString() {
        return volumeStyle;
    }

    /**
     * <p>
     * This structure specifies configuration options for a volume’s storage aggregate or aggregates.
     * </p>
     * 
     * @return This structure specifies configuration options for a volume’s storage aggregate or aggregates.
     */
    public final AggregateConfiguration aggregateConfiguration() {
        return aggregateConfiguration;
    }

    /**
     * <p>
     * The configured size of the volume, in bytes.
     * </p>
     * 
     * @return The configured size of the volume, in bytes.
     */
    public final Long sizeInBytes() {
        return sizeInBytes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flexCacheEndpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(junctionPath());
        hashCode = 31 * hashCode + Objects.hashCode(securityStyleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sizeInMegabytes());
        hashCode = 31 * hashCode + Objects.hashCode(storageEfficiencyEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(storageVirtualMachineId());
        hashCode = 31 * hashCode + Objects.hashCode(storageVirtualMachineRoot());
        hashCode = 31 * hashCode + Objects.hashCode(tieringPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(uuid());
        hashCode = 31 * hashCode + Objects.hashCode(ontapVolumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(copyTagsToBackups());
        hashCode = 31 * hashCode + Objects.hashCode(snaplockConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(volumeStyleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(aggregateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(sizeInBytes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OntapVolumeConfiguration)) {
            return false;
        }
        OntapVolumeConfiguration other = (OntapVolumeConfiguration) obj;
        return Objects.equals(flexCacheEndpointTypeAsString(), other.flexCacheEndpointTypeAsString())
                && Objects.equals(junctionPath(), other.junctionPath())
                && Objects.equals(securityStyleAsString(), other.securityStyleAsString())
                && Objects.equals(sizeInMegabytes(), other.sizeInMegabytes())
                && Objects.equals(storageEfficiencyEnabled(), other.storageEfficiencyEnabled())
                && Objects.equals(storageVirtualMachineId(), other.storageVirtualMachineId())
                && Objects.equals(storageVirtualMachineRoot(), other.storageVirtualMachineRoot())
                && Objects.equals(tieringPolicy(), other.tieringPolicy()) && Objects.equals(uuid(), other.uuid())
                && Objects.equals(ontapVolumeTypeAsString(), other.ontapVolumeTypeAsString())
                && Objects.equals(snapshotPolicy(), other.snapshotPolicy())
                && Objects.equals(copyTagsToBackups(), other.copyTagsToBackups())
                && Objects.equals(snaplockConfiguration(), other.snaplockConfiguration())
                && Objects.equals(volumeStyleAsString(), other.volumeStyleAsString())
                && Objects.equals(aggregateConfiguration(), other.aggregateConfiguration())
                && Objects.equals(sizeInBytes(), other.sizeInBytes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OntapVolumeConfiguration").add("FlexCacheEndpointType", flexCacheEndpointTypeAsString())
                .add("JunctionPath", junctionPath()).add("SecurityStyle", securityStyleAsString())
                .add("SizeInMegabytes", sizeInMegabytes()).add("StorageEfficiencyEnabled", storageEfficiencyEnabled())
                .add("StorageVirtualMachineId", storageVirtualMachineId())
                .add("StorageVirtualMachineRoot", storageVirtualMachineRoot()).add("TieringPolicy", tieringPolicy())
                .add("UUID", uuid()).add("OntapVolumeType", ontapVolumeTypeAsString()).add("SnapshotPolicy", snapshotPolicy())
                .add("CopyTagsToBackups", copyTagsToBackups()).add("SnaplockConfiguration", snaplockConfiguration())
                .add("VolumeStyle", volumeStyleAsString()).add("AggregateConfiguration", aggregateConfiguration())
                .add("SizeInBytes", sizeInBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlexCacheEndpointType":
            return Optional.ofNullable(clazz.cast(flexCacheEndpointTypeAsString()));
        case "JunctionPath":
            return Optional.ofNullable(clazz.cast(junctionPath()));
        case "SecurityStyle":
            return Optional.ofNullable(clazz.cast(securityStyleAsString()));
        case "SizeInMegabytes":
            return Optional.ofNullable(clazz.cast(sizeInMegabytes()));
        case "StorageEfficiencyEnabled":
            return Optional.ofNullable(clazz.cast(storageEfficiencyEnabled()));
        case "StorageVirtualMachineId":
            return Optional.ofNullable(clazz.cast(storageVirtualMachineId()));
        case "StorageVirtualMachineRoot":
            return Optional.ofNullable(clazz.cast(storageVirtualMachineRoot()));
        case "TieringPolicy":
            return Optional.ofNullable(clazz.cast(tieringPolicy()));
        case "UUID":
            return Optional.ofNullable(clazz.cast(uuid()));
        case "OntapVolumeType":
            return Optional.ofNullable(clazz.cast(ontapVolumeTypeAsString()));
        case "SnapshotPolicy":
            return Optional.ofNullable(clazz.cast(snapshotPolicy()));
        case "CopyTagsToBackups":
            return Optional.ofNullable(clazz.cast(copyTagsToBackups()));
        case "SnaplockConfiguration":
            return Optional.ofNullable(clazz.cast(snaplockConfiguration()));
        case "VolumeStyle":
            return Optional.ofNullable(clazz.cast(volumeStyleAsString()));
        case "AggregateConfiguration":
            return Optional.ofNullable(clazz.cast(aggregateConfiguration()));
        case "SizeInBytes":
            return Optional.ofNullable(clazz.cast(sizeInBytes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FlexCacheEndpointType", FLEX_CACHE_ENDPOINT_TYPE_FIELD);
        map.put("JunctionPath", JUNCTION_PATH_FIELD);
        map.put("SecurityStyle", SECURITY_STYLE_FIELD);
        map.put("SizeInMegabytes", SIZE_IN_MEGABYTES_FIELD);
        map.put("StorageEfficiencyEnabled", STORAGE_EFFICIENCY_ENABLED_FIELD);
        map.put("StorageVirtualMachineId", STORAGE_VIRTUAL_MACHINE_ID_FIELD);
        map.put("StorageVirtualMachineRoot", STORAGE_VIRTUAL_MACHINE_ROOT_FIELD);
        map.put("TieringPolicy", TIERING_POLICY_FIELD);
        map.put("UUID", UUID_FIELD);
        map.put("OntapVolumeType", ONTAP_VOLUME_TYPE_FIELD);
        map.put("SnapshotPolicy", SNAPSHOT_POLICY_FIELD);
        map.put("CopyTagsToBackups", COPY_TAGS_TO_BACKUPS_FIELD);
        map.put("SnaplockConfiguration", SNAPLOCK_CONFIGURATION_FIELD);
        map.put("VolumeStyle", VOLUME_STYLE_FIELD);
        map.put("AggregateConfiguration", AGGREGATE_CONFIGURATION_FIELD);
        map.put("SizeInBytes", SIZE_IN_BYTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OntapVolumeConfiguration, T> g) {
        return obj -> g.apply((OntapVolumeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OntapVolumeConfiguration> {
        /**
         * <p>
         * Specifies the FlexCache endpoint type of the volume. Valid values are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code> specifies that the volume doesn't have a FlexCache configuration. <code>NONE</code> is the
         * default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ORIGIN</code> specifies that the volume is the origin volume for a FlexCache volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CACHE</code> specifies that the volume is a FlexCache volume.
         * </p>
         * </li>
         * </ul>
         * 
         * @param flexCacheEndpointType
         *        Specifies the FlexCache endpoint type of the volume. Valid values are the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code> specifies that the volume doesn't have a FlexCache configuration. <code>NONE</code>
         *        is the default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ORIGIN</code> specifies that the volume is the origin volume for a FlexCache volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CACHE</code> specifies that the volume is a FlexCache volume.
         *        </p>
         *        </li>
         * @see FlexCacheEndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlexCacheEndpointType
         */
        Builder flexCacheEndpointType(String flexCacheEndpointType);

        /**
         * <p>
         * Specifies the FlexCache endpoint type of the volume. Valid values are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code> specifies that the volume doesn't have a FlexCache configuration. <code>NONE</code> is the
         * default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ORIGIN</code> specifies that the volume is the origin volume for a FlexCache volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CACHE</code> specifies that the volume is a FlexCache volume.
         * </p>
         * </li>
         * </ul>
         * 
         * @param flexCacheEndpointType
         *        Specifies the FlexCache endpoint type of the volume. Valid values are the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code> specifies that the volume doesn't have a FlexCache configuration. <code>NONE</code>
         *        is the default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ORIGIN</code> specifies that the volume is the origin volume for a FlexCache volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CACHE</code> specifies that the volume is a FlexCache volume.
         *        </p>
         *        </li>
         * @see FlexCacheEndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlexCacheEndpointType
         */
        Builder flexCacheEndpointType(FlexCacheEndpointType flexCacheEndpointType);

        /**
         * <p>
         * Specifies the directory that network-attached storage (NAS) clients use to mount the volume, along with the
         * storage virtual machine (SVM) Domain Name System (DNS) name or IP address. You can create a
         * <code>JunctionPath</code> directly below a parent volume junction or on a directory within a volume. A
         * <code>JunctionPath</code> for a volume named <code>vol3</code> might be <code>/vol1/vol2/vol3</code>, or
         * <code>/vol1/dir2/vol3</code>, or even <code>/dir1/dir2/vol3</code>.
         * </p>
         * 
         * @param junctionPath
         *        Specifies the directory that network-attached storage (NAS) clients use to mount the volume, along
         *        with the storage virtual machine (SVM) Domain Name System (DNS) name or IP address. You can create a
         *        <code>JunctionPath</code> directly below a parent volume junction or on a directory within a volume. A
         *        <code>JunctionPath</code> for a volume named <code>vol3</code> might be <code>/vol1/vol2/vol3</code>,
         *        or <code>/vol1/dir2/vol3</code>, or even <code>/dir1/dir2/vol3</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder junctionPath(String junctionPath);

        /**
         * <p>
         * The security style for the volume, which can be <code>UNIX</code>, <code>NTFS</code>, or <code>MIXED</code>.
         * </p>
         * 
         * @param securityStyle
         *        The security style for the volume, which can be <code>UNIX</code>, <code>NTFS</code>, or
         *        <code>MIXED</code>.
         * @see SecurityStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecurityStyle
         */
        Builder securityStyle(String securityStyle);

        /**
         * <p>
         * The security style for the volume, which can be <code>UNIX</code>, <code>NTFS</code>, or <code>MIXED</code>.
         * </p>
         * 
         * @param securityStyle
         *        The security style for the volume, which can be <code>UNIX</code>, <code>NTFS</code>, or
         *        <code>MIXED</code>.
         * @see SecurityStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecurityStyle
         */
        Builder securityStyle(SecurityStyle securityStyle);

        /**
         * <p>
         * The configured size of the volume, in megabytes (MBs).
         * </p>
         * 
         * @param sizeInMegabytes
         *        The configured size of the volume, in megabytes (MBs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInMegabytes(Integer sizeInMegabytes);

        /**
         * <p>
         * The volume's storage efficiency setting.
         * </p>
         * 
         * @param storageEfficiencyEnabled
         *        The volume's storage efficiency setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageEfficiencyEnabled(Boolean storageEfficiencyEnabled);

        /**
         * <p>
         * The ID of the volume's storage virtual machine.
         * </p>
         * 
         * @param storageVirtualMachineId
         *        The ID of the volume's storage virtual machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageVirtualMachineId(String storageVirtualMachineId);

        /**
         * <p>
         * A Boolean flag indicating whether this volume is the root volume for its storage virtual machine (SVM). Only
         * one volume on an SVM can be the root volume. This value defaults to <code>false</code>. If this value is
         * <code>true</code>, then this is the SVM root volume.
         * </p>
         * <p>
         * This flag is useful when you're deleting an SVM, because you must first delete all non-root volumes. This
         * flag, when set to <code>false</code>, helps you identify which volumes to delete before you can delete the
         * SVM.
         * </p>
         * 
         * @param storageVirtualMachineRoot
         *        A Boolean flag indicating whether this volume is the root volume for its storage virtual machine
         *        (SVM). Only one volume on an SVM can be the root volume. This value defaults to <code>false</code>. If
         *        this value is <code>true</code>, then this is the SVM root volume.</p>
         *        <p>
         *        This flag is useful when you're deleting an SVM, because you must first delete all non-root volumes.
         *        This flag, when set to <code>false</code>, helps you identify which volumes to delete before you can
         *        delete the SVM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageVirtualMachineRoot(Boolean storageVirtualMachineRoot);

        /**
         * <p>
         * The volume's <code>TieringPolicy</code> setting.
         * </p>
         * 
         * @param tieringPolicy
         *        The volume's <code>TieringPolicy</code> setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tieringPolicy(TieringPolicy tieringPolicy);

        /**
         * <p>
         * The volume's <code>TieringPolicy</code> setting.
         * </p>
         * This is a convenience method that creates an instance of the {@link TieringPolicy.Builder} avoiding the need
         * to create one manually via {@link TieringPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TieringPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #tieringPolicy(TieringPolicy)}.
         * 
         * @param tieringPolicy
         *        a consumer that will call methods on {@link TieringPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tieringPolicy(TieringPolicy)
         */
        default Builder tieringPolicy(Consumer<TieringPolicy.Builder> tieringPolicy) {
            return tieringPolicy(TieringPolicy.builder().applyMutation(tieringPolicy).build());
        }

        /**
         * <p>
         * The volume's universally unique identifier (UUID).
         * </p>
         * 
         * @param uuid
         *        The volume's universally unique identifier (UUID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uuid(String uuid);

        /**
         * <p>
         * Specifies the type of volume. Valid values are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RW</code> specifies a read/write volume. <code>RW</code> is the default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DP</code> specifies a data-protection volume. You can protect data by replicating it to data-protection
         * mirror copies. If a disaster occurs, you can use these data-protection mirror copies to recover data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LS</code> specifies a load-sharing mirror volume. A load-sharing mirror reduces the network traffic to
         * a FlexVol volume by providing additional read-only access to clients.
         * </p>
         * </li>
         * </ul>
         * 
         * @param ontapVolumeType
         *        Specifies the type of volume. Valid values are the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RW</code> specifies a read/write volume. <code>RW</code> is the default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DP</code> specifies a data-protection volume. You can protect data by replicating it to
         *        data-protection mirror copies. If a disaster occurs, you can use these data-protection mirror copies
         *        to recover data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LS</code> specifies a load-sharing mirror volume. A load-sharing mirror reduces the network
         *        traffic to a FlexVol volume by providing additional read-only access to clients.
         *        </p>
         *        </li>
         * @see OntapVolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OntapVolumeType
         */
        Builder ontapVolumeType(String ontapVolumeType);

        /**
         * <p>
         * Specifies the type of volume. Valid values are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RW</code> specifies a read/write volume. <code>RW</code> is the default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DP</code> specifies a data-protection volume. You can protect data by replicating it to data-protection
         * mirror copies. If a disaster occurs, you can use these data-protection mirror copies to recover data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LS</code> specifies a load-sharing mirror volume. A load-sharing mirror reduces the network traffic to
         * a FlexVol volume by providing additional read-only access to clients.
         * </p>
         * </li>
         * </ul>
         * 
         * @param ontapVolumeType
         *        Specifies the type of volume. Valid values are the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RW</code> specifies a read/write volume. <code>RW</code> is the default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DP</code> specifies a data-protection volume. You can protect data by replicating it to
         *        data-protection mirror copies. If a disaster occurs, you can use these data-protection mirror copies
         *        to recover data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LS</code> specifies a load-sharing mirror volume. A load-sharing mirror reduces the network
         *        traffic to a FlexVol volume by providing additional read-only access to clients.
         *        </p>
         *        </li>
         * @see OntapVolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OntapVolumeType
         */
        Builder ontapVolumeType(OntapVolumeType ontapVolumeType);

        /**
         * <p>
         * Specifies the snapshot policy for the volume. There are three built-in snapshot policies:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>default</code>: This is the default policy. A maximum of six hourly snapshots taken five minutes past
         * the hour. A maximum of two daily snapshots taken Monday through Saturday at 10 minutes after midnight. A
         * maximum of two weekly snapshots taken every Sunday at 15 minutes after midnight.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>default-1weekly</code>: This policy is the same as the <code>default</code> policy except that it only
         * retains one snapshot from the weekly schedule.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>none</code>: This policy does not take any snapshots. This policy can be assigned to volumes to prevent
         * automatic snapshots from being taken.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can also provide the name of a custom policy that you created with the ONTAP CLI or REST API.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies">Snapshot
         * policies</a> in the Amazon FSx for NetApp ONTAP User Guide.
         * </p>
         * 
         * @param snapshotPolicy
         *        Specifies the snapshot policy for the volume. There are three built-in snapshot policies:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>default</code>: This is the default policy. A maximum of six hourly snapshots taken five minutes
         *        past the hour. A maximum of two daily snapshots taken Monday through Saturday at 10 minutes after
         *        midnight. A maximum of two weekly snapshots taken every Sunday at 15 minutes after midnight.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>default-1weekly</code>: This policy is the same as the <code>default</code> policy except that
         *        it only retains one snapshot from the weekly schedule.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>none</code>: This policy does not take any snapshots. This policy can be assigned to volumes to
         *        prevent automatic snapshots from being taken.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can also provide the name of a custom policy that you created with the ONTAP CLI or REST API.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies"
         *        >Snapshot policies</a> in the Amazon FSx for NetApp ONTAP User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotPolicy(String snapshotPolicy);

        /**
         * <p>
         * A boolean flag indicating whether tags for the volume should be copied to backups. This value defaults to
         * false. If it's set to true, all tags for the volume are copied to all automatic and user-initiated backups
         * where the user doesn't specify tags. If this value is true, and you specify one or more tags, only the
         * specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup,
         * no tags are copied from the volume, regardless of this value.
         * </p>
         * 
         * @param copyTagsToBackups
         *        A boolean flag indicating whether tags for the volume should be copied to backups. This value defaults
         *        to false. If it's set to true, all tags for the volume are copied to all automatic and user-initiated
         *        backups where the user doesn't specify tags. If this value is true, and you specify one or more tags,
         *        only the specified tags are copied to backups. If you specify one or more tags when creating a
         *        user-initiated backup, no tags are copied from the volume, regardless of this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTagsToBackups(Boolean copyTagsToBackups);

        /**
         * <p>
         * The SnapLock configuration object for an FSx for ONTAP SnapLock volume.
         * </p>
         * 
         * @param snaplockConfiguration
         *        The SnapLock configuration object for an FSx for ONTAP SnapLock volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snaplockConfiguration(SnaplockConfiguration snaplockConfiguration);

        /**
         * <p>
         * The SnapLock configuration object for an FSx for ONTAP SnapLock volume.
         * </p>
         * This is a convenience method that creates an instance of the {@link SnaplockConfiguration.Builder} avoiding
         * the need to create one manually via {@link SnaplockConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnaplockConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #snaplockConfiguration(SnaplockConfiguration)}.
         * 
         * @param snaplockConfiguration
         *        a consumer that will call methods on {@link SnaplockConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snaplockConfiguration(SnaplockConfiguration)
         */
        default Builder snaplockConfiguration(Consumer<SnaplockConfiguration.Builder> snaplockConfiguration) {
            return snaplockConfiguration(SnaplockConfiguration.builder().applyMutation(snaplockConfiguration).build());
        }

        /**
         * <p>
         * Use to specify the style of an ONTAP volume. For more information about FlexVols and FlexGroups, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-types.html">Volume types</a> in Amazon FSx for
         * NetApp ONTAP User Guide.
         * </p>
         * 
         * @param volumeStyle
         *        Use to specify the style of an ONTAP volume. For more information about FlexVols and FlexGroups, see
         *        <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-types.html">Volume types</a> in
         *        Amazon FSx for NetApp ONTAP User Guide.
         * @see VolumeStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeStyle
         */
        Builder volumeStyle(String volumeStyle);

        /**
         * <p>
         * Use to specify the style of an ONTAP volume. For more information about FlexVols and FlexGroups, see <a
         * href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-types.html">Volume types</a> in Amazon FSx for
         * NetApp ONTAP User Guide.
         * </p>
         * 
         * @param volumeStyle
         *        Use to specify the style of an ONTAP volume. For more information about FlexVols and FlexGroups, see
         *        <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-types.html">Volume types</a> in
         *        Amazon FSx for NetApp ONTAP User Guide.
         * @see VolumeStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeStyle
         */
        Builder volumeStyle(VolumeStyle volumeStyle);

        /**
         * <p>
         * This structure specifies configuration options for a volume’s storage aggregate or aggregates.
         * </p>
         * 
         * @param aggregateConfiguration
         *        This structure specifies configuration options for a volume’s storage aggregate or aggregates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregateConfiguration(AggregateConfiguration aggregateConfiguration);

        /**
         * <p>
         * This structure specifies configuration options for a volume’s storage aggregate or aggregates.
         * </p>
         * This is a convenience method that creates an instance of the {@link AggregateConfiguration.Builder} avoiding
         * the need to create one manually via {@link AggregateConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AggregateConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #aggregateConfiguration(AggregateConfiguration)}.
         * 
         * @param aggregateConfiguration
         *        a consumer that will call methods on {@link AggregateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregateConfiguration(AggregateConfiguration)
         */
        default Builder aggregateConfiguration(Consumer<AggregateConfiguration.Builder> aggregateConfiguration) {
            return aggregateConfiguration(AggregateConfiguration.builder().applyMutation(aggregateConfiguration).build());
        }

        /**
         * <p>
         * The configured size of the volume, in bytes.
         * </p>
         * 
         * @param sizeInBytes
         *        The configured size of the volume, in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInBytes(Long sizeInBytes);
    }

    static final class BuilderImpl implements Builder {
        private String flexCacheEndpointType;

        private String junctionPath;

        private String securityStyle;

        private Integer sizeInMegabytes;

        private Boolean storageEfficiencyEnabled;

        private String storageVirtualMachineId;

        private Boolean storageVirtualMachineRoot;

        private TieringPolicy tieringPolicy;

        private String uuid;

        private String ontapVolumeType;

        private String snapshotPolicy;

        private Boolean copyTagsToBackups;

        private SnaplockConfiguration snaplockConfiguration;

        private String volumeStyle;

        private AggregateConfiguration aggregateConfiguration;

        private Long sizeInBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(OntapVolumeConfiguration model) {
            flexCacheEndpointType(model.flexCacheEndpointType);
            junctionPath(model.junctionPath);
            securityStyle(model.securityStyle);
            sizeInMegabytes(model.sizeInMegabytes);
            storageEfficiencyEnabled(model.storageEfficiencyEnabled);
            storageVirtualMachineId(model.storageVirtualMachineId);
            storageVirtualMachineRoot(model.storageVirtualMachineRoot);
            tieringPolicy(model.tieringPolicy);
            uuid(model.uuid);
            ontapVolumeType(model.ontapVolumeType);
            snapshotPolicy(model.snapshotPolicy);
            copyTagsToBackups(model.copyTagsToBackups);
            snaplockConfiguration(model.snaplockConfiguration);
            volumeStyle(model.volumeStyle);
            aggregateConfiguration(model.aggregateConfiguration);
            sizeInBytes(model.sizeInBytes);
        }

        public final String getFlexCacheEndpointType() {
            return flexCacheEndpointType;
        }

        public final void setFlexCacheEndpointType(String flexCacheEndpointType) {
            this.flexCacheEndpointType = flexCacheEndpointType;
        }

        @Override
        public final Builder flexCacheEndpointType(String flexCacheEndpointType) {
            this.flexCacheEndpointType = flexCacheEndpointType;
            return this;
        }

        @Override
        public final Builder flexCacheEndpointType(FlexCacheEndpointType flexCacheEndpointType) {
            this.flexCacheEndpointType(flexCacheEndpointType == null ? null : flexCacheEndpointType.toString());
            return this;
        }

        public final String getJunctionPath() {
            return junctionPath;
        }

        public final void setJunctionPath(String junctionPath) {
            this.junctionPath = junctionPath;
        }

        @Override
        public final Builder junctionPath(String junctionPath) {
            this.junctionPath = junctionPath;
            return this;
        }

        public final String getSecurityStyle() {
            return securityStyle;
        }

        public final void setSecurityStyle(String securityStyle) {
            this.securityStyle = securityStyle;
        }

        @Override
        public final Builder securityStyle(String securityStyle) {
            this.securityStyle = securityStyle;
            return this;
        }

        @Override
        public final Builder securityStyle(SecurityStyle securityStyle) {
            this.securityStyle(securityStyle == null ? null : securityStyle.toString());
            return this;
        }

        public final Integer getSizeInMegabytes() {
            return sizeInMegabytes;
        }

        public final void setSizeInMegabytes(Integer sizeInMegabytes) {
            this.sizeInMegabytes = sizeInMegabytes;
        }

        @Override
        public final Builder sizeInMegabytes(Integer sizeInMegabytes) {
            this.sizeInMegabytes = sizeInMegabytes;
            return this;
        }

        public final Boolean getStorageEfficiencyEnabled() {
            return storageEfficiencyEnabled;
        }

        public final void setStorageEfficiencyEnabled(Boolean storageEfficiencyEnabled) {
            this.storageEfficiencyEnabled = storageEfficiencyEnabled;
        }

        @Override
        public final Builder storageEfficiencyEnabled(Boolean storageEfficiencyEnabled) {
            this.storageEfficiencyEnabled = storageEfficiencyEnabled;
            return this;
        }

        public final String getStorageVirtualMachineId() {
            return storageVirtualMachineId;
        }

        public final void setStorageVirtualMachineId(String storageVirtualMachineId) {
            this.storageVirtualMachineId = storageVirtualMachineId;
        }

        @Override
        public final Builder storageVirtualMachineId(String storageVirtualMachineId) {
            this.storageVirtualMachineId = storageVirtualMachineId;
            return this;
        }

        public final Boolean getStorageVirtualMachineRoot() {
            return storageVirtualMachineRoot;
        }

        public final void setStorageVirtualMachineRoot(Boolean storageVirtualMachineRoot) {
            this.storageVirtualMachineRoot = storageVirtualMachineRoot;
        }

        @Override
        public final Builder storageVirtualMachineRoot(Boolean storageVirtualMachineRoot) {
            this.storageVirtualMachineRoot = storageVirtualMachineRoot;
            return this;
        }

        public final TieringPolicy.Builder getTieringPolicy() {
            return tieringPolicy != null ? tieringPolicy.toBuilder() : null;
        }

        public final void setTieringPolicy(TieringPolicy.BuilderImpl tieringPolicy) {
            this.tieringPolicy = tieringPolicy != null ? tieringPolicy.build() : null;
        }

        @Override
        public final Builder tieringPolicy(TieringPolicy tieringPolicy) {
            this.tieringPolicy = tieringPolicy;
            return this;
        }

        public final String getUuid() {
            return uuid;
        }

        public final void setUuid(String uuid) {
            this.uuid = uuid;
        }

        @Override
        public final Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public final String getOntapVolumeType() {
            return ontapVolumeType;
        }

        public final void setOntapVolumeType(String ontapVolumeType) {
            this.ontapVolumeType = ontapVolumeType;
        }

        @Override
        public final Builder ontapVolumeType(String ontapVolumeType) {
            this.ontapVolumeType = ontapVolumeType;
            return this;
        }

        @Override
        public final Builder ontapVolumeType(OntapVolumeType ontapVolumeType) {
            this.ontapVolumeType(ontapVolumeType == null ? null : ontapVolumeType.toString());
            return this;
        }

        public final String getSnapshotPolicy() {
            return snapshotPolicy;
        }

        public final void setSnapshotPolicy(String snapshotPolicy) {
            this.snapshotPolicy = snapshotPolicy;
        }

        @Override
        public final Builder snapshotPolicy(String snapshotPolicy) {
            this.snapshotPolicy = snapshotPolicy;
            return this;
        }

        public final Boolean getCopyTagsToBackups() {
            return copyTagsToBackups;
        }

        public final void setCopyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
        }

        @Override
        public final Builder copyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
            return this;
        }

        public final SnaplockConfiguration.Builder getSnaplockConfiguration() {
            return snaplockConfiguration != null ? snaplockConfiguration.toBuilder() : null;
        }

        public final void setSnaplockConfiguration(SnaplockConfiguration.BuilderImpl snaplockConfiguration) {
            this.snaplockConfiguration = snaplockConfiguration != null ? snaplockConfiguration.build() : null;
        }

        @Override
        public final Builder snaplockConfiguration(SnaplockConfiguration snaplockConfiguration) {
            this.snaplockConfiguration = snaplockConfiguration;
            return this;
        }

        public final String getVolumeStyle() {
            return volumeStyle;
        }

        public final void setVolumeStyle(String volumeStyle) {
            this.volumeStyle = volumeStyle;
        }

        @Override
        public final Builder volumeStyle(String volumeStyle) {
            this.volumeStyle = volumeStyle;
            return this;
        }

        @Override
        public final Builder volumeStyle(VolumeStyle volumeStyle) {
            this.volumeStyle(volumeStyle == null ? null : volumeStyle.toString());
            return this;
        }

        public final AggregateConfiguration.Builder getAggregateConfiguration() {
            return aggregateConfiguration != null ? aggregateConfiguration.toBuilder() : null;
        }

        public final void setAggregateConfiguration(AggregateConfiguration.BuilderImpl aggregateConfiguration) {
            this.aggregateConfiguration = aggregateConfiguration != null ? aggregateConfiguration.build() : null;
        }

        @Override
        public final Builder aggregateConfiguration(AggregateConfiguration aggregateConfiguration) {
            this.aggregateConfiguration = aggregateConfiguration;
            return this;
        }

        public final Long getSizeInBytes() {
            return sizeInBytes;
        }

        public final void setSizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
        }

        @Override
        public final Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            return this;
        }

        @Override
        public OntapVolumeConfiguration build() {
            return new OntapVolumeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
