/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Used to create an S3 access point that accepts requests only from a virtual private cloud (VPC) to restrict data
 * access to a private network.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAndAttachS3AccessPointS3Configuration implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateAndAttachS3AccessPointS3Configuration.Builder, CreateAndAttachS3AccessPointS3Configuration> {
    private static final SdkField<S3AccessPointVpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField
            .<S3AccessPointVpcConfiguration> builder(MarshallingType.SDK_POJO).memberName("VpcConfiguration")
            .getter(getter(CreateAndAttachS3AccessPointS3Configuration::vpcConfiguration))
            .setter(setter(Builder::vpcConfiguration)).constructor(S3AccessPointVpcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()).build();

    private static final SdkField<String> POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Policy")
            .getter(getter(CreateAndAttachS3AccessPointS3Configuration::policy)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_CONFIGURATION_FIELD,
            POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final S3AccessPointVpcConfiguration vpcConfiguration;

    private final String policy;

    private CreateAndAttachS3AccessPointS3Configuration(BuilderImpl builder) {
        this.vpcConfiguration = builder.vpcConfiguration;
        this.policy = builder.policy;
    }

    /**
     * <p>
     * If included, Amazon S3 restricts access to this S3 access point to requests made from the specified virtual
     * private cloud (VPC).
     * </p>
     * 
     * @return If included, Amazon S3 restricts access to this S3 access point to requests made from the specified
     *         virtual private cloud (VPC).
     */
    public final S3AccessPointVpcConfiguration vpcConfiguration() {
        return vpcConfiguration;
    }

    /**
     * <p>
     * Specifies an access policy to associate with the S3 access point configuration. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html">Configuring IAM policies
     * for using access points</a> in the Amazon Simple Storage Service User Guide.
     * </p>
     * 
     * @return Specifies an access policy to associate with the S3 access point configuration. For more information, see
     *         <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html">Configuring
     *         IAM policies for using access points</a> in the Amazon Simple Storage Service User Guide.
     */
    public final String policy() {
        return policy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAndAttachS3AccessPointS3Configuration)) {
            return false;
        }
        CreateAndAttachS3AccessPointS3Configuration other = (CreateAndAttachS3AccessPointS3Configuration) obj;
        return Objects.equals(vpcConfiguration(), other.vpcConfiguration()) && Objects.equals(policy(), other.policy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAndAttachS3AccessPointS3Configuration").add("VpcConfiguration", vpcConfiguration())
                .add("Policy", policy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcConfiguration":
            return Optional.ofNullable(clazz.cast(vpcConfiguration()));
        case "Policy":
            return Optional.ofNullable(clazz.cast(policy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpcConfiguration", VPC_CONFIGURATION_FIELD);
        map.put("Policy", POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAndAttachS3AccessPointS3Configuration, T> g) {
        return obj -> g.apply((CreateAndAttachS3AccessPointS3Configuration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateAndAttachS3AccessPointS3Configuration> {
        /**
         * <p>
         * If included, Amazon S3 restricts access to this S3 access point to requests made from the specified virtual
         * private cloud (VPC).
         * </p>
         * 
         * @param vpcConfiguration
         *        If included, Amazon S3 restricts access to this S3 access point to requests made from the specified
         *        virtual private cloud (VPC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfiguration(S3AccessPointVpcConfiguration vpcConfiguration);

        /**
         * <p>
         * If included, Amazon S3 restricts access to this S3 access point to requests made from the specified virtual
         * private cloud (VPC).
         * </p>
         * This is a convenience method that creates an instance of the {@link S3AccessPointVpcConfiguration.Builder}
         * avoiding the need to create one manually via {@link S3AccessPointVpcConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3AccessPointVpcConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #vpcConfiguration(S3AccessPointVpcConfiguration)}.
         * 
         * @param vpcConfiguration
         *        a consumer that will call methods on {@link S3AccessPointVpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfiguration(S3AccessPointVpcConfiguration)
         */
        default Builder vpcConfiguration(Consumer<S3AccessPointVpcConfiguration.Builder> vpcConfiguration) {
            return vpcConfiguration(S3AccessPointVpcConfiguration.builder().applyMutation(vpcConfiguration).build());
        }

        /**
         * <p>
         * Specifies an access policy to associate with the S3 access point configuration. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html">Configuring IAM
         * policies for using access points</a> in the Amazon Simple Storage Service User Guide.
         * </p>
         * 
         * @param policy
         *        Specifies an access policy to associate with the S3 access point configuration. For more information,
         *        see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html">Configuring
         *        IAM policies for using access points</a> in the Amazon Simple Storage Service User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);
    }

    static final class BuilderImpl implements Builder {
        private S3AccessPointVpcConfiguration vpcConfiguration;

        private String policy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAndAttachS3AccessPointS3Configuration model) {
            vpcConfiguration(model.vpcConfiguration);
            policy(model.policy);
        }

        public final S3AccessPointVpcConfiguration.Builder getVpcConfiguration() {
            return vpcConfiguration != null ? vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(S3AccessPointVpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(S3AccessPointVpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final String getPolicy() {
            return policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        @Override
        public CreateAndAttachS3AccessPointS3Configuration build() {
            return new CreateAndAttachS3AccessPointS3Configuration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
