/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAndAttachS3AccessPointResponse extends FSxResponse implements
        ToCopyableBuilder<CreateAndAttachS3AccessPointResponse.Builder, CreateAndAttachS3AccessPointResponse> {
    private static final SdkField<S3AccessPointAttachment> S3_ACCESS_POINT_ATTACHMENT_FIELD = SdkField
            .<S3AccessPointAttachment> builder(MarshallingType.SDK_POJO).memberName("S3AccessPointAttachment")
            .getter(getter(CreateAndAttachS3AccessPointResponse::s3AccessPointAttachment))
            .setter(setter(Builder::s3AccessPointAttachment)).constructor(S3AccessPointAttachment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3AccessPointAttachment").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(S3_ACCESS_POINT_ATTACHMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final S3AccessPointAttachment s3AccessPointAttachment;

    private CreateAndAttachS3AccessPointResponse(BuilderImpl builder) {
        super(builder);
        this.s3AccessPointAttachment = builder.s3AccessPointAttachment;
    }

    /**
     * <p>
     * Describes the configuration of the S3 access point created.
     * </p>
     * 
     * @return Describes the configuration of the S3 access point created.
     */
    public final S3AccessPointAttachment s3AccessPointAttachment() {
        return s3AccessPointAttachment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(s3AccessPointAttachment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAndAttachS3AccessPointResponse)) {
            return false;
        }
        CreateAndAttachS3AccessPointResponse other = (CreateAndAttachS3AccessPointResponse) obj;
        return Objects.equals(s3AccessPointAttachment(), other.s3AccessPointAttachment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAndAttachS3AccessPointResponse").add("S3AccessPointAttachment", s3AccessPointAttachment())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3AccessPointAttachment":
            return Optional.ofNullable(clazz.cast(s3AccessPointAttachment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3AccessPointAttachment", S3_ACCESS_POINT_ATTACHMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAndAttachS3AccessPointResponse, T> g) {
        return obj -> g.apply((CreateAndAttachS3AccessPointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FSxResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateAndAttachS3AccessPointResponse> {
        /**
         * <p>
         * Describes the configuration of the S3 access point created.
         * </p>
         * 
         * @param s3AccessPointAttachment
         *        Describes the configuration of the S3 access point created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3AccessPointAttachment(S3AccessPointAttachment s3AccessPointAttachment);

        /**
         * <p>
         * Describes the configuration of the S3 access point created.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3AccessPointAttachment.Builder} avoiding
         * the need to create one manually via {@link S3AccessPointAttachment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3AccessPointAttachment.Builder#build()} is called immediately
         * and its result is passed to {@link #s3AccessPointAttachment(S3AccessPointAttachment)}.
         * 
         * @param s3AccessPointAttachment
         *        a consumer that will call methods on {@link S3AccessPointAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3AccessPointAttachment(S3AccessPointAttachment)
         */
        default Builder s3AccessPointAttachment(Consumer<S3AccessPointAttachment.Builder> s3AccessPointAttachment) {
            return s3AccessPointAttachment(S3AccessPointAttachment.builder().applyMutation(s3AccessPointAttachment).build());
        }
    }

    static final class BuilderImpl extends FSxResponse.BuilderImpl implements Builder {
        private S3AccessPointAttachment s3AccessPointAttachment;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAndAttachS3AccessPointResponse model) {
            super(model);
            s3AccessPointAttachment(model.s3AccessPointAttachment);
        }

        public final S3AccessPointAttachment.Builder getS3AccessPointAttachment() {
            return s3AccessPointAttachment != null ? s3AccessPointAttachment.toBuilder() : null;
        }

        public final void setS3AccessPointAttachment(S3AccessPointAttachment.BuilderImpl s3AccessPointAttachment) {
            this.s3AccessPointAttachment = s3AccessPointAttachment != null ? s3AccessPointAttachment.build() : null;
        }

        @Override
        public final Builder s3AccessPointAttachment(S3AccessPointAttachment s3AccessPointAttachment) {
            this.s3AccessPointAttachment = s3AccessPointAttachment;
            return this;
        }

        @Override
        public CreateAndAttachS3AccessPointResponse build() {
            return new CreateAndAttachS3AccessPointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
