/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Microsoft Active Directory attributes of the Amazon FSx for Windows File Server file system.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActiveDirectoryBackupAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<ActiveDirectoryBackupAttributes.Builder, ActiveDirectoryBackupAttributes> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(ActiveDirectoryBackupAttributes::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> ACTIVE_DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActiveDirectoryId").getter(getter(ActiveDirectoryBackupAttributes::activeDirectoryId))
            .setter(setter(Builder::activeDirectoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectoryId").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceARN").getter(getter(ActiveDirectoryBackupAttributes::resourceARN))
            .setter(setter(Builder::resourceARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            ACTIVE_DIRECTORY_ID_FIELD, RESOURCE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String domainName;

    private final String activeDirectoryId;

    private final String resourceARN;

    private ActiveDirectoryBackupAttributes(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.activeDirectoryId = builder.activeDirectoryId;
        this.resourceARN = builder.resourceARN;
    }

    /**
     * <p>
     * The fully qualified domain name of the self-managed Active Directory directory.
     * </p>
     * 
     * @return The fully qualified domain name of the self-managed Active Directory directory.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services Managed Microsoft Active Directory instance to which the file system is joined.
     * </p>
     * 
     * @return The ID of the Amazon Web Services Managed Microsoft Active Directory instance to which the file system is
     *         joined.
     */
    public final String activeDirectoryId() {
        return activeDirectoryId;
    }

    /**
     * Returns the value of the ResourceARN property for this object.
     * 
     * @return The value of the ResourceARN property for this object.
     */
    public final String resourceARN() {
        return resourceARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(activeDirectoryId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActiveDirectoryBackupAttributes)) {
            return false;
        }
        ActiveDirectoryBackupAttributes other = (ActiveDirectoryBackupAttributes) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(activeDirectoryId(), other.activeDirectoryId())
                && Objects.equals(resourceARN(), other.resourceARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActiveDirectoryBackupAttributes").add("DomainName", domainName())
                .add("ActiveDirectoryId", activeDirectoryId()).add("ResourceARN", resourceARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "ActiveDirectoryId":
            return Optional.ofNullable(clazz.cast(activeDirectoryId()));
        case "ResourceARN":
            return Optional.ofNullable(clazz.cast(resourceARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("ActiveDirectoryId", ACTIVE_DIRECTORY_ID_FIELD);
        map.put("ResourceARN", RESOURCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActiveDirectoryBackupAttributes, T> g) {
        return obj -> g.apply((ActiveDirectoryBackupAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActiveDirectoryBackupAttributes> {
        /**
         * <p>
         * The fully qualified domain name of the self-managed Active Directory directory.
         * </p>
         * 
         * @param domainName
         *        The fully qualified domain name of the self-managed Active Directory directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The ID of the Amazon Web Services Managed Microsoft Active Directory instance to which the file system is
         * joined.
         * </p>
         * 
         * @param activeDirectoryId
         *        The ID of the Amazon Web Services Managed Microsoft Active Directory instance to which the file system
         *        is joined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeDirectoryId(String activeDirectoryId);

        /**
         * Sets the value of the ResourceARN property for this object.
         *
         * @param resourceARN
         *        The new value for the ResourceARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceARN(String resourceARN);
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private String activeDirectoryId;

        private String resourceARN;

        private BuilderImpl() {
        }

        private BuilderImpl(ActiveDirectoryBackupAttributes model) {
            domainName(model.domainName);
            activeDirectoryId(model.activeDirectoryId);
            resourceARN(model.resourceARN);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getActiveDirectoryId() {
            return activeDirectoryId;
        }

        public final void setActiveDirectoryId(String activeDirectoryId) {
            this.activeDirectoryId = activeDirectoryId;
        }

        @Override
        public final Builder activeDirectoryId(String activeDirectoryId) {
            this.activeDirectoryId = activeDirectoryId;
            return this;
        }

        public final String getResourceARN() {
            return resourceARN;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        @Override
        public ActiveDirectoryBackupAttributes build() {
            return new ActiveDirectoryBackupAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
