/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.DataRepositoryAssociation;
import software.amazon.awssdk.services.fsx.model.FSxResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDataRepositoryAssociationResponse
extends FSxResponse
implements ToCopyableBuilder<Builder, UpdateDataRepositoryAssociationResponse> {
    private static final SdkField<DataRepositoryAssociation> ASSOCIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Association").getter(UpdateDataRepositoryAssociationResponse.getter(UpdateDataRepositoryAssociationResponse::association)).setter(UpdateDataRepositoryAssociationResponse.setter(Builder::association)).constructor(DataRepositoryAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Association").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateDataRepositoryAssociationResponse.memberNameToFieldInitializer();
    private final DataRepositoryAssociation association;

    private UpdateDataRepositoryAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.association = builder.association;
    }

    public final DataRepositoryAssociation association() {
        return this.association;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.association());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataRepositoryAssociationResponse)) {
            return false;
        }
        UpdateDataRepositoryAssociationResponse other = (UpdateDataRepositoryAssociationResponse)((Object)obj);
        return Objects.equals(this.association(), other.association());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDataRepositoryAssociationResponse").add("Association", (Object)this.association()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Association": {
                return Optional.ofNullable(clazz.cast(this.association()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<DataRepositoryAssociation>> map = new HashMap<String, SdkField<DataRepositoryAssociation>>();
        map.put("Association", ASSOCIATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataRepositoryAssociationResponse, T> g) {
        return obj -> g.apply((UpdateDataRepositoryAssociationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxResponse.BuilderImpl
    implements Builder {
        private DataRepositoryAssociation association;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataRepositoryAssociationResponse model) {
            super(model);
            this.association(model.association);
        }

        public final DataRepositoryAssociation.Builder getAssociation() {
            return this.association != null ? this.association.toBuilder() : null;
        }

        public final void setAssociation(DataRepositoryAssociation.BuilderImpl association) {
            this.association = association != null ? association.build() : null;
        }

        @Override
        public final Builder association(DataRepositoryAssociation association) {
            this.association = association;
            return this;
        }

        @Override
        public UpdateDataRepositoryAssociationResponse build() {
            return new UpdateDataRepositoryAssociationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FSxResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDataRepositoryAssociationResponse> {
        public Builder association(DataRepositoryAssociation var1);

        default public Builder association(Consumer<DataRepositoryAssociation.Builder> association) {
            return this.association((DataRepositoryAssociation)((DataRepositoryAssociation.Builder)DataRepositoryAssociation.builder().applyMutation(association)).build());
        }
    }
}

