/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.DiskIopsConfiguration;
import software.amazon.awssdk.services.fsx.model.FileSystemEndpoints;
import software.amazon.awssdk.services.fsx.model.OntapDeploymentType;
import software.amazon.awssdk.services.fsx.model.RouteTableIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OntapFileSystemConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OntapFileSystemConfiguration> {
    private static final SdkField<Integer> AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AutomaticBackupRetentionDays").getter(OntapFileSystemConfiguration.getter(OntapFileSystemConfiguration::automaticBackupRetentionDays)).setter(OntapFileSystemConfiguration.setter(Builder::automaticBackupRetentionDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticBackupRetentionDays").build()}).build();
    private static final SdkField<String> DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DailyAutomaticBackupStartTime").getter(OntapFileSystemConfiguration.getter(OntapFileSystemConfiguration::dailyAutomaticBackupStartTime)).setter(OntapFileSystemConfiguration.setter(Builder::dailyAutomaticBackupStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailyAutomaticBackupStartTime").build()}).build();
    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentType").getter(OntapFileSystemConfiguration.getter(OntapFileSystemConfiguration::deploymentTypeAsString)).setter(OntapFileSystemConfiguration.setter(Builder::deploymentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentType").build()}).build();
    private static final SdkField<String> ENDPOINT_IP_ADDRESS_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointIpAddressRange").getter(OntapFileSystemConfiguration.getter(OntapFileSystemConfiguration::endpointIpAddressRange)).setter(OntapFileSystemConfiguration.setter(Builder::endpointIpAddressRange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointIpAddressRange").build()}).build();
    private static final SdkField<FileSystemEndpoints> ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Endpoints").getter(OntapFileSystemConfiguration.getter(OntapFileSystemConfiguration::endpoints)).setter(OntapFileSystemConfiguration.setter(Builder::endpoints)).constructor(FileSystemEndpoints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoints").build()}).build();
    private static final SdkField<DiskIopsConfiguration> DISK_IOPS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DiskIopsConfiguration").getter(OntapFileSystemConfiguration.getter(OntapFileSystemConfiguration::diskIopsConfiguration)).setter(OntapFileSystemConfiguration.setter(Builder::diskIopsConfiguration)).constructor(DiskIopsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskIopsConfiguration").build()}).build();
    private static final SdkField<String> PREFERRED_SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredSubnetId").getter(OntapFileSystemConfiguration.getter(OntapFileSystemConfiguration::preferredSubnetId)).setter(OntapFileSystemConfiguration.setter(Builder::preferredSubnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredSubnetId").build()}).build();
    private static final SdkField<List<String>> ROUTE_TABLE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RouteTableIds").getter(OntapFileSystemConfiguration.getter(OntapFileSystemConfiguration::routeTableIds)).setter(OntapFileSystemConfiguration.setter(Builder::routeTableIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> THROUGHPUT_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ThroughputCapacity").getter(OntapFileSystemConfiguration.getter(OntapFileSystemConfiguration::throughputCapacity)).setter(OntapFileSystemConfiguration.setter(Builder::throughputCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputCapacity").build()}).build();
    private static final SdkField<String> WEEKLY_MAINTENANCE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WeeklyMaintenanceStartTime").getter(OntapFileSystemConfiguration.getter(OntapFileSystemConfiguration::weeklyMaintenanceStartTime)).setter(OntapFileSystemConfiguration.setter(Builder::weeklyMaintenanceStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceStartTime").build()}).build();
    private static final SdkField<String> FSX_ADMIN_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FsxAdminPassword").getter(OntapFileSystemConfiguration.getter(OntapFileSystemConfiguration::fsxAdminPassword)).setter(OntapFileSystemConfiguration.setter(Builder::fsxAdminPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FsxAdminPassword").build()}).build();
    private static final SdkField<Integer> HA_PAIRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HAPairs").getter(OntapFileSystemConfiguration.getter(OntapFileSystemConfiguration::haPairs)).setter(OntapFileSystemConfiguration.setter(Builder::haPairs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HAPairs").build()}).build();
    private static final SdkField<Integer> THROUGHPUT_CAPACITY_PER_HA_PAIR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ThroughputCapacityPerHAPair").getter(OntapFileSystemConfiguration.getter(OntapFileSystemConfiguration::throughputCapacityPerHAPair)).setter(OntapFileSystemConfiguration.setter(Builder::throughputCapacityPerHAPair)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputCapacityPerHAPair").build()}).build();
    private static final SdkField<String> ENDPOINT_IPV6_ADDRESS_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointIpv6AddressRange").getter(OntapFileSystemConfiguration.getter(OntapFileSystemConfiguration::endpointIpv6AddressRange)).setter(OntapFileSystemConfiguration.setter(Builder::endpointIpv6AddressRange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointIpv6AddressRange").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD, DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD, DEPLOYMENT_TYPE_FIELD, ENDPOINT_IP_ADDRESS_RANGE_FIELD, ENDPOINTS_FIELD, DISK_IOPS_CONFIGURATION_FIELD, PREFERRED_SUBNET_ID_FIELD, ROUTE_TABLE_IDS_FIELD, THROUGHPUT_CAPACITY_FIELD, WEEKLY_MAINTENANCE_START_TIME_FIELD, FSX_ADMIN_PASSWORD_FIELD, HA_PAIRS_FIELD, THROUGHPUT_CAPACITY_PER_HA_PAIR_FIELD, ENDPOINT_IPV6_ADDRESS_RANGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OntapFileSystemConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer automaticBackupRetentionDays;
    private final String dailyAutomaticBackupStartTime;
    private final String deploymentType;
    private final String endpointIpAddressRange;
    private final FileSystemEndpoints endpoints;
    private final DiskIopsConfiguration diskIopsConfiguration;
    private final String preferredSubnetId;
    private final List<String> routeTableIds;
    private final Integer throughputCapacity;
    private final String weeklyMaintenanceStartTime;
    private final String fsxAdminPassword;
    private final Integer haPairs;
    private final Integer throughputCapacityPerHAPair;
    private final String endpointIpv6AddressRange;

    private OntapFileSystemConfiguration(BuilderImpl builder) {
        this.automaticBackupRetentionDays = builder.automaticBackupRetentionDays;
        this.dailyAutomaticBackupStartTime = builder.dailyAutomaticBackupStartTime;
        this.deploymentType = builder.deploymentType;
        this.endpointIpAddressRange = builder.endpointIpAddressRange;
        this.endpoints = builder.endpoints;
        this.diskIopsConfiguration = builder.diskIopsConfiguration;
        this.preferredSubnetId = builder.preferredSubnetId;
        this.routeTableIds = builder.routeTableIds;
        this.throughputCapacity = builder.throughputCapacity;
        this.weeklyMaintenanceStartTime = builder.weeklyMaintenanceStartTime;
        this.fsxAdminPassword = builder.fsxAdminPassword;
        this.haPairs = builder.haPairs;
        this.throughputCapacityPerHAPair = builder.throughputCapacityPerHAPair;
        this.endpointIpv6AddressRange = builder.endpointIpv6AddressRange;
    }

    public final Integer automaticBackupRetentionDays() {
        return this.automaticBackupRetentionDays;
    }

    public final String dailyAutomaticBackupStartTime() {
        return this.dailyAutomaticBackupStartTime;
    }

    public final OntapDeploymentType deploymentType() {
        return OntapDeploymentType.fromValue(this.deploymentType);
    }

    public final String deploymentTypeAsString() {
        return this.deploymentType;
    }

    public final String endpointIpAddressRange() {
        return this.endpointIpAddressRange;
    }

    public final FileSystemEndpoints endpoints() {
        return this.endpoints;
    }

    public final DiskIopsConfiguration diskIopsConfiguration() {
        return this.diskIopsConfiguration;
    }

    public final String preferredSubnetId() {
        return this.preferredSubnetId;
    }

    public final boolean hasRouteTableIds() {
        return this.routeTableIds != null && !(this.routeTableIds instanceof SdkAutoConstructList);
    }

    public final List<String> routeTableIds() {
        return this.routeTableIds;
    }

    public final Integer throughputCapacity() {
        return this.throughputCapacity;
    }

    public final String weeklyMaintenanceStartTime() {
        return this.weeklyMaintenanceStartTime;
    }

    public final String fsxAdminPassword() {
        return this.fsxAdminPassword;
    }

    public final Integer haPairs() {
        return this.haPairs;
    }

    public final Integer throughputCapacityPerHAPair() {
        return this.throughputCapacityPerHAPair;
    }

    public final String endpointIpv6AddressRange() {
        return this.endpointIpv6AddressRange;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticBackupRetentionDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.dailyAutomaticBackupStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointIpAddressRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoints());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskIopsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRouteTableIds() ? this.routeTableIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.throughputCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.weeklyMaintenanceStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.fsxAdminPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.haPairs());
        hashCode = 31 * hashCode + Objects.hashCode(this.throughputCapacityPerHAPair());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointIpv6AddressRange());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OntapFileSystemConfiguration)) {
            return false;
        }
        OntapFileSystemConfiguration other = (OntapFileSystemConfiguration)obj;
        return Objects.equals(this.automaticBackupRetentionDays(), other.automaticBackupRetentionDays()) && Objects.equals(this.dailyAutomaticBackupStartTime(), other.dailyAutomaticBackupStartTime()) && Objects.equals(this.deploymentTypeAsString(), other.deploymentTypeAsString()) && Objects.equals(this.endpointIpAddressRange(), other.endpointIpAddressRange()) && Objects.equals(this.endpoints(), other.endpoints()) && Objects.equals(this.diskIopsConfiguration(), other.diskIopsConfiguration()) && Objects.equals(this.preferredSubnetId(), other.preferredSubnetId()) && this.hasRouteTableIds() == other.hasRouteTableIds() && Objects.equals(this.routeTableIds(), other.routeTableIds()) && Objects.equals(this.throughputCapacity(), other.throughputCapacity()) && Objects.equals(this.weeklyMaintenanceStartTime(), other.weeklyMaintenanceStartTime()) && Objects.equals(this.fsxAdminPassword(), other.fsxAdminPassword()) && Objects.equals(this.haPairs(), other.haPairs()) && Objects.equals(this.throughputCapacityPerHAPair(), other.throughputCapacityPerHAPair()) && Objects.equals(this.endpointIpv6AddressRange(), other.endpointIpv6AddressRange());
    }

    public final String toString() {
        return ToString.builder((String)"OntapFileSystemConfiguration").add("AutomaticBackupRetentionDays", (Object)this.automaticBackupRetentionDays()).add("DailyAutomaticBackupStartTime", (Object)this.dailyAutomaticBackupStartTime()).add("DeploymentType", (Object)this.deploymentTypeAsString()).add("EndpointIpAddressRange", (Object)this.endpointIpAddressRange()).add("Endpoints", (Object)this.endpoints()).add("DiskIopsConfiguration", (Object)this.diskIopsConfiguration()).add("PreferredSubnetId", (Object)this.preferredSubnetId()).add("RouteTableIds", this.hasRouteTableIds() ? this.routeTableIds() : null).add("ThroughputCapacity", (Object)this.throughputCapacity()).add("WeeklyMaintenanceStartTime", (Object)this.weeklyMaintenanceStartTime()).add("FsxAdminPassword", (Object)(this.fsxAdminPassword() == null ? null : "*** Sensitive Data Redacted ***")).add("HAPairs", (Object)this.haPairs()).add("ThroughputCapacityPerHAPair", (Object)this.throughputCapacityPerHAPair()).add("EndpointIpv6AddressRange", (Object)this.endpointIpv6AddressRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutomaticBackupRetentionDays": {
                return Optional.ofNullable(clazz.cast(this.automaticBackupRetentionDays()));
            }
            case "DailyAutomaticBackupStartTime": {
                return Optional.ofNullable(clazz.cast(this.dailyAutomaticBackupStartTime()));
            }
            case "DeploymentType": {
                return Optional.ofNullable(clazz.cast(this.deploymentTypeAsString()));
            }
            case "EndpointIpAddressRange": {
                return Optional.ofNullable(clazz.cast(this.endpointIpAddressRange()));
            }
            case "Endpoints": {
                return Optional.ofNullable(clazz.cast(this.endpoints()));
            }
            case "DiskIopsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.diskIopsConfiguration()));
            }
            case "PreferredSubnetId": {
                return Optional.ofNullable(clazz.cast(this.preferredSubnetId()));
            }
            case "RouteTableIds": {
                return Optional.ofNullable(clazz.cast(this.routeTableIds()));
            }
            case "ThroughputCapacity": {
                return Optional.ofNullable(clazz.cast(this.throughputCapacity()));
            }
            case "WeeklyMaintenanceStartTime": {
                return Optional.ofNullable(clazz.cast(this.weeklyMaintenanceStartTime()));
            }
            case "FsxAdminPassword": {
                return Optional.ofNullable(clazz.cast(this.fsxAdminPassword()));
            }
            case "HAPairs": {
                return Optional.ofNullable(clazz.cast(this.haPairs()));
            }
            case "ThroughputCapacityPerHAPair": {
                return Optional.ofNullable(clazz.cast(this.throughputCapacityPerHAPair()));
            }
            case "EndpointIpv6AddressRange": {
                return Optional.ofNullable(clazz.cast(this.endpointIpv6AddressRange()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AutomaticBackupRetentionDays", AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD);
        map.put("DailyAutomaticBackupStartTime", DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD);
        map.put("DeploymentType", DEPLOYMENT_TYPE_FIELD);
        map.put("EndpointIpAddressRange", ENDPOINT_IP_ADDRESS_RANGE_FIELD);
        map.put("Endpoints", ENDPOINTS_FIELD);
        map.put("DiskIopsConfiguration", DISK_IOPS_CONFIGURATION_FIELD);
        map.put("PreferredSubnetId", PREFERRED_SUBNET_ID_FIELD);
        map.put("RouteTableIds", ROUTE_TABLE_IDS_FIELD);
        map.put("ThroughputCapacity", THROUGHPUT_CAPACITY_FIELD);
        map.put("WeeklyMaintenanceStartTime", WEEKLY_MAINTENANCE_START_TIME_FIELD);
        map.put("FsxAdminPassword", FSX_ADMIN_PASSWORD_FIELD);
        map.put("HAPairs", HA_PAIRS_FIELD);
        map.put("ThroughputCapacityPerHAPair", THROUGHPUT_CAPACITY_PER_HA_PAIR_FIELD);
        map.put("EndpointIpv6AddressRange", ENDPOINT_IPV6_ADDRESS_RANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OntapFileSystemConfiguration, T> g) {
        return obj -> g.apply((OntapFileSystemConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer automaticBackupRetentionDays;
        private String dailyAutomaticBackupStartTime;
        private String deploymentType;
        private String endpointIpAddressRange;
        private FileSystemEndpoints endpoints;
        private DiskIopsConfiguration diskIopsConfiguration;
        private String preferredSubnetId;
        private List<String> routeTableIds = DefaultSdkAutoConstructList.getInstance();
        private Integer throughputCapacity;
        private String weeklyMaintenanceStartTime;
        private String fsxAdminPassword;
        private Integer haPairs;
        private Integer throughputCapacityPerHAPair;
        private String endpointIpv6AddressRange;

        private BuilderImpl() {
        }

        private BuilderImpl(OntapFileSystemConfiguration model) {
            this.automaticBackupRetentionDays(model.automaticBackupRetentionDays);
            this.dailyAutomaticBackupStartTime(model.dailyAutomaticBackupStartTime);
            this.deploymentType(model.deploymentType);
            this.endpointIpAddressRange(model.endpointIpAddressRange);
            this.endpoints(model.endpoints);
            this.diskIopsConfiguration(model.diskIopsConfiguration);
            this.preferredSubnetId(model.preferredSubnetId);
            this.routeTableIds(model.routeTableIds);
            this.throughputCapacity(model.throughputCapacity);
            this.weeklyMaintenanceStartTime(model.weeklyMaintenanceStartTime);
            this.fsxAdminPassword(model.fsxAdminPassword);
            this.haPairs(model.haPairs);
            this.throughputCapacityPerHAPair(model.throughputCapacityPerHAPair);
            this.endpointIpv6AddressRange(model.endpointIpv6AddressRange);
        }

        public final Integer getAutomaticBackupRetentionDays() {
            return this.automaticBackupRetentionDays;
        }

        public final void setAutomaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
        }

        @Override
        public final Builder automaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
            return this;
        }

        public final String getDailyAutomaticBackupStartTime() {
            return this.dailyAutomaticBackupStartTime;
        }

        public final void setDailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
        }

        @Override
        public final Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
            return this;
        }

        public final String getDeploymentType() {
            return this.deploymentType;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(OntapDeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final String getEndpointIpAddressRange() {
            return this.endpointIpAddressRange;
        }

        public final void setEndpointIpAddressRange(String endpointIpAddressRange) {
            this.endpointIpAddressRange = endpointIpAddressRange;
        }

        @Override
        public final Builder endpointIpAddressRange(String endpointIpAddressRange) {
            this.endpointIpAddressRange = endpointIpAddressRange;
            return this;
        }

        public final FileSystemEndpoints.Builder getEndpoints() {
            return this.endpoints != null ? this.endpoints.toBuilder() : null;
        }

        public final void setEndpoints(FileSystemEndpoints.BuilderImpl endpoints) {
            this.endpoints = endpoints != null ? endpoints.build() : null;
        }

        @Override
        public final Builder endpoints(FileSystemEndpoints endpoints) {
            this.endpoints = endpoints;
            return this;
        }

        public final DiskIopsConfiguration.Builder getDiskIopsConfiguration() {
            return this.diskIopsConfiguration != null ? this.diskIopsConfiguration.toBuilder() : null;
        }

        public final void setDiskIopsConfiguration(DiskIopsConfiguration.BuilderImpl diskIopsConfiguration) {
            this.diskIopsConfiguration = diskIopsConfiguration != null ? diskIopsConfiguration.build() : null;
        }

        @Override
        public final Builder diskIopsConfiguration(DiskIopsConfiguration diskIopsConfiguration) {
            this.diskIopsConfiguration = diskIopsConfiguration;
            return this;
        }

        public final String getPreferredSubnetId() {
            return this.preferredSubnetId;
        }

        public final void setPreferredSubnetId(String preferredSubnetId) {
            this.preferredSubnetId = preferredSubnetId;
        }

        @Override
        public final Builder preferredSubnetId(String preferredSubnetId) {
            this.preferredSubnetId = preferredSubnetId;
            return this;
        }

        public final Collection<String> getRouteTableIds() {
            if (this.routeTableIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.routeTableIds;
        }

        public final void setRouteTableIds(Collection<String> routeTableIds) {
            this.routeTableIds = RouteTableIdsCopier.copy(routeTableIds);
        }

        @Override
        public final Builder routeTableIds(Collection<String> routeTableIds) {
            this.routeTableIds = RouteTableIdsCopier.copy(routeTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeTableIds(String ... routeTableIds) {
            this.routeTableIds(Arrays.asList(routeTableIds));
            return this;
        }

        public final Integer getThroughputCapacity() {
            return this.throughputCapacity;
        }

        public final void setThroughputCapacity(Integer throughputCapacity) {
            this.throughputCapacity = throughputCapacity;
        }

        @Override
        public final Builder throughputCapacity(Integer throughputCapacity) {
            this.throughputCapacity = throughputCapacity;
            return this;
        }

        public final String getWeeklyMaintenanceStartTime() {
            return this.weeklyMaintenanceStartTime;
        }

        public final void setWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
        }

        @Override
        public final Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            return this;
        }

        public final String getFsxAdminPassword() {
            return this.fsxAdminPassword;
        }

        public final void setFsxAdminPassword(String fsxAdminPassword) {
            this.fsxAdminPassword = fsxAdminPassword;
        }

        @Override
        public final Builder fsxAdminPassword(String fsxAdminPassword) {
            this.fsxAdminPassword = fsxAdminPassword;
            return this;
        }

        public final Integer getHaPairs() {
            return this.haPairs;
        }

        public final void setHaPairs(Integer haPairs) {
            this.haPairs = haPairs;
        }

        @Override
        public final Builder haPairs(Integer haPairs) {
            this.haPairs = haPairs;
            return this;
        }

        public final Integer getThroughputCapacityPerHAPair() {
            return this.throughputCapacityPerHAPair;
        }

        public final void setThroughputCapacityPerHAPair(Integer throughputCapacityPerHAPair) {
            this.throughputCapacityPerHAPair = throughputCapacityPerHAPair;
        }

        @Override
        public final Builder throughputCapacityPerHAPair(Integer throughputCapacityPerHAPair) {
            this.throughputCapacityPerHAPair = throughputCapacityPerHAPair;
            return this;
        }

        public final String getEndpointIpv6AddressRange() {
            return this.endpointIpv6AddressRange;
        }

        public final void setEndpointIpv6AddressRange(String endpointIpv6AddressRange) {
            this.endpointIpv6AddressRange = endpointIpv6AddressRange;
        }

        @Override
        public final Builder endpointIpv6AddressRange(String endpointIpv6AddressRange) {
            this.endpointIpv6AddressRange = endpointIpv6AddressRange;
            return this;
        }

        public OntapFileSystemConfiguration build() {
            return new OntapFileSystemConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OntapFileSystemConfiguration> {
        public Builder automaticBackupRetentionDays(Integer var1);

        public Builder dailyAutomaticBackupStartTime(String var1);

        public Builder deploymentType(String var1);

        public Builder deploymentType(OntapDeploymentType var1);

        public Builder endpointIpAddressRange(String var1);

        public Builder endpoints(FileSystemEndpoints var1);

        default public Builder endpoints(Consumer<FileSystemEndpoints.Builder> endpoints) {
            return this.endpoints((FileSystemEndpoints)((FileSystemEndpoints.Builder)FileSystemEndpoints.builder().applyMutation(endpoints)).build());
        }

        public Builder diskIopsConfiguration(DiskIopsConfiguration var1);

        default public Builder diskIopsConfiguration(Consumer<DiskIopsConfiguration.Builder> diskIopsConfiguration) {
            return this.diskIopsConfiguration((DiskIopsConfiguration)((DiskIopsConfiguration.Builder)DiskIopsConfiguration.builder().applyMutation(diskIopsConfiguration)).build());
        }

        public Builder preferredSubnetId(String var1);

        public Builder routeTableIds(Collection<String> var1);

        public Builder routeTableIds(String ... var1);

        public Builder throughputCapacity(Integer var1);

        public Builder weeklyMaintenanceStartTime(String var1);

        public Builder fsxAdminPassword(String var1);

        public Builder haPairs(Integer var1);

        public Builder throughputCapacityPerHAPair(Integer var1);

        public Builder endpointIpv6AddressRange(String var1);
    }
}

