/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.FSxResponse;
import software.amazon.awssdk.services.fsx.model.S3AccessPointAttachment;
import software.amazon.awssdk.services.fsx.model.S3AccessPointAttachmentsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeS3AccessPointAttachmentsResponse
extends FSxResponse
implements ToCopyableBuilder<Builder, DescribeS3AccessPointAttachmentsResponse> {
    private static final SdkField<List<S3AccessPointAttachment>> S3_ACCESS_POINT_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("S3AccessPointAttachments").getter(DescribeS3AccessPointAttachmentsResponse.getter(DescribeS3AccessPointAttachmentsResponse::s3AccessPointAttachments)).setter(DescribeS3AccessPointAttachmentsResponse.setter(Builder::s3AccessPointAttachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3AccessPointAttachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(S3AccessPointAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeS3AccessPointAttachmentsResponse.getter(DescribeS3AccessPointAttachmentsResponse::nextToken)).setter(DescribeS3AccessPointAttachmentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_ACCESS_POINT_ATTACHMENTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeS3AccessPointAttachmentsResponse.memberNameToFieldInitializer();
    private final List<S3AccessPointAttachment> s3AccessPointAttachments;
    private final String nextToken;

    private DescribeS3AccessPointAttachmentsResponse(BuilderImpl builder) {
        super(builder);
        this.s3AccessPointAttachments = builder.s3AccessPointAttachments;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasS3AccessPointAttachments() {
        return this.s3AccessPointAttachments != null && !(this.s3AccessPointAttachments instanceof SdkAutoConstructList);
    }

    public final List<S3AccessPointAttachment> s3AccessPointAttachments() {
        return this.s3AccessPointAttachments;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasS3AccessPointAttachments() ? this.s3AccessPointAttachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeS3AccessPointAttachmentsResponse)) {
            return false;
        }
        DescribeS3AccessPointAttachmentsResponse other = (DescribeS3AccessPointAttachmentsResponse)((Object)obj);
        return this.hasS3AccessPointAttachments() == other.hasS3AccessPointAttachments() && Objects.equals(this.s3AccessPointAttachments(), other.s3AccessPointAttachments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeS3AccessPointAttachmentsResponse").add("S3AccessPointAttachments", this.hasS3AccessPointAttachments() ? this.s3AccessPointAttachments() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3AccessPointAttachments": {
                return Optional.ofNullable(clazz.cast(this.s3AccessPointAttachments()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("S3AccessPointAttachments", S3_ACCESS_POINT_ATTACHMENTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeS3AccessPointAttachmentsResponse, T> g) {
        return obj -> g.apply((DescribeS3AccessPointAttachmentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxResponse.BuilderImpl
    implements Builder {
        private List<S3AccessPointAttachment> s3AccessPointAttachments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeS3AccessPointAttachmentsResponse model) {
            super(model);
            this.s3AccessPointAttachments(model.s3AccessPointAttachments);
            this.nextToken(model.nextToken);
        }

        public final List<S3AccessPointAttachment.Builder> getS3AccessPointAttachments() {
            List<S3AccessPointAttachment.Builder> result = S3AccessPointAttachmentsCopier.copyToBuilder(this.s3AccessPointAttachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setS3AccessPointAttachments(Collection<S3AccessPointAttachment.BuilderImpl> s3AccessPointAttachments) {
            this.s3AccessPointAttachments = S3AccessPointAttachmentsCopier.copyFromBuilder(s3AccessPointAttachments);
        }

        @Override
        public final Builder s3AccessPointAttachments(Collection<S3AccessPointAttachment> s3AccessPointAttachments) {
            this.s3AccessPointAttachments = S3AccessPointAttachmentsCopier.copy(s3AccessPointAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3AccessPointAttachments(S3AccessPointAttachment ... s3AccessPointAttachments) {
            this.s3AccessPointAttachments(Arrays.asList(s3AccessPointAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3AccessPointAttachments(Consumer<S3AccessPointAttachment.Builder> ... s3AccessPointAttachments) {
            this.s3AccessPointAttachments(Stream.of(s3AccessPointAttachments).map(c -> (S3AccessPointAttachment)((S3AccessPointAttachment.Builder)S3AccessPointAttachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeS3AccessPointAttachmentsResponse build() {
            return new DescribeS3AccessPointAttachmentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FSxResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeS3AccessPointAttachmentsResponse> {
        public Builder s3AccessPointAttachments(Collection<S3AccessPointAttachment> var1);

        public Builder s3AccessPointAttachments(S3AccessPointAttachment ... var1);

        public Builder s3AccessPointAttachments(Consumer<S3AccessPointAttachment.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

