/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ActiveDirectoryErrorType {
    DOMAIN_NOT_FOUND("DOMAIN_NOT_FOUND"),
    INCOMPATIBLE_DOMAIN_MODE("INCOMPATIBLE_DOMAIN_MODE"),
    WRONG_VPC("WRONG_VPC"),
    INVALID_NETWORK_TYPE("INVALID_NETWORK_TYPE"),
    INVALID_DOMAIN_STAGE("INVALID_DOMAIN_STAGE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ActiveDirectoryErrorType> VALUE_MAP;
    private final String value;

    private ActiveDirectoryErrorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ActiveDirectoryErrorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ActiveDirectoryErrorType> knownValues() {
        EnumSet<ActiveDirectoryErrorType> knownValues = EnumSet.allOf(ActiveDirectoryErrorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ActiveDirectoryErrorType.class, ActiveDirectoryErrorType::toString);
    }
}

