/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.OpenZFSNfsExportOptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpenZFSClientConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpenZFSClientConfiguration> {
    private static final SdkField<String> CLIENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Clients").getter(OpenZFSClientConfiguration.getter(OpenZFSClientConfiguration::clients)).setter(OpenZFSClientConfiguration.setter(Builder::clients)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Clients").build()}).build();
    private static final SdkField<List<String>> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Options").getter(OpenZFSClientConfiguration.getter(OpenZFSClientConfiguration::options)).setter(OpenZFSClientConfiguration.setter(Builder::options)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENTS_FIELD, OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OpenZFSClientConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clients;
    private final List<String> options;

    private OpenZFSClientConfiguration(BuilderImpl builder) {
        this.clients = builder.clients;
        this.options = builder.options;
    }

    public final String clients() {
        return this.clients;
    }

    public final boolean hasOptions() {
        return this.options != null && !(this.options instanceof SdkAutoConstructList);
    }

    public final List<String> options() {
        return this.options;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clients());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptions() ? this.options() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenZFSClientConfiguration)) {
            return false;
        }
        OpenZFSClientConfiguration other = (OpenZFSClientConfiguration)obj;
        return Objects.equals(this.clients(), other.clients()) && this.hasOptions() == other.hasOptions() && Objects.equals(this.options(), other.options());
    }

    public final String toString() {
        return ToString.builder((String)"OpenZFSClientConfiguration").add("Clients", (Object)this.clients()).add("Options", this.hasOptions() ? this.options() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Clients": {
                return Optional.ofNullable(clazz.cast(this.clients()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Clients", CLIENTS_FIELD);
        map.put("Options", OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpenZFSClientConfiguration, T> g) {
        return obj -> g.apply((OpenZFSClientConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clients;
        private List<String> options = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OpenZFSClientConfiguration model) {
            this.clients(model.clients);
            this.options(model.options);
        }

        public final String getClients() {
            return this.clients;
        }

        public final void setClients(String clients) {
            this.clients = clients;
        }

        @Override
        public final Builder clients(String clients) {
            this.clients = clients;
            return this;
        }

        public final Collection<String> getOptions() {
            if (this.options instanceof SdkAutoConstructList) {
                return null;
            }
            return this.options;
        }

        public final void setOptions(Collection<String> options) {
            this.options = OpenZFSNfsExportOptionsCopier.copy(options);
        }

        @Override
        public final Builder options(Collection<String> options) {
            this.options = OpenZFSNfsExportOptionsCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(String ... options) {
            this.options(Arrays.asList(options));
            return this;
        }

        public OpenZFSClientConfiguration build() {
            return new OpenZFSClientConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpenZFSClientConfiguration> {
        public Builder clients(String var1);

        public Builder options(Collection<String> var1);

        public Builder options(String ... var1);
    }
}

