/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.AutoImportPolicyType;
import software.amazon.awssdk.services.fsx.model.DataCompressionType;
import software.amazon.awssdk.services.fsx.model.LustreLogCreateConfiguration;
import software.amazon.awssdk.services.fsx.model.LustreReadCacheConfiguration;
import software.amazon.awssdk.services.fsx.model.LustreRootSquashConfiguration;
import software.amazon.awssdk.services.fsx.model.UpdateFileSystemLustreMetadataConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFileSystemLustreConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateFileSystemLustreConfiguration> {
    private static final SdkField<String> WEEKLY_MAINTENANCE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WeeklyMaintenanceStartTime").getter(UpdateFileSystemLustreConfiguration.getter(UpdateFileSystemLustreConfiguration::weeklyMaintenanceStartTime)).setter(UpdateFileSystemLustreConfiguration.setter(Builder::weeklyMaintenanceStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceStartTime").build()}).build();
    private static final SdkField<String> DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DailyAutomaticBackupStartTime").getter(UpdateFileSystemLustreConfiguration.getter(UpdateFileSystemLustreConfiguration::dailyAutomaticBackupStartTime)).setter(UpdateFileSystemLustreConfiguration.setter(Builder::dailyAutomaticBackupStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailyAutomaticBackupStartTime").build()}).build();
    private static final SdkField<Integer> AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AutomaticBackupRetentionDays").getter(UpdateFileSystemLustreConfiguration.getter(UpdateFileSystemLustreConfiguration::automaticBackupRetentionDays)).setter(UpdateFileSystemLustreConfiguration.setter(Builder::automaticBackupRetentionDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticBackupRetentionDays").build()}).build();
    private static final SdkField<String> AUTO_IMPORT_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoImportPolicy").getter(UpdateFileSystemLustreConfiguration.getter(UpdateFileSystemLustreConfiguration::autoImportPolicyAsString)).setter(UpdateFileSystemLustreConfiguration.setter(Builder::autoImportPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoImportPolicy").build()}).build();
    private static final SdkField<String> DATA_COMPRESSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataCompressionType").getter(UpdateFileSystemLustreConfiguration.getter(UpdateFileSystemLustreConfiguration::dataCompressionTypeAsString)).setter(UpdateFileSystemLustreConfiguration.setter(Builder::dataCompressionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCompressionType").build()}).build();
    private static final SdkField<LustreLogCreateConfiguration> LOG_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LogConfiguration").getter(UpdateFileSystemLustreConfiguration.getter(UpdateFileSystemLustreConfiguration::logConfiguration)).setter(UpdateFileSystemLustreConfiguration.setter(Builder::logConfiguration)).constructor(LustreLogCreateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogConfiguration").build()}).build();
    private static final SdkField<LustreRootSquashConfiguration> ROOT_SQUASH_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RootSquashConfiguration").getter(UpdateFileSystemLustreConfiguration.getter(UpdateFileSystemLustreConfiguration::rootSquashConfiguration)).setter(UpdateFileSystemLustreConfiguration.setter(Builder::rootSquashConfiguration)).constructor(LustreRootSquashConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootSquashConfiguration").build()}).build();
    private static final SdkField<Integer> PER_UNIT_STORAGE_THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PerUnitStorageThroughput").getter(UpdateFileSystemLustreConfiguration.getter(UpdateFileSystemLustreConfiguration::perUnitStorageThroughput)).setter(UpdateFileSystemLustreConfiguration.setter(Builder::perUnitStorageThroughput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerUnitStorageThroughput").build()}).build();
    private static final SdkField<UpdateFileSystemLustreMetadataConfiguration> METADATA_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetadataConfiguration").getter(UpdateFileSystemLustreConfiguration.getter(UpdateFileSystemLustreConfiguration::metadataConfiguration)).setter(UpdateFileSystemLustreConfiguration.setter(Builder::metadataConfiguration)).constructor(UpdateFileSystemLustreMetadataConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataConfiguration").build()}).build();
    private static final SdkField<Integer> THROUGHPUT_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ThroughputCapacity").getter(UpdateFileSystemLustreConfiguration.getter(UpdateFileSystemLustreConfiguration::throughputCapacity)).setter(UpdateFileSystemLustreConfiguration.setter(Builder::throughputCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputCapacity").build()}).build();
    private static final SdkField<LustreReadCacheConfiguration> DATA_READ_CACHE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataReadCacheConfiguration").getter(UpdateFileSystemLustreConfiguration.getter(UpdateFileSystemLustreConfiguration::dataReadCacheConfiguration)).setter(UpdateFileSystemLustreConfiguration.setter(Builder::dataReadCacheConfiguration)).constructor(LustreReadCacheConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataReadCacheConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEEKLY_MAINTENANCE_START_TIME_FIELD, DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD, AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD, AUTO_IMPORT_POLICY_FIELD, DATA_COMPRESSION_TYPE_FIELD, LOG_CONFIGURATION_FIELD, ROOT_SQUASH_CONFIGURATION_FIELD, PER_UNIT_STORAGE_THROUGHPUT_FIELD, METADATA_CONFIGURATION_FIELD, THROUGHPUT_CAPACITY_FIELD, DATA_READ_CACHE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateFileSystemLustreConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String weeklyMaintenanceStartTime;
    private final String dailyAutomaticBackupStartTime;
    private final Integer automaticBackupRetentionDays;
    private final String autoImportPolicy;
    private final String dataCompressionType;
    private final LustreLogCreateConfiguration logConfiguration;
    private final LustreRootSquashConfiguration rootSquashConfiguration;
    private final Integer perUnitStorageThroughput;
    private final UpdateFileSystemLustreMetadataConfiguration metadataConfiguration;
    private final Integer throughputCapacity;
    private final LustreReadCacheConfiguration dataReadCacheConfiguration;

    private UpdateFileSystemLustreConfiguration(BuilderImpl builder) {
        this.weeklyMaintenanceStartTime = builder.weeklyMaintenanceStartTime;
        this.dailyAutomaticBackupStartTime = builder.dailyAutomaticBackupStartTime;
        this.automaticBackupRetentionDays = builder.automaticBackupRetentionDays;
        this.autoImportPolicy = builder.autoImportPolicy;
        this.dataCompressionType = builder.dataCompressionType;
        this.logConfiguration = builder.logConfiguration;
        this.rootSquashConfiguration = builder.rootSquashConfiguration;
        this.perUnitStorageThroughput = builder.perUnitStorageThroughput;
        this.metadataConfiguration = builder.metadataConfiguration;
        this.throughputCapacity = builder.throughputCapacity;
        this.dataReadCacheConfiguration = builder.dataReadCacheConfiguration;
    }

    public final String weeklyMaintenanceStartTime() {
        return this.weeklyMaintenanceStartTime;
    }

    public final String dailyAutomaticBackupStartTime() {
        return this.dailyAutomaticBackupStartTime;
    }

    public final Integer automaticBackupRetentionDays() {
        return this.automaticBackupRetentionDays;
    }

    public final AutoImportPolicyType autoImportPolicy() {
        return AutoImportPolicyType.fromValue(this.autoImportPolicy);
    }

    public final String autoImportPolicyAsString() {
        return this.autoImportPolicy;
    }

    public final DataCompressionType dataCompressionType() {
        return DataCompressionType.fromValue(this.dataCompressionType);
    }

    public final String dataCompressionTypeAsString() {
        return this.dataCompressionType;
    }

    public final LustreLogCreateConfiguration logConfiguration() {
        return this.logConfiguration;
    }

    public final LustreRootSquashConfiguration rootSquashConfiguration() {
        return this.rootSquashConfiguration;
    }

    public final Integer perUnitStorageThroughput() {
        return this.perUnitStorageThroughput;
    }

    public final UpdateFileSystemLustreMetadataConfiguration metadataConfiguration() {
        return this.metadataConfiguration;
    }

    public final Integer throughputCapacity() {
        return this.throughputCapacity;
    }

    public final LustreReadCacheConfiguration dataReadCacheConfiguration() {
        return this.dataReadCacheConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.weeklyMaintenanceStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dailyAutomaticBackupStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticBackupRetentionDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoImportPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataCompressionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootSquashConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.perUnitStorageThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.throughputCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataReadCacheConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFileSystemLustreConfiguration)) {
            return false;
        }
        UpdateFileSystemLustreConfiguration other = (UpdateFileSystemLustreConfiguration)obj;
        return Objects.equals(this.weeklyMaintenanceStartTime(), other.weeklyMaintenanceStartTime()) && Objects.equals(this.dailyAutomaticBackupStartTime(), other.dailyAutomaticBackupStartTime()) && Objects.equals(this.automaticBackupRetentionDays(), other.automaticBackupRetentionDays()) && Objects.equals(this.autoImportPolicyAsString(), other.autoImportPolicyAsString()) && Objects.equals(this.dataCompressionTypeAsString(), other.dataCompressionTypeAsString()) && Objects.equals(this.logConfiguration(), other.logConfiguration()) && Objects.equals(this.rootSquashConfiguration(), other.rootSquashConfiguration()) && Objects.equals(this.perUnitStorageThroughput(), other.perUnitStorageThroughput()) && Objects.equals(this.metadataConfiguration(), other.metadataConfiguration()) && Objects.equals(this.throughputCapacity(), other.throughputCapacity()) && Objects.equals(this.dataReadCacheConfiguration(), other.dataReadCacheConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFileSystemLustreConfiguration").add("WeeklyMaintenanceStartTime", (Object)this.weeklyMaintenanceStartTime()).add("DailyAutomaticBackupStartTime", (Object)this.dailyAutomaticBackupStartTime()).add("AutomaticBackupRetentionDays", (Object)this.automaticBackupRetentionDays()).add("AutoImportPolicy", (Object)this.autoImportPolicyAsString()).add("DataCompressionType", (Object)this.dataCompressionTypeAsString()).add("LogConfiguration", (Object)this.logConfiguration()).add("RootSquashConfiguration", (Object)this.rootSquashConfiguration()).add("PerUnitStorageThroughput", (Object)this.perUnitStorageThroughput()).add("MetadataConfiguration", (Object)this.metadataConfiguration()).add("ThroughputCapacity", (Object)this.throughputCapacity()).add("DataReadCacheConfiguration", (Object)this.dataReadCacheConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WeeklyMaintenanceStartTime": {
                return Optional.ofNullable(clazz.cast(this.weeklyMaintenanceStartTime()));
            }
            case "DailyAutomaticBackupStartTime": {
                return Optional.ofNullable(clazz.cast(this.dailyAutomaticBackupStartTime()));
            }
            case "AutomaticBackupRetentionDays": {
                return Optional.ofNullable(clazz.cast(this.automaticBackupRetentionDays()));
            }
            case "AutoImportPolicy": {
                return Optional.ofNullable(clazz.cast(this.autoImportPolicyAsString()));
            }
            case "DataCompressionType": {
                return Optional.ofNullable(clazz.cast(this.dataCompressionTypeAsString()));
            }
            case "LogConfiguration": {
                return Optional.ofNullable(clazz.cast(this.logConfiguration()));
            }
            case "RootSquashConfiguration": {
                return Optional.ofNullable(clazz.cast(this.rootSquashConfiguration()));
            }
            case "PerUnitStorageThroughput": {
                return Optional.ofNullable(clazz.cast(this.perUnitStorageThroughput()));
            }
            case "MetadataConfiguration": {
                return Optional.ofNullable(clazz.cast(this.metadataConfiguration()));
            }
            case "ThroughputCapacity": {
                return Optional.ofNullable(clazz.cast(this.throughputCapacity()));
            }
            case "DataReadCacheConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataReadCacheConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WeeklyMaintenanceStartTime", WEEKLY_MAINTENANCE_START_TIME_FIELD);
        map.put("DailyAutomaticBackupStartTime", DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD);
        map.put("AutomaticBackupRetentionDays", AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD);
        map.put("AutoImportPolicy", AUTO_IMPORT_POLICY_FIELD);
        map.put("DataCompressionType", DATA_COMPRESSION_TYPE_FIELD);
        map.put("LogConfiguration", LOG_CONFIGURATION_FIELD);
        map.put("RootSquashConfiguration", ROOT_SQUASH_CONFIGURATION_FIELD);
        map.put("PerUnitStorageThroughput", PER_UNIT_STORAGE_THROUGHPUT_FIELD);
        map.put("MetadataConfiguration", METADATA_CONFIGURATION_FIELD);
        map.put("ThroughputCapacity", THROUGHPUT_CAPACITY_FIELD);
        map.put("DataReadCacheConfiguration", DATA_READ_CACHE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFileSystemLustreConfiguration, T> g) {
        return obj -> g.apply((UpdateFileSystemLustreConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String weeklyMaintenanceStartTime;
        private String dailyAutomaticBackupStartTime;
        private Integer automaticBackupRetentionDays;
        private String autoImportPolicy;
        private String dataCompressionType;
        private LustreLogCreateConfiguration logConfiguration;
        private LustreRootSquashConfiguration rootSquashConfiguration;
        private Integer perUnitStorageThroughput;
        private UpdateFileSystemLustreMetadataConfiguration metadataConfiguration;
        private Integer throughputCapacity;
        private LustreReadCacheConfiguration dataReadCacheConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFileSystemLustreConfiguration model) {
            this.weeklyMaintenanceStartTime(model.weeklyMaintenanceStartTime);
            this.dailyAutomaticBackupStartTime(model.dailyAutomaticBackupStartTime);
            this.automaticBackupRetentionDays(model.automaticBackupRetentionDays);
            this.autoImportPolicy(model.autoImportPolicy);
            this.dataCompressionType(model.dataCompressionType);
            this.logConfiguration(model.logConfiguration);
            this.rootSquashConfiguration(model.rootSquashConfiguration);
            this.perUnitStorageThroughput(model.perUnitStorageThroughput);
            this.metadataConfiguration(model.metadataConfiguration);
            this.throughputCapacity(model.throughputCapacity);
            this.dataReadCacheConfiguration(model.dataReadCacheConfiguration);
        }

        public final String getWeeklyMaintenanceStartTime() {
            return this.weeklyMaintenanceStartTime;
        }

        public final void setWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
        }

        @Override
        public final Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            return this;
        }

        public final String getDailyAutomaticBackupStartTime() {
            return this.dailyAutomaticBackupStartTime;
        }

        public final void setDailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
        }

        @Override
        public final Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
            return this;
        }

        public final Integer getAutomaticBackupRetentionDays() {
            return this.automaticBackupRetentionDays;
        }

        public final void setAutomaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
        }

        @Override
        public final Builder automaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
            return this;
        }

        public final String getAutoImportPolicy() {
            return this.autoImportPolicy;
        }

        public final void setAutoImportPolicy(String autoImportPolicy) {
            this.autoImportPolicy = autoImportPolicy;
        }

        @Override
        public final Builder autoImportPolicy(String autoImportPolicy) {
            this.autoImportPolicy = autoImportPolicy;
            return this;
        }

        @Override
        public final Builder autoImportPolicy(AutoImportPolicyType autoImportPolicy) {
            this.autoImportPolicy(autoImportPolicy == null ? null : autoImportPolicy.toString());
            return this;
        }

        public final String getDataCompressionType() {
            return this.dataCompressionType;
        }

        public final void setDataCompressionType(String dataCompressionType) {
            this.dataCompressionType = dataCompressionType;
        }

        @Override
        public final Builder dataCompressionType(String dataCompressionType) {
            this.dataCompressionType = dataCompressionType;
            return this;
        }

        @Override
        public final Builder dataCompressionType(DataCompressionType dataCompressionType) {
            this.dataCompressionType(dataCompressionType == null ? null : dataCompressionType.toString());
            return this;
        }

        public final LustreLogCreateConfiguration.Builder getLogConfiguration() {
            return this.logConfiguration != null ? this.logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(LustreLogCreateConfiguration.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(LustreLogCreateConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public final LustreRootSquashConfiguration.Builder getRootSquashConfiguration() {
            return this.rootSquashConfiguration != null ? this.rootSquashConfiguration.toBuilder() : null;
        }

        public final void setRootSquashConfiguration(LustreRootSquashConfiguration.BuilderImpl rootSquashConfiguration) {
            this.rootSquashConfiguration = rootSquashConfiguration != null ? rootSquashConfiguration.build() : null;
        }

        @Override
        public final Builder rootSquashConfiguration(LustreRootSquashConfiguration rootSquashConfiguration) {
            this.rootSquashConfiguration = rootSquashConfiguration;
            return this;
        }

        public final Integer getPerUnitStorageThroughput() {
            return this.perUnitStorageThroughput;
        }

        public final void setPerUnitStorageThroughput(Integer perUnitStorageThroughput) {
            this.perUnitStorageThroughput = perUnitStorageThroughput;
        }

        @Override
        public final Builder perUnitStorageThroughput(Integer perUnitStorageThroughput) {
            this.perUnitStorageThroughput = perUnitStorageThroughput;
            return this;
        }

        public final UpdateFileSystemLustreMetadataConfiguration.Builder getMetadataConfiguration() {
            return this.metadataConfiguration != null ? this.metadataConfiguration.toBuilder() : null;
        }

        public final void setMetadataConfiguration(UpdateFileSystemLustreMetadataConfiguration.BuilderImpl metadataConfiguration) {
            this.metadataConfiguration = metadataConfiguration != null ? metadataConfiguration.build() : null;
        }

        @Override
        public final Builder metadataConfiguration(UpdateFileSystemLustreMetadataConfiguration metadataConfiguration) {
            this.metadataConfiguration = metadataConfiguration;
            return this;
        }

        public final Integer getThroughputCapacity() {
            return this.throughputCapacity;
        }

        public final void setThroughputCapacity(Integer throughputCapacity) {
            this.throughputCapacity = throughputCapacity;
        }

        @Override
        public final Builder throughputCapacity(Integer throughputCapacity) {
            this.throughputCapacity = throughputCapacity;
            return this;
        }

        public final LustreReadCacheConfiguration.Builder getDataReadCacheConfiguration() {
            return this.dataReadCacheConfiguration != null ? this.dataReadCacheConfiguration.toBuilder() : null;
        }

        public final void setDataReadCacheConfiguration(LustreReadCacheConfiguration.BuilderImpl dataReadCacheConfiguration) {
            this.dataReadCacheConfiguration = dataReadCacheConfiguration != null ? dataReadCacheConfiguration.build() : null;
        }

        @Override
        public final Builder dataReadCacheConfiguration(LustreReadCacheConfiguration dataReadCacheConfiguration) {
            this.dataReadCacheConfiguration = dataReadCacheConfiguration;
            return this;
        }

        public UpdateFileSystemLustreConfiguration build() {
            return new UpdateFileSystemLustreConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateFileSystemLustreConfiguration> {
        public Builder weeklyMaintenanceStartTime(String var1);

        public Builder dailyAutomaticBackupStartTime(String var1);

        public Builder automaticBackupRetentionDays(Integer var1);

        public Builder autoImportPolicy(String var1);

        public Builder autoImportPolicy(AutoImportPolicyType var1);

        public Builder dataCompressionType(String var1);

        public Builder dataCompressionType(DataCompressionType var1);

        public Builder logConfiguration(LustreLogCreateConfiguration var1);

        default public Builder logConfiguration(Consumer<LustreLogCreateConfiguration.Builder> logConfiguration) {
            return this.logConfiguration((LustreLogCreateConfiguration)((LustreLogCreateConfiguration.Builder)LustreLogCreateConfiguration.builder().applyMutation(logConfiguration)).build());
        }

        public Builder rootSquashConfiguration(LustreRootSquashConfiguration var1);

        default public Builder rootSquashConfiguration(Consumer<LustreRootSquashConfiguration.Builder> rootSquashConfiguration) {
            return this.rootSquashConfiguration((LustreRootSquashConfiguration)((LustreRootSquashConfiguration.Builder)LustreRootSquashConfiguration.builder().applyMutation(rootSquashConfiguration)).build());
        }

        public Builder perUnitStorageThroughput(Integer var1);

        public Builder metadataConfiguration(UpdateFileSystemLustreMetadataConfiguration var1);

        default public Builder metadataConfiguration(Consumer<UpdateFileSystemLustreMetadataConfiguration.Builder> metadataConfiguration) {
            return this.metadataConfiguration((UpdateFileSystemLustreMetadataConfiguration)((UpdateFileSystemLustreMetadataConfiguration.Builder)UpdateFileSystemLustreMetadataConfiguration.builder().applyMutation(metadataConfiguration)).build());
        }

        public Builder throughputCapacity(Integer var1);

        public Builder dataReadCacheConfiguration(LustreReadCacheConfiguration var1);

        default public Builder dataReadCacheConfiguration(Consumer<LustreReadCacheConfiguration.Builder> dataReadCacheConfiguration) {
            return this.dataReadCacheConfiguration((LustreReadCacheConfiguration)((LustreReadCacheConfiguration.Builder)LustreReadCacheConfiguration.builder().applyMutation(dataReadCacheConfiguration)).build());
        }
    }
}

