/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.CreateFileCacheDataRepositoryAssociationsCopier;
import software.amazon.awssdk.services.fsx.model.CreateFileCacheLustreConfiguration;
import software.amazon.awssdk.services.fsx.model.FSxRequest;
import software.amazon.awssdk.services.fsx.model.FileCacheDataRepositoryAssociation;
import software.amazon.awssdk.services.fsx.model.FileCacheType;
import software.amazon.awssdk.services.fsx.model.SecurityGroupIdsCopier;
import software.amazon.awssdk.services.fsx.model.SubnetIdsCopier;
import software.amazon.awssdk.services.fsx.model.Tag;
import software.amazon.awssdk.services.fsx.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFileCacheRequest
extends FSxRequest
implements ToCopyableBuilder<Builder, CreateFileCacheRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateFileCacheRequest.getter(CreateFileCacheRequest::clientRequestToken)).setter(CreateFileCacheRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> FILE_CACHE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileCacheType").getter(CreateFileCacheRequest.getter(CreateFileCacheRequest::fileCacheTypeAsString)).setter(CreateFileCacheRequest.setter(Builder::fileCacheType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileCacheType").build()}).build();
    private static final SdkField<String> FILE_CACHE_TYPE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileCacheTypeVersion").getter(CreateFileCacheRequest.getter(CreateFileCacheRequest::fileCacheTypeVersion)).setter(CreateFileCacheRequest.setter(Builder::fileCacheTypeVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileCacheTypeVersion").build()}).build();
    private static final SdkField<Integer> STORAGE_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StorageCapacity").getter(CreateFileCacheRequest.getter(CreateFileCacheRequest::storageCapacity)).setter(CreateFileCacheRequest.setter(Builder::storageCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageCapacity").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(CreateFileCacheRequest.getter(CreateFileCacheRequest::subnetIds)).setter(CreateFileCacheRequest.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(CreateFileCacheRequest.getter(CreateFileCacheRequest::securityGroupIds)).setter(CreateFileCacheRequest.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateFileCacheRequest.getter(CreateFileCacheRequest::tags)).setter(CreateFileCacheRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_TO_DATA_REPOSITORY_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTagsToDataRepositoryAssociations").getter(CreateFileCacheRequest.getter(CreateFileCacheRequest::copyTagsToDataRepositoryAssociations)).setter(CreateFileCacheRequest.setter(Builder::copyTagsToDataRepositoryAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToDataRepositoryAssociations").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(CreateFileCacheRequest.getter(CreateFileCacheRequest::kmsKeyId)).setter(CreateFileCacheRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<CreateFileCacheLustreConfiguration> LUSTRE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LustreConfiguration").getter(CreateFileCacheRequest.getter(CreateFileCacheRequest::lustreConfiguration)).setter(CreateFileCacheRequest.setter(Builder::lustreConfiguration)).constructor(CreateFileCacheLustreConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LustreConfiguration").build()}).build();
    private static final SdkField<List<FileCacheDataRepositoryAssociation>> DATA_REPOSITORY_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataRepositoryAssociations").getter(CreateFileCacheRequest.getter(CreateFileCacheRequest::dataRepositoryAssociations)).setter(CreateFileCacheRequest.setter(Builder::dataRepositoryAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRepositoryAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FileCacheDataRepositoryAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD, FILE_CACHE_TYPE_FIELD, FILE_CACHE_TYPE_VERSION_FIELD, STORAGE_CAPACITY_FIELD, SUBNET_IDS_FIELD, SECURITY_GROUP_IDS_FIELD, TAGS_FIELD, COPY_TAGS_TO_DATA_REPOSITORY_ASSOCIATIONS_FIELD, KMS_KEY_ID_FIELD, LUSTRE_CONFIGURATION_FIELD, DATA_REPOSITORY_ASSOCIATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateFileCacheRequest.memberNameToFieldInitializer();
    private final String clientRequestToken;
    private final String fileCacheType;
    private final String fileCacheTypeVersion;
    private final Integer storageCapacity;
    private final List<String> subnetIds;
    private final List<String> securityGroupIds;
    private final List<Tag> tags;
    private final Boolean copyTagsToDataRepositoryAssociations;
    private final String kmsKeyId;
    private final CreateFileCacheLustreConfiguration lustreConfiguration;
    private final List<FileCacheDataRepositoryAssociation> dataRepositoryAssociations;

    private CreateFileCacheRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.fileCacheType = builder.fileCacheType;
        this.fileCacheTypeVersion = builder.fileCacheTypeVersion;
        this.storageCapacity = builder.storageCapacity;
        this.subnetIds = builder.subnetIds;
        this.securityGroupIds = builder.securityGroupIds;
        this.tags = builder.tags;
        this.copyTagsToDataRepositoryAssociations = builder.copyTagsToDataRepositoryAssociations;
        this.kmsKeyId = builder.kmsKeyId;
        this.lustreConfiguration = builder.lustreConfiguration;
        this.dataRepositoryAssociations = builder.dataRepositoryAssociations;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final FileCacheType fileCacheType() {
        return FileCacheType.fromValue(this.fileCacheType);
    }

    public final String fileCacheTypeAsString() {
        return this.fileCacheType;
    }

    public final String fileCacheTypeVersion() {
        return this.fileCacheTypeVersion;
    }

    public final Integer storageCapacity() {
        return this.storageCapacity;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Boolean copyTagsToDataRepositoryAssociations() {
        return this.copyTagsToDataRepositoryAssociations;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final CreateFileCacheLustreConfiguration lustreConfiguration() {
        return this.lustreConfiguration;
    }

    public final boolean hasDataRepositoryAssociations() {
        return this.dataRepositoryAssociations != null && !(this.dataRepositoryAssociations instanceof SdkAutoConstructList);
    }

    public final List<FileCacheDataRepositoryAssociation> dataRepositoryAssociations() {
        return this.dataRepositoryAssociations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileCacheTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileCacheTypeVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsToDataRepositoryAssociations());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lustreConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataRepositoryAssociations() ? this.dataRepositoryAssociations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFileCacheRequest)) {
            return false;
        }
        CreateFileCacheRequest other = (CreateFileCacheRequest)((Object)obj);
        return Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.fileCacheTypeAsString(), other.fileCacheTypeAsString()) && Objects.equals(this.fileCacheTypeVersion(), other.fileCacheTypeVersion()) && Objects.equals(this.storageCapacity(), other.storageCapacity()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.copyTagsToDataRepositoryAssociations(), other.copyTagsToDataRepositoryAssociations()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.lustreConfiguration(), other.lustreConfiguration()) && this.hasDataRepositoryAssociations() == other.hasDataRepositoryAssociations() && Objects.equals(this.dataRepositoryAssociations(), other.dataRepositoryAssociations());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFileCacheRequest").add("ClientRequestToken", (Object)this.clientRequestToken()).add("FileCacheType", (Object)this.fileCacheTypeAsString()).add("FileCacheTypeVersion", (Object)this.fileCacheTypeVersion()).add("StorageCapacity", (Object)this.storageCapacity()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("Tags", this.hasTags() ? this.tags() : null).add("CopyTagsToDataRepositoryAssociations", (Object)this.copyTagsToDataRepositoryAssociations()).add("KmsKeyId", (Object)this.kmsKeyId()).add("LustreConfiguration", (Object)this.lustreConfiguration()).add("DataRepositoryAssociations", this.hasDataRepositoryAssociations() ? this.dataRepositoryAssociations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "FileCacheType": {
                return Optional.ofNullable(clazz.cast(this.fileCacheTypeAsString()));
            }
            case "FileCacheTypeVersion": {
                return Optional.ofNullable(clazz.cast(this.fileCacheTypeVersion()));
            }
            case "StorageCapacity": {
                return Optional.ofNullable(clazz.cast(this.storageCapacity()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "CopyTagsToDataRepositoryAssociations": {
                return Optional.ofNullable(clazz.cast(this.copyTagsToDataRepositoryAssociations()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "LustreConfiguration": {
                return Optional.ofNullable(clazz.cast(this.lustreConfiguration()));
            }
            case "DataRepositoryAssociations": {
                return Optional.ofNullable(clazz.cast(this.dataRepositoryAssociations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("FileCacheType", FILE_CACHE_TYPE_FIELD);
        map.put("FileCacheTypeVersion", FILE_CACHE_TYPE_VERSION_FIELD);
        map.put("StorageCapacity", STORAGE_CAPACITY_FIELD);
        map.put("SubnetIds", SUBNET_IDS_FIELD);
        map.put("SecurityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("CopyTagsToDataRepositoryAssociations", COPY_TAGS_TO_DATA_REPOSITORY_ASSOCIATIONS_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("LustreConfiguration", LUSTRE_CONFIGURATION_FIELD);
        map.put("DataRepositoryAssociations", DATA_REPOSITORY_ASSOCIATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFileCacheRequest, T> g) {
        return obj -> g.apply((CreateFileCacheRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxRequest.BuilderImpl
    implements Builder {
        private String clientRequestToken;
        private String fileCacheType;
        private String fileCacheTypeVersion;
        private Integer storageCapacity;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Boolean copyTagsToDataRepositoryAssociations;
        private String kmsKeyId;
        private CreateFileCacheLustreConfiguration lustreConfiguration;
        private List<FileCacheDataRepositoryAssociation> dataRepositoryAssociations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFileCacheRequest model) {
            super(model);
            this.clientRequestToken(model.clientRequestToken);
            this.fileCacheType(model.fileCacheType);
            this.fileCacheTypeVersion(model.fileCacheTypeVersion);
            this.storageCapacity(model.storageCapacity);
            this.subnetIds(model.subnetIds);
            this.securityGroupIds(model.securityGroupIds);
            this.tags(model.tags);
            this.copyTagsToDataRepositoryAssociations(model.copyTagsToDataRepositoryAssociations);
            this.kmsKeyId(model.kmsKeyId);
            this.lustreConfiguration(model.lustreConfiguration);
            this.dataRepositoryAssociations(model.dataRepositoryAssociations);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getFileCacheType() {
            return this.fileCacheType;
        }

        public final void setFileCacheType(String fileCacheType) {
            this.fileCacheType = fileCacheType;
        }

        @Override
        public final Builder fileCacheType(String fileCacheType) {
            this.fileCacheType = fileCacheType;
            return this;
        }

        @Override
        public final Builder fileCacheType(FileCacheType fileCacheType) {
            this.fileCacheType(fileCacheType == null ? null : fileCacheType.toString());
            return this;
        }

        public final String getFileCacheTypeVersion() {
            return this.fileCacheTypeVersion;
        }

        public final void setFileCacheTypeVersion(String fileCacheTypeVersion) {
            this.fileCacheTypeVersion = fileCacheTypeVersion;
        }

        @Override
        public final Builder fileCacheTypeVersion(String fileCacheTypeVersion) {
            this.fileCacheTypeVersion = fileCacheTypeVersion;
            return this;
        }

        public final Integer getStorageCapacity() {
            return this.storageCapacity;
        }

        public final void setStorageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
        }

        @Override
        public final Builder storageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getCopyTagsToDataRepositoryAssociations() {
            return this.copyTagsToDataRepositoryAssociations;
        }

        public final void setCopyTagsToDataRepositoryAssociations(Boolean copyTagsToDataRepositoryAssociations) {
            this.copyTagsToDataRepositoryAssociations = copyTagsToDataRepositoryAssociations;
        }

        @Override
        public final Builder copyTagsToDataRepositoryAssociations(Boolean copyTagsToDataRepositoryAssociations) {
            this.copyTagsToDataRepositoryAssociations = copyTagsToDataRepositoryAssociations;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final CreateFileCacheLustreConfiguration.Builder getLustreConfiguration() {
            return this.lustreConfiguration != null ? this.lustreConfiguration.toBuilder() : null;
        }

        public final void setLustreConfiguration(CreateFileCacheLustreConfiguration.BuilderImpl lustreConfiguration) {
            this.lustreConfiguration = lustreConfiguration != null ? lustreConfiguration.build() : null;
        }

        @Override
        public final Builder lustreConfiguration(CreateFileCacheLustreConfiguration lustreConfiguration) {
            this.lustreConfiguration = lustreConfiguration;
            return this;
        }

        public final List<FileCacheDataRepositoryAssociation.Builder> getDataRepositoryAssociations() {
            List<FileCacheDataRepositoryAssociation.Builder> result = CreateFileCacheDataRepositoryAssociationsCopier.copyToBuilder(this.dataRepositoryAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataRepositoryAssociations(Collection<FileCacheDataRepositoryAssociation.BuilderImpl> dataRepositoryAssociations) {
            this.dataRepositoryAssociations = CreateFileCacheDataRepositoryAssociationsCopier.copyFromBuilder(dataRepositoryAssociations);
        }

        @Override
        public final Builder dataRepositoryAssociations(Collection<FileCacheDataRepositoryAssociation> dataRepositoryAssociations) {
            this.dataRepositoryAssociations = CreateFileCacheDataRepositoryAssociationsCopier.copy(dataRepositoryAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataRepositoryAssociations(FileCacheDataRepositoryAssociation ... dataRepositoryAssociations) {
            this.dataRepositoryAssociations(Arrays.asList(dataRepositoryAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataRepositoryAssociations(Consumer<FileCacheDataRepositoryAssociation.Builder> ... dataRepositoryAssociations) {
            this.dataRepositoryAssociations(Stream.of(dataRepositoryAssociations).map(c -> (FileCacheDataRepositoryAssociation)((FileCacheDataRepositoryAssociation.Builder)FileCacheDataRepositoryAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFileCacheRequest build() {
            return new CreateFileCacheRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FSxRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFileCacheRequest> {
        public Builder clientRequestToken(String var1);

        public Builder fileCacheType(String var1);

        public Builder fileCacheType(FileCacheType var1);

        public Builder fileCacheTypeVersion(String var1);

        public Builder storageCapacity(Integer var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder copyTagsToDataRepositoryAssociations(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder lustreConfiguration(CreateFileCacheLustreConfiguration var1);

        default public Builder lustreConfiguration(Consumer<CreateFileCacheLustreConfiguration.Builder> lustreConfiguration) {
            return this.lustreConfiguration((CreateFileCacheLustreConfiguration)((CreateFileCacheLustreConfiguration.Builder)CreateFileCacheLustreConfiguration.builder().applyMutation(lustreConfiguration)).build());
        }

        public Builder dataRepositoryAssociations(Collection<FileCacheDataRepositoryAssociation> var1);

        public Builder dataRepositoryAssociations(FileCacheDataRepositoryAssociation ... var1);

        public Builder dataRepositoryAssociations(Consumer<FileCacheDataRepositoryAssociation.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

