/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.OpenZFSDataCompressionType;
import software.amazon.awssdk.services.fsx.model.OpenZFSNfsExport;
import software.amazon.awssdk.services.fsx.model.OpenZFSNfsExportsCopier;
import software.amazon.awssdk.services.fsx.model.OpenZFSUserAndGroupQuotasCopier;
import software.amazon.awssdk.services.fsx.model.OpenZFSUserOrGroupQuota;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateOpenZFSVolumeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateOpenZFSVolumeConfiguration> {
    private static final SdkField<Integer> STORAGE_CAPACITY_RESERVATION_GIB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StorageCapacityReservationGiB").getter(UpdateOpenZFSVolumeConfiguration.getter(UpdateOpenZFSVolumeConfiguration::storageCapacityReservationGiB)).setter(UpdateOpenZFSVolumeConfiguration.setter(Builder::storageCapacityReservationGiB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageCapacityReservationGiB").build()}).build();
    private static final SdkField<Integer> STORAGE_CAPACITY_QUOTA_GIB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StorageCapacityQuotaGiB").getter(UpdateOpenZFSVolumeConfiguration.getter(UpdateOpenZFSVolumeConfiguration::storageCapacityQuotaGiB)).setter(UpdateOpenZFSVolumeConfiguration.setter(Builder::storageCapacityQuotaGiB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageCapacityQuotaGiB").build()}).build();
    private static final SdkField<Integer> RECORD_SIZE_KIB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RecordSizeKiB").getter(UpdateOpenZFSVolumeConfiguration.getter(UpdateOpenZFSVolumeConfiguration::recordSizeKiB)).setter(UpdateOpenZFSVolumeConfiguration.setter(Builder::recordSizeKiB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordSizeKiB").build()}).build();
    private static final SdkField<String> DATA_COMPRESSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataCompressionType").getter(UpdateOpenZFSVolumeConfiguration.getter(UpdateOpenZFSVolumeConfiguration::dataCompressionTypeAsString)).setter(UpdateOpenZFSVolumeConfiguration.setter(Builder::dataCompressionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCompressionType").build()}).build();
    private static final SdkField<List<OpenZFSNfsExport>> NFS_EXPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NfsExports").getter(UpdateOpenZFSVolumeConfiguration.getter(UpdateOpenZFSVolumeConfiguration::nfsExports)).setter(UpdateOpenZFSVolumeConfiguration.setter(Builder::nfsExports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NfsExports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpenZFSNfsExport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<OpenZFSUserOrGroupQuota>> USER_AND_GROUP_QUOTAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserAndGroupQuotas").getter(UpdateOpenZFSVolumeConfiguration.getter(UpdateOpenZFSVolumeConfiguration::userAndGroupQuotas)).setter(UpdateOpenZFSVolumeConfiguration.setter(Builder::userAndGroupQuotas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserAndGroupQuotas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpenZFSUserOrGroupQuota::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> READ_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ReadOnly").getter(UpdateOpenZFSVolumeConfiguration.getter(UpdateOpenZFSVolumeConfiguration::readOnly)).setter(UpdateOpenZFSVolumeConfiguration.setter(Builder::readOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadOnly").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_CAPACITY_RESERVATION_GIB_FIELD, STORAGE_CAPACITY_QUOTA_GIB_FIELD, RECORD_SIZE_KIB_FIELD, DATA_COMPRESSION_TYPE_FIELD, NFS_EXPORTS_FIELD, USER_AND_GROUP_QUOTAS_FIELD, READ_ONLY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateOpenZFSVolumeConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer storageCapacityReservationGiB;
    private final Integer storageCapacityQuotaGiB;
    private final Integer recordSizeKiB;
    private final String dataCompressionType;
    private final List<OpenZFSNfsExport> nfsExports;
    private final List<OpenZFSUserOrGroupQuota> userAndGroupQuotas;
    private final Boolean readOnly;

    private UpdateOpenZFSVolumeConfiguration(BuilderImpl builder) {
        this.storageCapacityReservationGiB = builder.storageCapacityReservationGiB;
        this.storageCapacityQuotaGiB = builder.storageCapacityQuotaGiB;
        this.recordSizeKiB = builder.recordSizeKiB;
        this.dataCompressionType = builder.dataCompressionType;
        this.nfsExports = builder.nfsExports;
        this.userAndGroupQuotas = builder.userAndGroupQuotas;
        this.readOnly = builder.readOnly;
    }

    public final Integer storageCapacityReservationGiB() {
        return this.storageCapacityReservationGiB;
    }

    public final Integer storageCapacityQuotaGiB() {
        return this.storageCapacityQuotaGiB;
    }

    public final Integer recordSizeKiB() {
        return this.recordSizeKiB;
    }

    public final OpenZFSDataCompressionType dataCompressionType() {
        return OpenZFSDataCompressionType.fromValue(this.dataCompressionType);
    }

    public final String dataCompressionTypeAsString() {
        return this.dataCompressionType;
    }

    public final boolean hasNfsExports() {
        return this.nfsExports != null && !(this.nfsExports instanceof SdkAutoConstructList);
    }

    public final List<OpenZFSNfsExport> nfsExports() {
        return this.nfsExports;
    }

    public final boolean hasUserAndGroupQuotas() {
        return this.userAndGroupQuotas != null && !(this.userAndGroupQuotas instanceof SdkAutoConstructList);
    }

    public final List<OpenZFSUserOrGroupQuota> userAndGroupQuotas() {
        return this.userAndGroupQuotas;
    }

    public final Boolean readOnly() {
        return this.readOnly;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.storageCapacityReservationGiB());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageCapacityQuotaGiB());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordSizeKiB());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataCompressionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNfsExports() ? this.nfsExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserAndGroupQuotas() ? this.userAndGroupQuotas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.readOnly());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOpenZFSVolumeConfiguration)) {
            return false;
        }
        UpdateOpenZFSVolumeConfiguration other = (UpdateOpenZFSVolumeConfiguration)obj;
        return Objects.equals(this.storageCapacityReservationGiB(), other.storageCapacityReservationGiB()) && Objects.equals(this.storageCapacityQuotaGiB(), other.storageCapacityQuotaGiB()) && Objects.equals(this.recordSizeKiB(), other.recordSizeKiB()) && Objects.equals(this.dataCompressionTypeAsString(), other.dataCompressionTypeAsString()) && this.hasNfsExports() == other.hasNfsExports() && Objects.equals(this.nfsExports(), other.nfsExports()) && this.hasUserAndGroupQuotas() == other.hasUserAndGroupQuotas() && Objects.equals(this.userAndGroupQuotas(), other.userAndGroupQuotas()) && Objects.equals(this.readOnly(), other.readOnly());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateOpenZFSVolumeConfiguration").add("StorageCapacityReservationGiB", (Object)this.storageCapacityReservationGiB()).add("StorageCapacityQuotaGiB", (Object)this.storageCapacityQuotaGiB()).add("RecordSizeKiB", (Object)this.recordSizeKiB()).add("DataCompressionType", (Object)this.dataCompressionTypeAsString()).add("NfsExports", this.hasNfsExports() ? this.nfsExports() : null).add("UserAndGroupQuotas", this.hasUserAndGroupQuotas() ? this.userAndGroupQuotas() : null).add("ReadOnly", (Object)this.readOnly()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StorageCapacityReservationGiB": {
                return Optional.ofNullable(clazz.cast(this.storageCapacityReservationGiB()));
            }
            case "StorageCapacityQuotaGiB": {
                return Optional.ofNullable(clazz.cast(this.storageCapacityQuotaGiB()));
            }
            case "RecordSizeKiB": {
                return Optional.ofNullable(clazz.cast(this.recordSizeKiB()));
            }
            case "DataCompressionType": {
                return Optional.ofNullable(clazz.cast(this.dataCompressionTypeAsString()));
            }
            case "NfsExports": {
                return Optional.ofNullable(clazz.cast(this.nfsExports()));
            }
            case "UserAndGroupQuotas": {
                return Optional.ofNullable(clazz.cast(this.userAndGroupQuotas()));
            }
            case "ReadOnly": {
                return Optional.ofNullable(clazz.cast(this.readOnly()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StorageCapacityReservationGiB", STORAGE_CAPACITY_RESERVATION_GIB_FIELD);
        map.put("StorageCapacityQuotaGiB", STORAGE_CAPACITY_QUOTA_GIB_FIELD);
        map.put("RecordSizeKiB", RECORD_SIZE_KIB_FIELD);
        map.put("DataCompressionType", DATA_COMPRESSION_TYPE_FIELD);
        map.put("NfsExports", NFS_EXPORTS_FIELD);
        map.put("UserAndGroupQuotas", USER_AND_GROUP_QUOTAS_FIELD);
        map.put("ReadOnly", READ_ONLY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateOpenZFSVolumeConfiguration, T> g) {
        return obj -> g.apply((UpdateOpenZFSVolumeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer storageCapacityReservationGiB;
        private Integer storageCapacityQuotaGiB;
        private Integer recordSizeKiB;
        private String dataCompressionType;
        private List<OpenZFSNfsExport> nfsExports = DefaultSdkAutoConstructList.getInstance();
        private List<OpenZFSUserOrGroupQuota> userAndGroupQuotas = DefaultSdkAutoConstructList.getInstance();
        private Boolean readOnly;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOpenZFSVolumeConfiguration model) {
            this.storageCapacityReservationGiB(model.storageCapacityReservationGiB);
            this.storageCapacityQuotaGiB(model.storageCapacityQuotaGiB);
            this.recordSizeKiB(model.recordSizeKiB);
            this.dataCompressionType(model.dataCompressionType);
            this.nfsExports(model.nfsExports);
            this.userAndGroupQuotas(model.userAndGroupQuotas);
            this.readOnly(model.readOnly);
        }

        public final Integer getStorageCapacityReservationGiB() {
            return this.storageCapacityReservationGiB;
        }

        public final void setStorageCapacityReservationGiB(Integer storageCapacityReservationGiB) {
            this.storageCapacityReservationGiB = storageCapacityReservationGiB;
        }

        @Override
        public final Builder storageCapacityReservationGiB(Integer storageCapacityReservationGiB) {
            this.storageCapacityReservationGiB = storageCapacityReservationGiB;
            return this;
        }

        public final Integer getStorageCapacityQuotaGiB() {
            return this.storageCapacityQuotaGiB;
        }

        public final void setStorageCapacityQuotaGiB(Integer storageCapacityQuotaGiB) {
            this.storageCapacityQuotaGiB = storageCapacityQuotaGiB;
        }

        @Override
        public final Builder storageCapacityQuotaGiB(Integer storageCapacityQuotaGiB) {
            this.storageCapacityQuotaGiB = storageCapacityQuotaGiB;
            return this;
        }

        public final Integer getRecordSizeKiB() {
            return this.recordSizeKiB;
        }

        public final void setRecordSizeKiB(Integer recordSizeKiB) {
            this.recordSizeKiB = recordSizeKiB;
        }

        @Override
        public final Builder recordSizeKiB(Integer recordSizeKiB) {
            this.recordSizeKiB = recordSizeKiB;
            return this;
        }

        public final String getDataCompressionType() {
            return this.dataCompressionType;
        }

        public final void setDataCompressionType(String dataCompressionType) {
            this.dataCompressionType = dataCompressionType;
        }

        @Override
        public final Builder dataCompressionType(String dataCompressionType) {
            this.dataCompressionType = dataCompressionType;
            return this;
        }

        @Override
        public final Builder dataCompressionType(OpenZFSDataCompressionType dataCompressionType) {
            this.dataCompressionType(dataCompressionType == null ? null : dataCompressionType.toString());
            return this;
        }

        public final List<OpenZFSNfsExport.Builder> getNfsExports() {
            List<OpenZFSNfsExport.Builder> result = OpenZFSNfsExportsCopier.copyToBuilder(this.nfsExports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNfsExports(Collection<OpenZFSNfsExport.BuilderImpl> nfsExports) {
            this.nfsExports = OpenZFSNfsExportsCopier.copyFromBuilder(nfsExports);
        }

        @Override
        public final Builder nfsExports(Collection<OpenZFSNfsExport> nfsExports) {
            this.nfsExports = OpenZFSNfsExportsCopier.copy(nfsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nfsExports(OpenZFSNfsExport ... nfsExports) {
            this.nfsExports(Arrays.asList(nfsExports));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nfsExports(Consumer<OpenZFSNfsExport.Builder> ... nfsExports) {
            this.nfsExports(Stream.of(nfsExports).map(c -> (OpenZFSNfsExport)((OpenZFSNfsExport.Builder)OpenZFSNfsExport.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<OpenZFSUserOrGroupQuota.Builder> getUserAndGroupQuotas() {
            List<OpenZFSUserOrGroupQuota.Builder> result = OpenZFSUserAndGroupQuotasCopier.copyToBuilder(this.userAndGroupQuotas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserAndGroupQuotas(Collection<OpenZFSUserOrGroupQuota.BuilderImpl> userAndGroupQuotas) {
            this.userAndGroupQuotas = OpenZFSUserAndGroupQuotasCopier.copyFromBuilder(userAndGroupQuotas);
        }

        @Override
        public final Builder userAndGroupQuotas(Collection<OpenZFSUserOrGroupQuota> userAndGroupQuotas) {
            this.userAndGroupQuotas = OpenZFSUserAndGroupQuotasCopier.copy(userAndGroupQuotas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAndGroupQuotas(OpenZFSUserOrGroupQuota ... userAndGroupQuotas) {
            this.userAndGroupQuotas(Arrays.asList(userAndGroupQuotas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAndGroupQuotas(Consumer<OpenZFSUserOrGroupQuota.Builder> ... userAndGroupQuotas) {
            this.userAndGroupQuotas(Stream.of(userAndGroupQuotas).map(c -> (OpenZFSUserOrGroupQuota)((OpenZFSUserOrGroupQuota.Builder)OpenZFSUserOrGroupQuota.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getReadOnly() {
            return this.readOnly;
        }

        public final void setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
        }

        @Override
        public final Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public UpdateOpenZFSVolumeConfiguration build() {
            return new UpdateOpenZFSVolumeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateOpenZFSVolumeConfiguration> {
        public Builder storageCapacityReservationGiB(Integer var1);

        public Builder storageCapacityQuotaGiB(Integer var1);

        public Builder recordSizeKiB(Integer var1);

        public Builder dataCompressionType(String var1);

        public Builder dataCompressionType(OpenZFSDataCompressionType var1);

        public Builder nfsExports(Collection<OpenZFSNfsExport> var1);

        public Builder nfsExports(OpenZFSNfsExport ... var1);

        public Builder nfsExports(Consumer<OpenZFSNfsExport.Builder> ... var1);

        public Builder userAndGroupQuotas(Collection<OpenZFSUserOrGroupQuota> var1);

        public Builder userAndGroupQuotas(OpenZFSUserOrGroupQuota ... var1);

        public Builder userAndGroupQuotas(Consumer<OpenZFSUserOrGroupQuota.Builder> ... var1);

        public Builder readOnly(Boolean var1);
    }
}

