/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.LifecycleTransitionReason;
import software.amazon.awssdk.services.fsx.model.StorageVirtualMachineLifecycle;
import software.amazon.awssdk.services.fsx.model.StorageVirtualMachineRootVolumeSecurityStyle;
import software.amazon.awssdk.services.fsx.model.StorageVirtualMachineSubtype;
import software.amazon.awssdk.services.fsx.model.SvmActiveDirectoryConfiguration;
import software.amazon.awssdk.services.fsx.model.SvmEndpoints;
import software.amazon.awssdk.services.fsx.model.Tag;
import software.amazon.awssdk.services.fsx.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StorageVirtualMachine
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StorageVirtualMachine> {
    private static final SdkField<SvmActiveDirectoryConfiguration> ACTIVE_DIRECTORY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ActiveDirectoryConfiguration").getter(StorageVirtualMachine.getter(StorageVirtualMachine::activeDirectoryConfiguration)).setter(StorageVirtualMachine.setter(Builder::activeDirectoryConfiguration)).constructor(SvmActiveDirectoryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectoryConfiguration").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(StorageVirtualMachine.getter(StorageVirtualMachine::creationTime)).setter(StorageVirtualMachine.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<SvmEndpoints> ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Endpoints").getter(StorageVirtualMachine.getter(StorageVirtualMachine::endpoints)).setter(StorageVirtualMachine.setter(Builder::endpoints)).constructor(SvmEndpoints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoints").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemId").getter(StorageVirtualMachine.getter(StorageVirtualMachine::fileSystemId)).setter(StorageVirtualMachine.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()}).build();
    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Lifecycle").getter(StorageVirtualMachine.getter(StorageVirtualMachine::lifecycleAsString)).setter(StorageVirtualMachine.setter(Builder::lifecycle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(StorageVirtualMachine.getter(StorageVirtualMachine::name)).setter(StorageVirtualMachine.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceARN").getter(StorageVirtualMachine.getter(StorageVirtualMachine::resourceARN)).setter(StorageVirtualMachine.setter(Builder::resourceARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceARN").build()}).build();
    private static final SdkField<String> STORAGE_VIRTUAL_MACHINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageVirtualMachineId").getter(StorageVirtualMachine.getter(StorageVirtualMachine::storageVirtualMachineId)).setter(StorageVirtualMachine.setter(Builder::storageVirtualMachineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageVirtualMachineId").build()}).build();
    private static final SdkField<String> SUBTYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subtype").getter(StorageVirtualMachine.getter(StorageVirtualMachine::subtypeAsString)).setter(StorageVirtualMachine.setter(Builder::subtype)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subtype").build()}).build();
    private static final SdkField<String> UUID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UUID").getter(StorageVirtualMachine.getter(StorageVirtualMachine::uuid)).setter(StorageVirtualMachine.setter(Builder::uuid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UUID").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(StorageVirtualMachine.getter(StorageVirtualMachine::tags)).setter(StorageVirtualMachine.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<LifecycleTransitionReason> LIFECYCLE_TRANSITION_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LifecycleTransitionReason").getter(StorageVirtualMachine.getter(StorageVirtualMachine::lifecycleTransitionReason)).setter(StorageVirtualMachine.setter(Builder::lifecycleTransitionReason)).constructor(LifecycleTransitionReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleTransitionReason").build()}).build();
    private static final SdkField<String> ROOT_VOLUME_SECURITY_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RootVolumeSecurityStyle").getter(StorageVirtualMachine.getter(StorageVirtualMachine::rootVolumeSecurityStyleAsString)).setter(StorageVirtualMachine.setter(Builder::rootVolumeSecurityStyle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootVolumeSecurityStyle").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_DIRECTORY_CONFIGURATION_FIELD, CREATION_TIME_FIELD, ENDPOINTS_FIELD, FILE_SYSTEM_ID_FIELD, LIFECYCLE_FIELD, NAME_FIELD, RESOURCE_ARN_FIELD, STORAGE_VIRTUAL_MACHINE_ID_FIELD, SUBTYPE_FIELD, UUID_FIELD, TAGS_FIELD, LIFECYCLE_TRANSITION_REASON_FIELD, ROOT_VOLUME_SECURITY_STYLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StorageVirtualMachine.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SvmActiveDirectoryConfiguration activeDirectoryConfiguration;
    private final Instant creationTime;
    private final SvmEndpoints endpoints;
    private final String fileSystemId;
    private final String lifecycle;
    private final String name;
    private final String resourceARN;
    private final String storageVirtualMachineId;
    private final String subtype;
    private final String uuid;
    private final List<Tag> tags;
    private final LifecycleTransitionReason lifecycleTransitionReason;
    private final String rootVolumeSecurityStyle;

    private StorageVirtualMachine(BuilderImpl builder) {
        this.activeDirectoryConfiguration = builder.activeDirectoryConfiguration;
        this.creationTime = builder.creationTime;
        this.endpoints = builder.endpoints;
        this.fileSystemId = builder.fileSystemId;
        this.lifecycle = builder.lifecycle;
        this.name = builder.name;
        this.resourceARN = builder.resourceARN;
        this.storageVirtualMachineId = builder.storageVirtualMachineId;
        this.subtype = builder.subtype;
        this.uuid = builder.uuid;
        this.tags = builder.tags;
        this.lifecycleTransitionReason = builder.lifecycleTransitionReason;
        this.rootVolumeSecurityStyle = builder.rootVolumeSecurityStyle;
    }

    public final SvmActiveDirectoryConfiguration activeDirectoryConfiguration() {
        return this.activeDirectoryConfiguration;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final SvmEndpoints endpoints() {
        return this.endpoints;
    }

    public final String fileSystemId() {
        return this.fileSystemId;
    }

    public final StorageVirtualMachineLifecycle lifecycle() {
        return StorageVirtualMachineLifecycle.fromValue(this.lifecycle);
    }

    public final String lifecycleAsString() {
        return this.lifecycle;
    }

    public final String name() {
        return this.name;
    }

    public final String resourceARN() {
        return this.resourceARN;
    }

    public final String storageVirtualMachineId() {
        return this.storageVirtualMachineId;
    }

    public final StorageVirtualMachineSubtype subtype() {
        return StorageVirtualMachineSubtype.fromValue(this.subtype);
    }

    public final String subtypeAsString() {
        return this.subtype;
    }

    public final String uuid() {
        return this.uuid;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final LifecycleTransitionReason lifecycleTransitionReason() {
        return this.lifecycleTransitionReason;
    }

    public final StorageVirtualMachineRootVolumeSecurityStyle rootVolumeSecurityStyle() {
        return StorageVirtualMachineRootVolumeSecurityStyle.fromValue(this.rootVolumeSecurityStyle);
    }

    public final String rootVolumeSecurityStyleAsString() {
        return this.rootVolumeSecurityStyle;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activeDirectoryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoints());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageVirtualMachineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subtypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.uuid());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleTransitionReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootVolumeSecurityStyleAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageVirtualMachine)) {
            return false;
        }
        StorageVirtualMachine other = (StorageVirtualMachine)obj;
        return Objects.equals(this.activeDirectoryConfiguration(), other.activeDirectoryConfiguration()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.endpoints(), other.endpoints()) && Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.lifecycleAsString(), other.lifecycleAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.resourceARN(), other.resourceARN()) && Objects.equals(this.storageVirtualMachineId(), other.storageVirtualMachineId()) && Objects.equals(this.subtypeAsString(), other.subtypeAsString()) && Objects.equals(this.uuid(), other.uuid()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.lifecycleTransitionReason(), other.lifecycleTransitionReason()) && Objects.equals(this.rootVolumeSecurityStyleAsString(), other.rootVolumeSecurityStyleAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StorageVirtualMachine").add("ActiveDirectoryConfiguration", (Object)this.activeDirectoryConfiguration()).add("CreationTime", (Object)this.creationTime()).add("Endpoints", (Object)this.endpoints()).add("FileSystemId", (Object)this.fileSystemId()).add("Lifecycle", (Object)this.lifecycleAsString()).add("Name", (Object)this.name()).add("ResourceARN", (Object)this.resourceARN()).add("StorageVirtualMachineId", (Object)this.storageVirtualMachineId()).add("Subtype", (Object)this.subtypeAsString()).add("UUID", (Object)this.uuid()).add("Tags", this.hasTags() ? this.tags() : null).add("LifecycleTransitionReason", (Object)this.lifecycleTransitionReason()).add("RootVolumeSecurityStyle", (Object)this.rootVolumeSecurityStyleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActiveDirectoryConfiguration": {
                return Optional.ofNullable(clazz.cast(this.activeDirectoryConfiguration()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Endpoints": {
                return Optional.ofNullable(clazz.cast(this.endpoints()));
            }
            case "FileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "Lifecycle": {
                return Optional.ofNullable(clazz.cast(this.lifecycleAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ResourceARN": {
                return Optional.ofNullable(clazz.cast(this.resourceARN()));
            }
            case "StorageVirtualMachineId": {
                return Optional.ofNullable(clazz.cast(this.storageVirtualMachineId()));
            }
            case "Subtype": {
                return Optional.ofNullable(clazz.cast(this.subtypeAsString()));
            }
            case "UUID": {
                return Optional.ofNullable(clazz.cast(this.uuid()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "LifecycleTransitionReason": {
                return Optional.ofNullable(clazz.cast(this.lifecycleTransitionReason()));
            }
            case "RootVolumeSecurityStyle": {
                return Optional.ofNullable(clazz.cast(this.rootVolumeSecurityStyleAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ActiveDirectoryConfiguration", ACTIVE_DIRECTORY_CONFIGURATION_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("Endpoints", ENDPOINTS_FIELD);
        map.put("FileSystemId", FILE_SYSTEM_ID_FIELD);
        map.put("Lifecycle", LIFECYCLE_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ResourceARN", RESOURCE_ARN_FIELD);
        map.put("StorageVirtualMachineId", STORAGE_VIRTUAL_MACHINE_ID_FIELD);
        map.put("Subtype", SUBTYPE_FIELD);
        map.put("UUID", UUID_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("LifecycleTransitionReason", LIFECYCLE_TRANSITION_REASON_FIELD);
        map.put("RootVolumeSecurityStyle", ROOT_VOLUME_SECURITY_STYLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StorageVirtualMachine, T> g) {
        return obj -> g.apply((StorageVirtualMachine)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SvmActiveDirectoryConfiguration activeDirectoryConfiguration;
        private Instant creationTime;
        private SvmEndpoints endpoints;
        private String fileSystemId;
        private String lifecycle;
        private String name;
        private String resourceARN;
        private String storageVirtualMachineId;
        private String subtype;
        private String uuid;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private LifecycleTransitionReason lifecycleTransitionReason;
        private String rootVolumeSecurityStyle;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageVirtualMachine model) {
            this.activeDirectoryConfiguration(model.activeDirectoryConfiguration);
            this.creationTime(model.creationTime);
            this.endpoints(model.endpoints);
            this.fileSystemId(model.fileSystemId);
            this.lifecycle(model.lifecycle);
            this.name(model.name);
            this.resourceARN(model.resourceARN);
            this.storageVirtualMachineId(model.storageVirtualMachineId);
            this.subtype(model.subtype);
            this.uuid(model.uuid);
            this.tags(model.tags);
            this.lifecycleTransitionReason(model.lifecycleTransitionReason);
            this.rootVolumeSecurityStyle(model.rootVolumeSecurityStyle);
        }

        public final SvmActiveDirectoryConfiguration.Builder getActiveDirectoryConfiguration() {
            return this.activeDirectoryConfiguration != null ? this.activeDirectoryConfiguration.toBuilder() : null;
        }

        public final void setActiveDirectoryConfiguration(SvmActiveDirectoryConfiguration.BuilderImpl activeDirectoryConfiguration) {
            this.activeDirectoryConfiguration = activeDirectoryConfiguration != null ? activeDirectoryConfiguration.build() : null;
        }

        @Override
        public final Builder activeDirectoryConfiguration(SvmActiveDirectoryConfiguration activeDirectoryConfiguration) {
            this.activeDirectoryConfiguration = activeDirectoryConfiguration;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final SvmEndpoints.Builder getEndpoints() {
            return this.endpoints != null ? this.endpoints.toBuilder() : null;
        }

        public final void setEndpoints(SvmEndpoints.BuilderImpl endpoints) {
            this.endpoints = endpoints != null ? endpoints.build() : null;
        }

        @Override
        public final Builder endpoints(SvmEndpoints endpoints) {
            this.endpoints = endpoints;
            return this;
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final String getLifecycle() {
            return this.lifecycle;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(StorageVirtualMachineLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getResourceARN() {
            return this.resourceARN;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final String getStorageVirtualMachineId() {
            return this.storageVirtualMachineId;
        }

        public final void setStorageVirtualMachineId(String storageVirtualMachineId) {
            this.storageVirtualMachineId = storageVirtualMachineId;
        }

        @Override
        public final Builder storageVirtualMachineId(String storageVirtualMachineId) {
            this.storageVirtualMachineId = storageVirtualMachineId;
            return this;
        }

        public final String getSubtype() {
            return this.subtype;
        }

        public final void setSubtype(String subtype) {
            this.subtype = subtype;
        }

        @Override
        public final Builder subtype(String subtype) {
            this.subtype = subtype;
            return this;
        }

        @Override
        public final Builder subtype(StorageVirtualMachineSubtype subtype) {
            this.subtype(subtype == null ? null : subtype.toString());
            return this;
        }

        public final String getUuid() {
            return this.uuid;
        }

        public final void setUuid(String uuid) {
            this.uuid = uuid;
        }

        @Override
        public final Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final LifecycleTransitionReason.Builder getLifecycleTransitionReason() {
            return this.lifecycleTransitionReason != null ? this.lifecycleTransitionReason.toBuilder() : null;
        }

        public final void setLifecycleTransitionReason(LifecycleTransitionReason.BuilderImpl lifecycleTransitionReason) {
            this.lifecycleTransitionReason = lifecycleTransitionReason != null ? lifecycleTransitionReason.build() : null;
        }

        @Override
        public final Builder lifecycleTransitionReason(LifecycleTransitionReason lifecycleTransitionReason) {
            this.lifecycleTransitionReason = lifecycleTransitionReason;
            return this;
        }

        public final String getRootVolumeSecurityStyle() {
            return this.rootVolumeSecurityStyle;
        }

        public final void setRootVolumeSecurityStyle(String rootVolumeSecurityStyle) {
            this.rootVolumeSecurityStyle = rootVolumeSecurityStyle;
        }

        @Override
        public final Builder rootVolumeSecurityStyle(String rootVolumeSecurityStyle) {
            this.rootVolumeSecurityStyle = rootVolumeSecurityStyle;
            return this;
        }

        @Override
        public final Builder rootVolumeSecurityStyle(StorageVirtualMachineRootVolumeSecurityStyle rootVolumeSecurityStyle) {
            this.rootVolumeSecurityStyle(rootVolumeSecurityStyle == null ? null : rootVolumeSecurityStyle.toString());
            return this;
        }

        public StorageVirtualMachine build() {
            return new StorageVirtualMachine(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StorageVirtualMachine> {
        public Builder activeDirectoryConfiguration(SvmActiveDirectoryConfiguration var1);

        default public Builder activeDirectoryConfiguration(Consumer<SvmActiveDirectoryConfiguration.Builder> activeDirectoryConfiguration) {
            return this.activeDirectoryConfiguration((SvmActiveDirectoryConfiguration)((SvmActiveDirectoryConfiguration.Builder)SvmActiveDirectoryConfiguration.builder().applyMutation(activeDirectoryConfiguration)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder endpoints(SvmEndpoints var1);

        default public Builder endpoints(Consumer<SvmEndpoints.Builder> endpoints) {
            return this.endpoints((SvmEndpoints)((SvmEndpoints.Builder)SvmEndpoints.builder().applyMutation(endpoints)).build());
        }

        public Builder fileSystemId(String var1);

        public Builder lifecycle(String var1);

        public Builder lifecycle(StorageVirtualMachineLifecycle var1);

        public Builder name(String var1);

        public Builder resourceARN(String var1);

        public Builder storageVirtualMachineId(String var1);

        public Builder subtype(String var1);

        public Builder subtype(StorageVirtualMachineSubtype var1);

        public Builder uuid(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder lifecycleTransitionReason(LifecycleTransitionReason var1);

        default public Builder lifecycleTransitionReason(Consumer<LifecycleTransitionReason.Builder> lifecycleTransitionReason) {
            return this.lifecycleTransitionReason((LifecycleTransitionReason)((LifecycleTransitionReason.Builder)LifecycleTransitionReason.builder().applyMutation(lifecycleTransitionReason)).build());
        }

        public Builder rootVolumeSecurityStyle(String var1);

        public Builder rootVolumeSecurityStyle(StorageVirtualMachineRootVolumeSecurityStyle var1);
    }
}

