/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.Backup;
import software.amazon.awssdk.services.fsx.model.FSxResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBackupResponse
extends FSxResponse
implements ToCopyableBuilder<Builder, CreateBackupResponse> {
    private static final SdkField<Backup> BACKUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateBackupResponse.getter(CreateBackupResponse::backup)).setter(CreateBackupResponse.setter(Builder::backup)).constructor(Backup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Backup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_FIELD));
    private final Backup backup;

    private CreateBackupResponse(BuilderImpl builder) {
        super(builder);
        this.backup = builder.backup;
    }

    public Backup backup() {
        return this.backup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backup());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBackupResponse)) {
            return false;
        }
        CreateBackupResponse other = (CreateBackupResponse)((Object)obj);
        return Objects.equals(this.backup(), other.backup());
    }

    public String toString() {
        return ToString.builder((String)"CreateBackupResponse").add("Backup", (Object)this.backup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Backup": {
                return Optional.ofNullable(clazz.cast(this.backup()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBackupResponse, T> g) {
        return obj -> g.apply((CreateBackupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxResponse.BuilderImpl
    implements Builder {
        private Backup backup;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBackupResponse model) {
            super(model);
            this.backup(model.backup);
        }

        public final Backup.Builder getBackup() {
            return this.backup != null ? this.backup.toBuilder() : null;
        }

        @Override
        public final Builder backup(Backup backup) {
            this.backup = backup;
            return this;
        }

        public final void setBackup(Backup.BuilderImpl backup) {
            this.backup = backup != null ? backup.build() : null;
        }

        @Override
        public CreateBackupResponse build() {
            return new CreateBackupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FSxResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBackupResponse> {
        public Builder backup(Backup var1);

        default public Builder backup(Consumer<Backup.Builder> backup) {
            return this.backup((Backup)((Backup.Builder)Backup.builder().applyMutation(backup)).build());
        }
    }
}

