/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.FSxResponse;
import software.amazon.awssdk.services.fsx.model.StorageVirtualMachineLifecycle;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteStorageVirtualMachineResponse
extends FSxResponse
implements ToCopyableBuilder<Builder, DeleteStorageVirtualMachineResponse> {
    private static final SdkField<String> STORAGE_VIRTUAL_MACHINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageVirtualMachineId").getter(DeleteStorageVirtualMachineResponse.getter(DeleteStorageVirtualMachineResponse::storageVirtualMachineId)).setter(DeleteStorageVirtualMachineResponse.setter(Builder::storageVirtualMachineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageVirtualMachineId").build()}).build();
    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Lifecycle").getter(DeleteStorageVirtualMachineResponse.getter(DeleteStorageVirtualMachineResponse::lifecycleAsString)).setter(DeleteStorageVirtualMachineResponse.setter(Builder::lifecycle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_VIRTUAL_MACHINE_ID_FIELD, LIFECYCLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteStorageVirtualMachineResponse.memberNameToFieldInitializer();
    private final String storageVirtualMachineId;
    private final String lifecycle;

    private DeleteStorageVirtualMachineResponse(BuilderImpl builder) {
        super(builder);
        this.storageVirtualMachineId = builder.storageVirtualMachineId;
        this.lifecycle = builder.lifecycle;
    }

    public final String storageVirtualMachineId() {
        return this.storageVirtualMachineId;
    }

    public final StorageVirtualMachineLifecycle lifecycle() {
        return StorageVirtualMachineLifecycle.fromValue(this.lifecycle);
    }

    public final String lifecycleAsString() {
        return this.lifecycle;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.storageVirtualMachineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteStorageVirtualMachineResponse)) {
            return false;
        }
        DeleteStorageVirtualMachineResponse other = (DeleteStorageVirtualMachineResponse)((Object)obj);
        return Objects.equals(this.storageVirtualMachineId(), other.storageVirtualMachineId()) && Objects.equals(this.lifecycleAsString(), other.lifecycleAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteStorageVirtualMachineResponse").add("StorageVirtualMachineId", (Object)this.storageVirtualMachineId()).add("Lifecycle", (Object)this.lifecycleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StorageVirtualMachineId": {
                return Optional.ofNullable(clazz.cast(this.storageVirtualMachineId()));
            }
            case "Lifecycle": {
                return Optional.ofNullable(clazz.cast(this.lifecycleAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("StorageVirtualMachineId", STORAGE_VIRTUAL_MACHINE_ID_FIELD);
        map.put("Lifecycle", LIFECYCLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteStorageVirtualMachineResponse, T> g) {
        return obj -> g.apply((DeleteStorageVirtualMachineResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxResponse.BuilderImpl
    implements Builder {
        private String storageVirtualMachineId;
        private String lifecycle;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteStorageVirtualMachineResponse model) {
            super(model);
            this.storageVirtualMachineId(model.storageVirtualMachineId);
            this.lifecycle(model.lifecycle);
        }

        public final String getStorageVirtualMachineId() {
            return this.storageVirtualMachineId;
        }

        public final void setStorageVirtualMachineId(String storageVirtualMachineId) {
            this.storageVirtualMachineId = storageVirtualMachineId;
        }

        @Override
        public final Builder storageVirtualMachineId(String storageVirtualMachineId) {
            this.storageVirtualMachineId = storageVirtualMachineId;
            return this;
        }

        public final String getLifecycle() {
            return this.lifecycle;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(StorageVirtualMachineLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        @Override
        public DeleteStorageVirtualMachineResponse build() {
            return new DeleteStorageVirtualMachineResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FSxResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteStorageVirtualMachineResponse> {
        public Builder storageVirtualMachineId(String var1);

        public Builder lifecycle(String var1);

        public Builder lifecycle(StorageVirtualMachineLifecycle var1);
    }
}

