/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.MetadataConfigurationMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FileSystemLustreMetadataConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FileSystemLustreMetadataConfiguration> {
    private static final SdkField<Integer> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Iops").getter(FileSystemLustreMetadataConfiguration.getter(FileSystemLustreMetadataConfiguration::iops)).setter(FileSystemLustreMetadataConfiguration.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(FileSystemLustreMetadataConfiguration.getter(FileSystemLustreMetadataConfiguration::modeAsString)).setter(FileSystemLustreMetadataConfiguration.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IOPS_FIELD, MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer iops;
    private final String mode;

    private FileSystemLustreMetadataConfiguration(BuilderImpl builder) {
        this.iops = builder.iops;
        this.mode = builder.mode;
    }

    public final Integer iops() {
        return this.iops;
    }

    public final MetadataConfigurationMode mode() {
        return MetadataConfigurationMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileSystemLustreMetadataConfiguration)) {
            return false;
        }
        FileSystemLustreMetadataConfiguration other = (FileSystemLustreMetadataConfiguration)obj;
        return Objects.equals(this.iops(), other.iops()) && Objects.equals(this.modeAsString(), other.modeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FileSystemLustreMetadataConfiguration").add("Iops", (Object)this.iops()).add("Mode", (Object)this.modeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FileSystemLustreMetadataConfiguration, T> g) {
        return obj -> g.apply((FileSystemLustreMetadataConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer iops;
        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(FileSystemLustreMetadataConfiguration model) {
            this.iops(model.iops);
            this.mode(model.mode);
        }

        public final Integer getIops() {
            return this.iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(MetadataConfigurationMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public FileSystemLustreMetadataConfiguration build() {
            return new FileSystemLustreMetadataConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FileSystemLustreMetadataConfiguration> {
        public Builder iops(Integer var1);

        public Builder mode(String var1);

        public Builder mode(MetadataConfigurationMode var1);
    }
}

