/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataRepositoryTaskLifecycle {
    PENDING("PENDING"),
    EXECUTING("EXECUTING"),
    FAILED("FAILED"),
    SUCCEEDED("SUCCEEDED"),
    CANCELED("CANCELED"),
    CANCELING("CANCELING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataRepositoryTaskLifecycle> VALUE_MAP;
    private final String value;

    private DataRepositoryTaskLifecycle(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataRepositoryTaskLifecycle fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataRepositoryTaskLifecycle> knownValues() {
        EnumSet<DataRepositoryTaskLifecycle> knownValues = EnumSet.allOf(DataRepositoryTaskLifecycle.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataRepositoryTaskLifecycle.class, DataRepositoryTaskLifecycle::toString);
    }
}

