/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.FSxRequest;
import software.amazon.awssdk.services.fsx.model.SnapshotFilter;
import software.amazon.awssdk.services.fsx.model.SnapshotFiltersCopier;
import software.amazon.awssdk.services.fsx.model.SnapshotIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSnapshotsRequest
extends FSxRequest
implements ToCopyableBuilder<Builder, DescribeSnapshotsRequest> {
    private static final SdkField<List<String>> SNAPSHOT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SnapshotIds").getter(DescribeSnapshotsRequest.getter(DescribeSnapshotsRequest::snapshotIds)).setter(DescribeSnapshotsRequest.setter(Builder::snapshotIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SnapshotFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeSnapshotsRequest.getter(DescribeSnapshotsRequest::filters)).setter(DescribeSnapshotsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SnapshotFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeSnapshotsRequest.getter(DescribeSnapshotsRequest::maxResults)).setter(DescribeSnapshotsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeSnapshotsRequest.getter(DescribeSnapshotsRequest::nextToken)).setter(DescribeSnapshotsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Boolean> INCLUDE_SHARED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeShared").getter(DescribeSnapshotsRequest.getter(DescribeSnapshotsRequest::includeShared)).setter(DescribeSnapshotsRequest.setter(Builder::includeShared)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeShared").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_IDS_FIELD, FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, INCLUDE_SHARED_FIELD));
    private final List<String> snapshotIds;
    private final List<SnapshotFilter> filters;
    private final Integer maxResults;
    private final String nextToken;
    private final Boolean includeShared;

    private DescribeSnapshotsRequest(BuilderImpl builder) {
        super(builder);
        this.snapshotIds = builder.snapshotIds;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.includeShared = builder.includeShared;
    }

    public final boolean hasSnapshotIds() {
        return this.snapshotIds != null && !(this.snapshotIds instanceof SdkAutoConstructList);
    }

    public final List<String> snapshotIds() {
        return this.snapshotIds;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<SnapshotFilter> filters() {
        return this.filters;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Boolean includeShared() {
        return this.includeShared;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSnapshotIds() ? this.snapshotIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeShared());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotsRequest)) {
            return false;
        }
        DescribeSnapshotsRequest other = (DescribeSnapshotsRequest)((Object)obj);
        return this.hasSnapshotIds() == other.hasSnapshotIds() && Objects.equals(this.snapshotIds(), other.snapshotIds()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.includeShared(), other.includeShared());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSnapshotsRequest").add("SnapshotIds", this.hasSnapshotIds() ? this.snapshotIds() : null).add("Filters", this.hasFilters() ? this.filters() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("IncludeShared", (Object)this.includeShared()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotIds": {
                return Optional.ofNullable(clazz.cast(this.snapshotIds()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "IncludeShared": {
                return Optional.ofNullable(clazz.cast(this.includeShared()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSnapshotsRequest, T> g) {
        return obj -> g.apply((DescribeSnapshotsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxRequest.BuilderImpl
    implements Builder {
        private List<String> snapshotIds = DefaultSdkAutoConstructList.getInstance();
        private List<SnapshotFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;
        private Boolean includeShared;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotsRequest model) {
            super(model);
            this.snapshotIds(model.snapshotIds);
            this.filters(model.filters);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.includeShared(model.includeShared);
        }

        public final Collection<String> getSnapshotIds() {
            if (this.snapshotIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.snapshotIds;
        }

        public final void setSnapshotIds(Collection<String> snapshotIds) {
            this.snapshotIds = SnapshotIdsCopier.copy(snapshotIds);
        }

        @Override
        public final Builder snapshotIds(Collection<String> snapshotIds) {
            this.snapshotIds = SnapshotIdsCopier.copy(snapshotIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotIds(String ... snapshotIds) {
            this.snapshotIds(Arrays.asList(snapshotIds));
            return this;
        }

        public final List<SnapshotFilter.Builder> getFilters() {
            List<SnapshotFilter.Builder> result = SnapshotFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<SnapshotFilter.BuilderImpl> filters) {
            this.filters = SnapshotFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<SnapshotFilter> filters) {
            this.filters = SnapshotFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(SnapshotFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<SnapshotFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (SnapshotFilter)((SnapshotFilter.Builder)SnapshotFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Boolean getIncludeShared() {
            return this.includeShared;
        }

        public final void setIncludeShared(Boolean includeShared) {
            this.includeShared = includeShared;
        }

        @Override
        public final Builder includeShared(Boolean includeShared) {
            this.includeShared = includeShared;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSnapshotsRequest build() {
            return new DescribeSnapshotsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FSxRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSnapshotsRequest> {
        public Builder snapshotIds(Collection<String> var1);

        public Builder snapshotIds(String ... var1);

        public Builder filters(Collection<SnapshotFilter> var1);

        public Builder filters(SnapshotFilter ... var1);

        public Builder filters(Consumer<SnapshotFilter.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder includeShared(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

