/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.ActiveDirectoryErrorType;
import software.amazon.awssdk.services.fsx.model.FSxException;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActiveDirectoryErrorException
extends FSxException
implements ToCopyableBuilder<Builder, ActiveDirectoryErrorException> {
    private static final SdkField<String> ACTIVE_DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActiveDirectoryId").getter(ActiveDirectoryErrorException.getter(ActiveDirectoryErrorException::activeDirectoryId)).setter(ActiveDirectoryErrorException.setter(Builder::activeDirectoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectoryId").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ActiveDirectoryErrorException.getter(ActiveDirectoryErrorException::typeAsString)).setter(ActiveDirectoryErrorException.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_DIRECTORY_ID_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String activeDirectoryId;
    private final String type;

    private ActiveDirectoryErrorException(BuilderImpl builder) {
        super(builder);
        this.activeDirectoryId = builder.activeDirectoryId;
        this.type = builder.type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public String activeDirectoryId() {
        return this.activeDirectoryId;
    }

    public ActiveDirectoryErrorType type() {
        return ActiveDirectoryErrorType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActiveDirectoryErrorException, T> g) {
        return obj -> g.apply((ActiveDirectoryErrorException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxException.BuilderImpl
    implements Builder {
        private String activeDirectoryId;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ActiveDirectoryErrorException model) {
            super(model);
            this.activeDirectoryId(model.activeDirectoryId);
            this.type(model.type);
        }

        public final String getActiveDirectoryId() {
            return this.activeDirectoryId;
        }

        public final void setActiveDirectoryId(String activeDirectoryId) {
            this.activeDirectoryId = activeDirectoryId;
        }

        @Override
        public final Builder activeDirectoryId(String activeDirectoryId) {
            this.activeDirectoryId = activeDirectoryId;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ActiveDirectoryErrorType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public ActiveDirectoryErrorException build() {
            return new ActiveDirectoryErrorException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActiveDirectoryErrorException>,
    FSxException.Builder {
        public Builder activeDirectoryId(String var1);

        public Builder type(String var1);

        public Builder type(ActiveDirectoryErrorType var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);

        @Override
        public Builder writableStackTrace(Boolean var1);
    }
}

