/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fsx.FSxAsyncClient;
import software.amazon.awssdk.services.fsx.internal.UserAgentUtils;
import software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryAssociationsRequest;
import software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryAssociationsResponse;

public class DescribeDataRepositoryAssociationsPublisher
implements SdkPublisher<DescribeDataRepositoryAssociationsResponse> {
    private final FSxAsyncClient client;
    private final DescribeDataRepositoryAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDataRepositoryAssociationsPublisher(FSxAsyncClient client, DescribeDataRepositoryAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDataRepositoryAssociationsPublisher(FSxAsyncClient client, DescribeDataRepositoryAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDataRepositoryAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDataRepositoryAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeDataRepositoryAssociationsResponseFetcher
    implements AsyncPageFetcher<DescribeDataRepositoryAssociationsResponse> {
        private DescribeDataRepositoryAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDataRepositoryAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeDataRepositoryAssociationsResponse> nextPage(DescribeDataRepositoryAssociationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDataRepositoryAssociationsPublisher.this.client.describeDataRepositoryAssociations(DescribeDataRepositoryAssociationsPublisher.this.firstRequest);
            }
            return DescribeDataRepositoryAssociationsPublisher.this.client.describeDataRepositoryAssociations((DescribeDataRepositoryAssociationsRequest)((Object)DescribeDataRepositoryAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

