/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A snapshot of an Amazon FSx for OpenZFS volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Snapshot implements SdkPojo, Serializable, ToCopyableBuilder<Snapshot.Builder, Snapshot> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceARN").getter(getter(Snapshot::resourceARN)).setter(setter(Builder::resourceARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceARN").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId").getter(getter(Snapshot::snapshotId)).setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Snapshot::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeId").getter(getter(Snapshot::volumeId)).setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(Snapshot::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Lifecycle").getter(getter(Snapshot::lifecycleAsString)).setter(setter(Builder::lifecycle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()).build();

    private static final SdkField<LifecycleTransitionReason> LIFECYCLE_TRANSITION_REASON_FIELD = SdkField
            .<LifecycleTransitionReason> builder(MarshallingType.SDK_POJO).memberName("LifecycleTransitionReason")
            .getter(getter(Snapshot::lifecycleTransitionReason)).setter(setter(Builder::lifecycleTransitionReason))
            .constructor(LifecycleTransitionReason::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleTransitionReason").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(Snapshot::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AdministrativeAction>> ADMINISTRATIVE_ACTIONS_FIELD = SdkField
            .<List<AdministrativeAction>> builder(MarshallingType.LIST)
            .memberName("AdministrativeActions")
            .getter(getter(Snapshot::administrativeActions))
            .setter(setter(Builder::administrativeActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdministrativeActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdministrativeAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdministrativeAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            SNAPSHOT_ID_FIELD, NAME_FIELD, VOLUME_ID_FIELD, CREATION_TIME_FIELD, LIFECYCLE_FIELD,
            LIFECYCLE_TRANSITION_REASON_FIELD, TAGS_FIELD, ADMINISTRATIVE_ACTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceARN;

    private final String snapshotId;

    private final String name;

    private final String volumeId;

    private final Instant creationTime;

    private final String lifecycle;

    private final LifecycleTransitionReason lifecycleTransitionReason;

    private final List<Tag> tags;

    private final List<AdministrativeAction> administrativeActions;

    private Snapshot(BuilderImpl builder) {
        this.resourceARN = builder.resourceARN;
        this.snapshotId = builder.snapshotId;
        this.name = builder.name;
        this.volumeId = builder.volumeId;
        this.creationTime = builder.creationTime;
        this.lifecycle = builder.lifecycle;
        this.lifecycleTransitionReason = builder.lifecycleTransitionReason;
        this.tags = builder.tags;
        this.administrativeActions = builder.administrativeActions;
    }

    /**
     * Returns the value of the ResourceARN property for this object.
     * 
     * @return The value of the ResourceARN property for this object.
     */
    public final String resourceARN() {
        return resourceARN;
    }

    /**
     * <p>
     * The ID of the snapshot.
     * </p>
     * 
     * @return The ID of the snapshot.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The name of the snapshot.
     * </p>
     * 
     * @return The name of the snapshot.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the volume that the snapshot is of.
     * </p>
     * 
     * @return The ID of the volume that the snapshot is of.
     */
    public final String volumeId() {
        return volumeId;
    }

    /**
     * Returns the value of the CreationTime property for this object.
     * 
     * @return The value of the CreationTime property for this object.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The lifecycle status of the snapshot.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> - Amazon FSx hasn't started creating the snapshot.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATING</code> - Amazon FSx is creating the snapshot.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - Amazon FSx is deleting the snapshot.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AVAILABLE</code> - The snapshot is fully available.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycle} will
     * return {@link SnapshotLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lifecycleAsString}.
     * </p>
     * 
     * @return The lifecycle status of the snapshot.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> - Amazon FSx hasn't started creating the snapshot.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - Amazon FSx is creating the snapshot.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - Amazon FSx is deleting the snapshot.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AVAILABLE</code> - The snapshot is fully available.
     *         </p>
     *         </li>
     * @see SnapshotLifecycle
     */
    public final SnapshotLifecycle lifecycle() {
        return SnapshotLifecycle.fromValue(lifecycle);
    }

    /**
     * <p>
     * The lifecycle status of the snapshot.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> - Amazon FSx hasn't started creating the snapshot.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATING</code> - Amazon FSx is creating the snapshot.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - Amazon FSx is deleting the snapshot.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AVAILABLE</code> - The snapshot is fully available.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycle} will
     * return {@link SnapshotLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lifecycleAsString}.
     * </p>
     * 
     * @return The lifecycle status of the snapshot.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> - Amazon FSx hasn't started creating the snapshot.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - Amazon FSx is creating the snapshot.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - Amazon FSx is deleting the snapshot.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AVAILABLE</code> - The snapshot is fully available.
     *         </p>
     *         </li>
     * @see SnapshotLifecycle
     */
    public final String lifecycleAsString() {
        return lifecycle;
    }

    /**
     * Returns the value of the LifecycleTransitionReason property for this object.
     * 
     * @return The value of the LifecycleTransitionReason property for this object.
     */
    public final LifecycleTransitionReason lifecycleTransitionReason() {
        return lifecycleTransitionReason;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdministrativeActions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdministrativeActions() {
        return administrativeActions != null && !(administrativeActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of administrative actions for the file system that are in process or waiting to be processed.
     * Administrative actions describe changes to the Amazon FSx system.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdministrativeActions} method.
     * </p>
     * 
     * @return A list of administrative actions for the file system that are in process or waiting to be processed.
     *         Administrative actions describe changes to the Amazon FSx system.
     */
    public final List<AdministrativeAction> administrativeActions() {
        return administrativeActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleTransitionReason());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAdministrativeActions() ? administrativeActions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Snapshot)) {
            return false;
        }
        Snapshot other = (Snapshot) obj;
        return Objects.equals(resourceARN(), other.resourceARN()) && Objects.equals(snapshotId(), other.snapshotId())
                && Objects.equals(name(), other.name()) && Objects.equals(volumeId(), other.volumeId())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lifecycleAsString(), other.lifecycleAsString())
                && Objects.equals(lifecycleTransitionReason(), other.lifecycleTransitionReason()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasAdministrativeActions() == other.hasAdministrativeActions()
                && Objects.equals(administrativeActions(), other.administrativeActions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Snapshot").add("ResourceARN", resourceARN()).add("SnapshotId", snapshotId()).add("Name", name())
                .add("VolumeId", volumeId()).add("CreationTime", creationTime()).add("Lifecycle", lifecycleAsString())
                .add("LifecycleTransitionReason", lifecycleTransitionReason()).add("Tags", hasTags() ? tags() : null)
                .add("AdministrativeActions", hasAdministrativeActions() ? administrativeActions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceARN":
            return Optional.ofNullable(clazz.cast(resourceARN()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "Lifecycle":
            return Optional.ofNullable(clazz.cast(lifecycleAsString()));
        case "LifecycleTransitionReason":
            return Optional.ofNullable(clazz.cast(lifecycleTransitionReason()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "AdministrativeActions":
            return Optional.ofNullable(clazz.cast(administrativeActions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Snapshot, T> g) {
        return obj -> g.apply((Snapshot) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Snapshot> {
        /**
         * Sets the value of the ResourceARN property for this object.
         *
         * @param resourceARN
         *        The new value for the ResourceARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceARN(String resourceARN);

        /**
         * <p>
         * The ID of the snapshot.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The name of the snapshot.
         * </p>
         * 
         * @param name
         *        The name of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the volume that the snapshot is of.
         * </p>
         * 
         * @param volumeId
         *        The ID of the volume that the snapshot is of.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * Sets the value of the CreationTime property for this object.
         *
         * @param creationTime
         *        The new value for the CreationTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The lifecycle status of the snapshot.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> - Amazon FSx hasn't started creating the snapshot.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATING</code> - Amazon FSx is creating the snapshot.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - Amazon FSx is deleting the snapshot.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AVAILABLE</code> - The snapshot is fully available.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lifecycle
         *        The lifecycle status of the snapshot.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> - Amazon FSx hasn't started creating the snapshot.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - Amazon FSx is creating the snapshot.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - Amazon FSx is deleting the snapshot.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AVAILABLE</code> - The snapshot is fully available.
         *        </p>
         *        </li>
         * @see SnapshotLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotLifecycle
         */
        Builder lifecycle(String lifecycle);

        /**
         * <p>
         * The lifecycle status of the snapshot.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> - Amazon FSx hasn't started creating the snapshot.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATING</code> - Amazon FSx is creating the snapshot.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - Amazon FSx is deleting the snapshot.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AVAILABLE</code> - The snapshot is fully available.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lifecycle
         *        The lifecycle status of the snapshot.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> - Amazon FSx hasn't started creating the snapshot.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - Amazon FSx is creating the snapshot.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - Amazon FSx is deleting the snapshot.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AVAILABLE</code> - The snapshot is fully available.
         *        </p>
         *        </li>
         * @see SnapshotLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotLifecycle
         */
        Builder lifecycle(SnapshotLifecycle lifecycle);

        /**
         * Sets the value of the LifecycleTransitionReason property for this object.
         *
         * @param lifecycleTransitionReason
         *        The new value for the LifecycleTransitionReason property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleTransitionReason(LifecycleTransitionReason lifecycleTransitionReason);

        /**
         * Sets the value of the LifecycleTransitionReason property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LifecycleTransitionReason.Builder}
         * avoiding the need to create one manually via {@link LifecycleTransitionReason#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LifecycleTransitionReason.Builder#build()} is called immediately
         * and its result is passed to {@link #lifecycleTransitionReason(LifecycleTransitionReason)}.
         * 
         * @param lifecycleTransitionReason
         *        a consumer that will call methods on {@link LifecycleTransitionReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecycleTransitionReason(LifecycleTransitionReason)
         */
        default Builder lifecycleTransitionReason(Consumer<LifecycleTransitionReason.Builder> lifecycleTransitionReason) {
            return lifecycleTransitionReason(LifecycleTransitionReason.builder().applyMutation(lifecycleTransitionReason).build());
        }

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fsx.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.fsx.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.fsx.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.fsx.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A list of administrative actions for the file system that are in process or waiting to be processed.
         * Administrative actions describe changes to the Amazon FSx system.
         * </p>
         * 
         * @param administrativeActions
         *        A list of administrative actions for the file system that are in process or waiting to be processed.
         *        Administrative actions describe changes to the Amazon FSx system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder administrativeActions(Collection<AdministrativeAction> administrativeActions);

        /**
         * <p>
         * A list of administrative actions for the file system that are in process or waiting to be processed.
         * Administrative actions describe changes to the Amazon FSx system.
         * </p>
         * 
         * @param administrativeActions
         *        A list of administrative actions for the file system that are in process or waiting to be processed.
         *        Administrative actions describe changes to the Amazon FSx system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder administrativeActions(AdministrativeAction... administrativeActions);

        /**
         * <p>
         * A list of administrative actions for the file system that are in process or waiting to be processed.
         * Administrative actions describe changes to the Amazon FSx system.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fsx.model.AdministrativeAction.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.fsx.model.AdministrativeAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.fsx.model.AdministrativeAction.Builder#build()} is called immediately
         * and its result is passed to {@link #administrativeActions(List<AdministrativeAction>)}.
         * 
         * @param administrativeActions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.fsx.model.AdministrativeAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #administrativeActions(java.util.Collection<AdministrativeAction>)
         */
        Builder administrativeActions(Consumer<AdministrativeAction.Builder>... administrativeActions);
    }

    static final class BuilderImpl implements Builder {
        private String resourceARN;

        private String snapshotId;

        private String name;

        private String volumeId;

        private Instant creationTime;

        private String lifecycle;

        private LifecycleTransitionReason lifecycleTransitionReason;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<AdministrativeAction> administrativeActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Snapshot model) {
            resourceARN(model.resourceARN);
            snapshotId(model.snapshotId);
            name(model.name);
            volumeId(model.volumeId);
            creationTime(model.creationTime);
            lifecycle(model.lifecycle);
            lifecycleTransitionReason(model.lifecycleTransitionReason);
            tags(model.tags);
            administrativeActions(model.administrativeActions);
        }

        public final String getResourceARN() {
            return resourceARN;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getLifecycle() {
            return lifecycle;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(SnapshotLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        public final LifecycleTransitionReason.Builder getLifecycleTransitionReason() {
            return lifecycleTransitionReason != null ? lifecycleTransitionReason.toBuilder() : null;
        }

        public final void setLifecycleTransitionReason(LifecycleTransitionReason.BuilderImpl lifecycleTransitionReason) {
            this.lifecycleTransitionReason = lifecycleTransitionReason != null ? lifecycleTransitionReason.build() : null;
        }

        @Override
        public final Builder lifecycleTransitionReason(LifecycleTransitionReason lifecycleTransitionReason) {
            this.lifecycleTransitionReason = lifecycleTransitionReason;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AdministrativeAction.Builder> getAdministrativeActions() {
            List<AdministrativeAction.Builder> result = AdministrativeActionsCopier.copyToBuilder(this.administrativeActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdministrativeActions(Collection<AdministrativeAction.BuilderImpl> administrativeActions) {
            this.administrativeActions = AdministrativeActionsCopier.copyFromBuilder(administrativeActions);
        }

        @Override
        public final Builder administrativeActions(Collection<AdministrativeAction> administrativeActions) {
            this.administrativeActions = AdministrativeActionsCopier.copy(administrativeActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder administrativeActions(AdministrativeAction... administrativeActions) {
            administrativeActions(Arrays.asList(administrativeActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder administrativeActions(Consumer<AdministrativeAction.Builder>... administrativeActions) {
            administrativeActions(Stream.of(administrativeActions)
                    .map(c -> AdministrativeAction.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Snapshot build() {
            return new Snapshot(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
