/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStorageVirtualMachineRequest extends FSxRequest implements
        ToCopyableBuilder<CreateStorageVirtualMachineRequest.Builder, CreateStorageVirtualMachineRequest> {
    private static final SdkField<CreateSvmActiveDirectoryConfiguration> ACTIVE_DIRECTORY_CONFIGURATION_FIELD = SdkField
            .<CreateSvmActiveDirectoryConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ActiveDirectoryConfiguration")
            .getter(getter(CreateStorageVirtualMachineRequest::activeDirectoryConfiguration))
            .setter(setter(Builder::activeDirectoryConfiguration))
            .constructor(CreateSvmActiveDirectoryConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectoryConfiguration")
                    .build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateStorageVirtualMachineRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileSystemId").getter(getter(CreateStorageVirtualMachineRequest::fileSystemId))
            .setter(setter(Builder::fileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateStorageVirtualMachineRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> SVM_ADMIN_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SvmAdminPassword").getter(getter(CreateStorageVirtualMachineRequest::svmAdminPassword))
            .setter(setter(Builder::svmAdminPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SvmAdminPassword").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateStorageVirtualMachineRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROOT_VOLUME_SECURITY_STYLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RootVolumeSecurityStyle")
            .getter(getter(CreateStorageVirtualMachineRequest::rootVolumeSecurityStyleAsString))
            .setter(setter(Builder::rootVolumeSecurityStyle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootVolumeSecurityStyle").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ACTIVE_DIRECTORY_CONFIGURATION_FIELD, CLIENT_REQUEST_TOKEN_FIELD, FILE_SYSTEM_ID_FIELD, NAME_FIELD,
            SVM_ADMIN_PASSWORD_FIELD, TAGS_FIELD, ROOT_VOLUME_SECURITY_STYLE_FIELD));

    private final CreateSvmActiveDirectoryConfiguration activeDirectoryConfiguration;

    private final String clientRequestToken;

    private final String fileSystemId;

    private final String name;

    private final String svmAdminPassword;

    private final List<Tag> tags;

    private final String rootVolumeSecurityStyle;

    private CreateStorageVirtualMachineRequest(BuilderImpl builder) {
        super(builder);
        this.activeDirectoryConfiguration = builder.activeDirectoryConfiguration;
        this.clientRequestToken = builder.clientRequestToken;
        this.fileSystemId = builder.fileSystemId;
        this.name = builder.name;
        this.svmAdminPassword = builder.svmAdminPassword;
        this.tags = builder.tags;
        this.rootVolumeSecurityStyle = builder.rootVolumeSecurityStyle;
    }

    /**
     * <p>
     * Describes the self-managed Microsoft Active Directory to which you want to join the SVM. Joining an Active
     * Directory provides user authentication and access control for SMB clients, including Microsoft Windows and macOS
     * client accessing the file system.
     * </p>
     * 
     * @return Describes the self-managed Microsoft Active Directory to which you want to join the SVM. Joining an
     *         Active Directory provides user authentication and access control for SMB clients, including Microsoft
     *         Windows and macOS client accessing the file system.
     */
    public final CreateSvmActiveDirectoryConfiguration activeDirectoryConfiguration() {
        return activeDirectoryConfiguration;
    }

    /**
     * Returns the value of the ClientRequestToken property for this object.
     * 
     * @return The value of the ClientRequestToken property for this object.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * Returns the value of the FileSystemId property for this object.
     * 
     * @return The value of the FileSystemId property for this object.
     */
    public final String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * The name of the SVM.
     * </p>
     * 
     * @return The name of the SVM.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The password to use when managing the SVM using the NetApp ONTAP CLI or REST API. If you do not specify a
     * password, you can still use the file system's <code>fsxadmin</code> user to manage the SVM.
     * </p>
     * 
     * @return The password to use when managing the SVM using the NetApp ONTAP CLI or REST API. If you do not specify a
     *         password, you can still use the file system's <code>fsxadmin</code> user to manage the SVM.
     */
    public final String svmAdminPassword() {
        return svmAdminPassword;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The security style of the root volume of the SVM. Specify one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS clients,
     * and an application accessing the data uses a UNIX user as the service account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are SMB
     * clients, and an application accessing the data uses a Windows user as the service account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MIXED</code> if the file system is managed by both UNIX and Windows administrators and users consist of
     * both NFS and SMB clients.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #rootVolumeSecurityStyle} will return
     * {@link StorageVirtualMachineRootVolumeSecurityStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #rootVolumeSecurityStyleAsString}.
     * </p>
     * 
     * @return The security style of the root volume of the SVM. Specify one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS
     *         clients, and an application accessing the data uses a UNIX user as the service account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are SMB
     *         clients, and an application accessing the data uses a Windows user as the service account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MIXED</code> if the file system is managed by both UNIX and Windows administrators and users
     *         consist of both NFS and SMB clients.
     *         </p>
     *         </li>
     * @see StorageVirtualMachineRootVolumeSecurityStyle
     */
    public final StorageVirtualMachineRootVolumeSecurityStyle rootVolumeSecurityStyle() {
        return StorageVirtualMachineRootVolumeSecurityStyle.fromValue(rootVolumeSecurityStyle);
    }

    /**
     * <p>
     * The security style of the root volume of the SVM. Specify one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS clients,
     * and an application accessing the data uses a UNIX user as the service account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are SMB
     * clients, and an application accessing the data uses a Windows user as the service account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MIXED</code> if the file system is managed by both UNIX and Windows administrators and users consist of
     * both NFS and SMB clients.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #rootVolumeSecurityStyle} will return
     * {@link StorageVirtualMachineRootVolumeSecurityStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #rootVolumeSecurityStyleAsString}.
     * </p>
     * 
     * @return The security style of the root volume of the SVM. Specify one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS
     *         clients, and an application accessing the data uses a UNIX user as the service account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are SMB
     *         clients, and an application accessing the data uses a Windows user as the service account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MIXED</code> if the file system is managed by both UNIX and Windows administrators and users
     *         consist of both NFS and SMB clients.
     *         </p>
     *         </li>
     * @see StorageVirtualMachineRootVolumeSecurityStyle
     */
    public final String rootVolumeSecurityStyleAsString() {
        return rootVolumeSecurityStyle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(activeDirectoryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(svmAdminPassword());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(rootVolumeSecurityStyleAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStorageVirtualMachineRequest)) {
            return false;
        }
        CreateStorageVirtualMachineRequest other = (CreateStorageVirtualMachineRequest) obj;
        return Objects.equals(activeDirectoryConfiguration(), other.activeDirectoryConfiguration())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(fileSystemId(), other.fileSystemId()) && Objects.equals(name(), other.name())
                && Objects.equals(svmAdminPassword(), other.svmAdminPassword()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(rootVolumeSecurityStyleAsString(), other.rootVolumeSecurityStyleAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateStorageVirtualMachineRequest")
                .add("ActiveDirectoryConfiguration", activeDirectoryConfiguration())
                .add("ClientRequestToken", clientRequestToken()).add("FileSystemId", fileSystemId()).add("Name", name())
                .add("SvmAdminPassword", svmAdminPassword() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Tags", hasTags() ? tags() : null).add("RootVolumeSecurityStyle", rootVolumeSecurityStyleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActiveDirectoryConfiguration":
            return Optional.ofNullable(clazz.cast(activeDirectoryConfiguration()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "FileSystemId":
            return Optional.ofNullable(clazz.cast(fileSystemId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SvmAdminPassword":
            return Optional.ofNullable(clazz.cast(svmAdminPassword()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "RootVolumeSecurityStyle":
            return Optional.ofNullable(clazz.cast(rootVolumeSecurityStyleAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStorageVirtualMachineRequest, T> g) {
        return obj -> g.apply((CreateStorageVirtualMachineRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateStorageVirtualMachineRequest> {
        /**
         * <p>
         * Describes the self-managed Microsoft Active Directory to which you want to join the SVM. Joining an Active
         * Directory provides user authentication and access control for SMB clients, including Microsoft Windows and
         * macOS client accessing the file system.
         * </p>
         * 
         * @param activeDirectoryConfiguration
         *        Describes the self-managed Microsoft Active Directory to which you want to join the SVM. Joining an
         *        Active Directory provides user authentication and access control for SMB clients, including Microsoft
         *        Windows and macOS client accessing the file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeDirectoryConfiguration(CreateSvmActiveDirectoryConfiguration activeDirectoryConfiguration);

        /**
         * <p>
         * Describes the self-managed Microsoft Active Directory to which you want to join the SVM. Joining an Active
         * Directory provides user authentication and access control for SMB clients, including Microsoft Windows and
         * macOS client accessing the file system.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CreateSvmActiveDirectoryConfiguration.Builder} avoiding the need to create one manually via
         * {@link CreateSvmActiveDirectoryConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateSvmActiveDirectoryConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #activeDirectoryConfiguration(CreateSvmActiveDirectoryConfiguration)}.
         * 
         * @param activeDirectoryConfiguration
         *        a consumer that will call methods on {@link CreateSvmActiveDirectoryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activeDirectoryConfiguration(CreateSvmActiveDirectoryConfiguration)
         */
        default Builder activeDirectoryConfiguration(
                Consumer<CreateSvmActiveDirectoryConfiguration.Builder> activeDirectoryConfiguration) {
            return activeDirectoryConfiguration(CreateSvmActiveDirectoryConfiguration.builder()
                    .applyMutation(activeDirectoryConfiguration).build());
        }

        /**
         * Sets the value of the ClientRequestToken property for this object.
         *
         * @param clientRequestToken
         *        The new value for the ClientRequestToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * Sets the value of the FileSystemId property for this object.
         *
         * @param fileSystemId
         *        The new value for the FileSystemId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * The name of the SVM.
         * </p>
         * 
         * @param name
         *        The name of the SVM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The password to use when managing the SVM using the NetApp ONTAP CLI or REST API. If you do not specify a
         * password, you can still use the file system's <code>fsxadmin</code> user to manage the SVM.
         * </p>
         * 
         * @param svmAdminPassword
         *        The password to use when managing the SVM using the NetApp ONTAP CLI or REST API. If you do not
         *        specify a password, you can still use the file system's <code>fsxadmin</code> user to manage the SVM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder svmAdminPassword(String svmAdminPassword);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fsx.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.fsx.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.fsx.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.fsx.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The security style of the root volume of the SVM. Specify one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS
         * clients, and an application accessing the data uses a UNIX user as the service account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are SMB
         * clients, and an application accessing the data uses a Windows user as the service account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MIXED</code> if the file system is managed by both UNIX and Windows administrators and users consist of
         * both NFS and SMB clients.
         * </p>
         * </li>
         * </ul>
         * 
         * @param rootVolumeSecurityStyle
         *        The security style of the root volume of the SVM. Specify one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS
         *        clients, and an application accessing the data uses a UNIX user as the service account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are
         *        SMB clients, and an application accessing the data uses a Windows user as the service account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MIXED</code> if the file system is managed by both UNIX and Windows administrators and users
         *        consist of both NFS and SMB clients.
         *        </p>
         *        </li>
         * @see StorageVirtualMachineRootVolumeSecurityStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageVirtualMachineRootVolumeSecurityStyle
         */
        Builder rootVolumeSecurityStyle(String rootVolumeSecurityStyle);

        /**
         * <p>
         * The security style of the root volume of the SVM. Specify one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS
         * clients, and an application accessing the data uses a UNIX user as the service account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are SMB
         * clients, and an application accessing the data uses a Windows user as the service account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MIXED</code> if the file system is managed by both UNIX and Windows administrators and users consist of
         * both NFS and SMB clients.
         * </p>
         * </li>
         * </ul>
         * 
         * @param rootVolumeSecurityStyle
         *        The security style of the root volume of the SVM. Specify one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS
         *        clients, and an application accessing the data uses a UNIX user as the service account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are
         *        SMB clients, and an application accessing the data uses a Windows user as the service account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MIXED</code> if the file system is managed by both UNIX and Windows administrators and users
         *        consist of both NFS and SMB clients.
         *        </p>
         *        </li>
         * @see StorageVirtualMachineRootVolumeSecurityStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageVirtualMachineRootVolumeSecurityStyle
         */
        Builder rootVolumeSecurityStyle(StorageVirtualMachineRootVolumeSecurityStyle rootVolumeSecurityStyle);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FSxRequest.BuilderImpl implements Builder {
        private CreateSvmActiveDirectoryConfiguration activeDirectoryConfiguration;

        private String clientRequestToken;

        private String fileSystemId;

        private String name;

        private String svmAdminPassword;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String rootVolumeSecurityStyle;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStorageVirtualMachineRequest model) {
            super(model);
            activeDirectoryConfiguration(model.activeDirectoryConfiguration);
            clientRequestToken(model.clientRequestToken);
            fileSystemId(model.fileSystemId);
            name(model.name);
            svmAdminPassword(model.svmAdminPassword);
            tags(model.tags);
            rootVolumeSecurityStyle(model.rootVolumeSecurityStyle);
        }

        public final CreateSvmActiveDirectoryConfiguration.Builder getActiveDirectoryConfiguration() {
            return activeDirectoryConfiguration != null ? activeDirectoryConfiguration.toBuilder() : null;
        }

        public final void setActiveDirectoryConfiguration(
                CreateSvmActiveDirectoryConfiguration.BuilderImpl activeDirectoryConfiguration) {
            this.activeDirectoryConfiguration = activeDirectoryConfiguration != null ? activeDirectoryConfiguration.build()
                    : null;
        }

        @Override
        public final Builder activeDirectoryConfiguration(CreateSvmActiveDirectoryConfiguration activeDirectoryConfiguration) {
            this.activeDirectoryConfiguration = activeDirectoryConfiguration;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSvmAdminPassword() {
            return svmAdminPassword;
        }

        public final void setSvmAdminPassword(String svmAdminPassword) {
            this.svmAdminPassword = svmAdminPassword;
        }

        @Override
        public final Builder svmAdminPassword(String svmAdminPassword) {
            this.svmAdminPassword = svmAdminPassword;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRootVolumeSecurityStyle() {
            return rootVolumeSecurityStyle;
        }

        public final void setRootVolumeSecurityStyle(String rootVolumeSecurityStyle) {
            this.rootVolumeSecurityStyle = rootVolumeSecurityStyle;
        }

        @Override
        public final Builder rootVolumeSecurityStyle(String rootVolumeSecurityStyle) {
            this.rootVolumeSecurityStyle = rootVolumeSecurityStyle;
            return this;
        }

        @Override
        public final Builder rootVolumeSecurityStyle(StorageVirtualMachineRootVolumeSecurityStyle rootVolumeSecurityStyle) {
            this.rootVolumeSecurityStyle(rootVolumeSecurityStyle == null ? null : rootVolumeSecurityStyle.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStorageVirtualMachineRequest build() {
            return new CreateStorageVirtualMachineRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
