/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BackupLifecycle {
    AVAILABLE("AVAILABLE"),
    CREATING("CREATING"),
    TRANSFERRING("TRANSFERRING"),
    DELETED("DELETED"),
    FAILED("FAILED"),
    PENDING("PENDING"),
    COPYING("COPYING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BackupLifecycle> VALUE_MAP;
    private final String value;

    private BackupLifecycle(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BackupLifecycle fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BackupLifecycle> knownValues() {
        EnumSet<BackupLifecycle> knownValues = EnumSet.allOf(BackupLifecycle.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BackupLifecycle.class, BackupLifecycle::toString);
    }
}

