/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FileSystemType {
    WINDOWS("WINDOWS"),
    LUSTRE("LUSTRE"),
    ONTAP("ONTAP"),
    OPENZFS("OPENZFS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FileSystemType> VALUE_MAP;
    private final String value;

    private FileSystemType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FileSystemType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FileSystemType> knownValues() {
        EnumSet<FileSystemType> knownValues = EnumSet.allOf(FileSystemType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FileSystemType.class, FileSystemType::toString);
    }
}

