/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.DiskIopsConfiguration;
import software.amazon.awssdk.services.fsx.model.OpenZFSDeploymentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpenZFSFileSystemConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpenZFSFileSystemConfiguration> {
    private static final SdkField<Integer> AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AutomaticBackupRetentionDays").getter(OpenZFSFileSystemConfiguration.getter(OpenZFSFileSystemConfiguration::automaticBackupRetentionDays)).setter(OpenZFSFileSystemConfiguration.setter(Builder::automaticBackupRetentionDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticBackupRetentionDays").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_TO_BACKUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTagsToBackups").getter(OpenZFSFileSystemConfiguration.getter(OpenZFSFileSystemConfiguration::copyTagsToBackups)).setter(OpenZFSFileSystemConfiguration.setter(Builder::copyTagsToBackups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToBackups").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_TO_VOLUMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTagsToVolumes").getter(OpenZFSFileSystemConfiguration.getter(OpenZFSFileSystemConfiguration::copyTagsToVolumes)).setter(OpenZFSFileSystemConfiguration.setter(Builder::copyTagsToVolumes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToVolumes").build()}).build();
    private static final SdkField<String> DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DailyAutomaticBackupStartTime").getter(OpenZFSFileSystemConfiguration.getter(OpenZFSFileSystemConfiguration::dailyAutomaticBackupStartTime)).setter(OpenZFSFileSystemConfiguration.setter(Builder::dailyAutomaticBackupStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailyAutomaticBackupStartTime").build()}).build();
    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentType").getter(OpenZFSFileSystemConfiguration.getter(OpenZFSFileSystemConfiguration::deploymentTypeAsString)).setter(OpenZFSFileSystemConfiguration.setter(Builder::deploymentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentType").build()}).build();
    private static final SdkField<Integer> THROUGHPUT_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ThroughputCapacity").getter(OpenZFSFileSystemConfiguration.getter(OpenZFSFileSystemConfiguration::throughputCapacity)).setter(OpenZFSFileSystemConfiguration.setter(Builder::throughputCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputCapacity").build()}).build();
    private static final SdkField<String> WEEKLY_MAINTENANCE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WeeklyMaintenanceStartTime").getter(OpenZFSFileSystemConfiguration.getter(OpenZFSFileSystemConfiguration::weeklyMaintenanceStartTime)).setter(OpenZFSFileSystemConfiguration.setter(Builder::weeklyMaintenanceStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceStartTime").build()}).build();
    private static final SdkField<DiskIopsConfiguration> DISK_IOPS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DiskIopsConfiguration").getter(OpenZFSFileSystemConfiguration.getter(OpenZFSFileSystemConfiguration::diskIopsConfiguration)).setter(OpenZFSFileSystemConfiguration.setter(Builder::diskIopsConfiguration)).constructor(DiskIopsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskIopsConfiguration").build()}).build();
    private static final SdkField<String> ROOT_VOLUME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RootVolumeId").getter(OpenZFSFileSystemConfiguration.getter(OpenZFSFileSystemConfiguration::rootVolumeId)).setter(OpenZFSFileSystemConfiguration.setter(Builder::rootVolumeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootVolumeId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD, COPY_TAGS_TO_BACKUPS_FIELD, COPY_TAGS_TO_VOLUMES_FIELD, DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD, DEPLOYMENT_TYPE_FIELD, THROUGHPUT_CAPACITY_FIELD, WEEKLY_MAINTENANCE_START_TIME_FIELD, DISK_IOPS_CONFIGURATION_FIELD, ROOT_VOLUME_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer automaticBackupRetentionDays;
    private final Boolean copyTagsToBackups;
    private final Boolean copyTagsToVolumes;
    private final String dailyAutomaticBackupStartTime;
    private final String deploymentType;
    private final Integer throughputCapacity;
    private final String weeklyMaintenanceStartTime;
    private final DiskIopsConfiguration diskIopsConfiguration;
    private final String rootVolumeId;

    private OpenZFSFileSystemConfiguration(BuilderImpl builder) {
        this.automaticBackupRetentionDays = builder.automaticBackupRetentionDays;
        this.copyTagsToBackups = builder.copyTagsToBackups;
        this.copyTagsToVolumes = builder.copyTagsToVolumes;
        this.dailyAutomaticBackupStartTime = builder.dailyAutomaticBackupStartTime;
        this.deploymentType = builder.deploymentType;
        this.throughputCapacity = builder.throughputCapacity;
        this.weeklyMaintenanceStartTime = builder.weeklyMaintenanceStartTime;
        this.diskIopsConfiguration = builder.diskIopsConfiguration;
        this.rootVolumeId = builder.rootVolumeId;
    }

    public final Integer automaticBackupRetentionDays() {
        return this.automaticBackupRetentionDays;
    }

    public final Boolean copyTagsToBackups() {
        return this.copyTagsToBackups;
    }

    public final Boolean copyTagsToVolumes() {
        return this.copyTagsToVolumes;
    }

    public final String dailyAutomaticBackupStartTime() {
        return this.dailyAutomaticBackupStartTime;
    }

    public final OpenZFSDeploymentType deploymentType() {
        return OpenZFSDeploymentType.fromValue(this.deploymentType);
    }

    public final String deploymentTypeAsString() {
        return this.deploymentType;
    }

    public final Integer throughputCapacity() {
        return this.throughputCapacity;
    }

    public final String weeklyMaintenanceStartTime() {
        return this.weeklyMaintenanceStartTime;
    }

    public final DiskIopsConfiguration diskIopsConfiguration() {
        return this.diskIopsConfiguration;
    }

    public final String rootVolumeId() {
        return this.rootVolumeId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticBackupRetentionDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsToBackups());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsToVolumes());
        hashCode = 31 * hashCode + Objects.hashCode(this.dailyAutomaticBackupStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.throughputCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.weeklyMaintenanceStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskIopsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootVolumeId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenZFSFileSystemConfiguration)) {
            return false;
        }
        OpenZFSFileSystemConfiguration other = (OpenZFSFileSystemConfiguration)obj;
        return Objects.equals(this.automaticBackupRetentionDays(), other.automaticBackupRetentionDays()) && Objects.equals(this.copyTagsToBackups(), other.copyTagsToBackups()) && Objects.equals(this.copyTagsToVolumes(), other.copyTagsToVolumes()) && Objects.equals(this.dailyAutomaticBackupStartTime(), other.dailyAutomaticBackupStartTime()) && Objects.equals(this.deploymentTypeAsString(), other.deploymentTypeAsString()) && Objects.equals(this.throughputCapacity(), other.throughputCapacity()) && Objects.equals(this.weeklyMaintenanceStartTime(), other.weeklyMaintenanceStartTime()) && Objects.equals(this.diskIopsConfiguration(), other.diskIopsConfiguration()) && Objects.equals(this.rootVolumeId(), other.rootVolumeId());
    }

    public final String toString() {
        return ToString.builder((String)"OpenZFSFileSystemConfiguration").add("AutomaticBackupRetentionDays", (Object)this.automaticBackupRetentionDays()).add("CopyTagsToBackups", (Object)this.copyTagsToBackups()).add("CopyTagsToVolumes", (Object)this.copyTagsToVolumes()).add("DailyAutomaticBackupStartTime", (Object)this.dailyAutomaticBackupStartTime()).add("DeploymentType", (Object)this.deploymentTypeAsString()).add("ThroughputCapacity", (Object)this.throughputCapacity()).add("WeeklyMaintenanceStartTime", (Object)this.weeklyMaintenanceStartTime()).add("DiskIopsConfiguration", (Object)this.diskIopsConfiguration()).add("RootVolumeId", (Object)this.rootVolumeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutomaticBackupRetentionDays": {
                return Optional.ofNullable(clazz.cast(this.automaticBackupRetentionDays()));
            }
            case "CopyTagsToBackups": {
                return Optional.ofNullable(clazz.cast(this.copyTagsToBackups()));
            }
            case "CopyTagsToVolumes": {
                return Optional.ofNullable(clazz.cast(this.copyTagsToVolumes()));
            }
            case "DailyAutomaticBackupStartTime": {
                return Optional.ofNullable(clazz.cast(this.dailyAutomaticBackupStartTime()));
            }
            case "DeploymentType": {
                return Optional.ofNullable(clazz.cast(this.deploymentTypeAsString()));
            }
            case "ThroughputCapacity": {
                return Optional.ofNullable(clazz.cast(this.throughputCapacity()));
            }
            case "WeeklyMaintenanceStartTime": {
                return Optional.ofNullable(clazz.cast(this.weeklyMaintenanceStartTime()));
            }
            case "DiskIopsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.diskIopsConfiguration()));
            }
            case "RootVolumeId": {
                return Optional.ofNullable(clazz.cast(this.rootVolumeId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OpenZFSFileSystemConfiguration, T> g) {
        return obj -> g.apply((OpenZFSFileSystemConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer automaticBackupRetentionDays;
        private Boolean copyTagsToBackups;
        private Boolean copyTagsToVolumes;
        private String dailyAutomaticBackupStartTime;
        private String deploymentType;
        private Integer throughputCapacity;
        private String weeklyMaintenanceStartTime;
        private DiskIopsConfiguration diskIopsConfiguration;
        private String rootVolumeId;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenZFSFileSystemConfiguration model) {
            this.automaticBackupRetentionDays(model.automaticBackupRetentionDays);
            this.copyTagsToBackups(model.copyTagsToBackups);
            this.copyTagsToVolumes(model.copyTagsToVolumes);
            this.dailyAutomaticBackupStartTime(model.dailyAutomaticBackupStartTime);
            this.deploymentType(model.deploymentType);
            this.throughputCapacity(model.throughputCapacity);
            this.weeklyMaintenanceStartTime(model.weeklyMaintenanceStartTime);
            this.diskIopsConfiguration(model.diskIopsConfiguration);
            this.rootVolumeId(model.rootVolumeId);
        }

        public final Integer getAutomaticBackupRetentionDays() {
            return this.automaticBackupRetentionDays;
        }

        public final void setAutomaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
        }

        @Override
        public final Builder automaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
            return this;
        }

        public final Boolean getCopyTagsToBackups() {
            return this.copyTagsToBackups;
        }

        public final void setCopyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
        }

        @Override
        public final Builder copyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
            return this;
        }

        public final Boolean getCopyTagsToVolumes() {
            return this.copyTagsToVolumes;
        }

        public final void setCopyTagsToVolumes(Boolean copyTagsToVolumes) {
            this.copyTagsToVolumes = copyTagsToVolumes;
        }

        @Override
        public final Builder copyTagsToVolumes(Boolean copyTagsToVolumes) {
            this.copyTagsToVolumes = copyTagsToVolumes;
            return this;
        }

        public final String getDailyAutomaticBackupStartTime() {
            return this.dailyAutomaticBackupStartTime;
        }

        public final void setDailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
        }

        @Override
        public final Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
            return this;
        }

        public final String getDeploymentType() {
            return this.deploymentType;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(OpenZFSDeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final Integer getThroughputCapacity() {
            return this.throughputCapacity;
        }

        public final void setThroughputCapacity(Integer throughputCapacity) {
            this.throughputCapacity = throughputCapacity;
        }

        @Override
        public final Builder throughputCapacity(Integer throughputCapacity) {
            this.throughputCapacity = throughputCapacity;
            return this;
        }

        public final String getWeeklyMaintenanceStartTime() {
            return this.weeklyMaintenanceStartTime;
        }

        public final void setWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
        }

        @Override
        public final Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            return this;
        }

        public final DiskIopsConfiguration.Builder getDiskIopsConfiguration() {
            return this.diskIopsConfiguration != null ? this.diskIopsConfiguration.toBuilder() : null;
        }

        public final void setDiskIopsConfiguration(DiskIopsConfiguration.BuilderImpl diskIopsConfiguration) {
            this.diskIopsConfiguration = diskIopsConfiguration != null ? diskIopsConfiguration.build() : null;
        }

        @Override
        public final Builder diskIopsConfiguration(DiskIopsConfiguration diskIopsConfiguration) {
            this.diskIopsConfiguration = diskIopsConfiguration;
            return this;
        }

        public final String getRootVolumeId() {
            return this.rootVolumeId;
        }

        public final void setRootVolumeId(String rootVolumeId) {
            this.rootVolumeId = rootVolumeId;
        }

        @Override
        public final Builder rootVolumeId(String rootVolumeId) {
            this.rootVolumeId = rootVolumeId;
            return this;
        }

        public OpenZFSFileSystemConfiguration build() {
            return new OpenZFSFileSystemConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpenZFSFileSystemConfiguration> {
        public Builder automaticBackupRetentionDays(Integer var1);

        public Builder copyTagsToBackups(Boolean var1);

        public Builder copyTagsToVolumes(Boolean var1);

        public Builder dailyAutomaticBackupStartTime(String var1);

        public Builder deploymentType(String var1);

        public Builder deploymentType(OpenZFSDeploymentType var1);

        public Builder throughputCapacity(Integer var1);

        public Builder weeklyMaintenanceStartTime(String var1);

        public Builder diskIopsConfiguration(DiskIopsConfiguration var1);

        default public Builder diskIopsConfiguration(Consumer<DiskIopsConfiguration.Builder> diskIopsConfiguration) {
            return this.diskIopsConfiguration((DiskIopsConfiguration)((DiskIopsConfiguration.Builder)DiskIopsConfiguration.builder().applyMutation(diskIopsConfiguration)).build());
        }

        public Builder rootVolumeId(String var1);
    }
}

