/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.SvmEndpoint;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SvmEndpoints
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SvmEndpoints> {
    private static final SdkField<SvmEndpoint> ISCSI_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Iscsi").getter(SvmEndpoints.getter(SvmEndpoints::iscsi)).setter(SvmEndpoints.setter(Builder::iscsi)).constructor(SvmEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iscsi").build()}).build();
    private static final SdkField<SvmEndpoint> MANAGEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Management").getter(SvmEndpoints.getter(SvmEndpoints::management)).setter(SvmEndpoints.setter(Builder::management)).constructor(SvmEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Management").build()}).build();
    private static final SdkField<SvmEndpoint> NFS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Nfs").getter(SvmEndpoints.getter(SvmEndpoints::nfs)).setter(SvmEndpoints.setter(Builder::nfs)).constructor(SvmEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Nfs").build()}).build();
    private static final SdkField<SvmEndpoint> SMB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Smb").getter(SvmEndpoints.getter(SvmEndpoints::smb)).setter(SvmEndpoints.setter(Builder::smb)).constructor(SvmEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Smb").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISCSI_FIELD, MANAGEMENT_FIELD, NFS_FIELD, SMB_FIELD));
    private static final long serialVersionUID = 1L;
    private final SvmEndpoint iscsi;
    private final SvmEndpoint management;
    private final SvmEndpoint nfs;
    private final SvmEndpoint smb;

    private SvmEndpoints(BuilderImpl builder) {
        this.iscsi = builder.iscsi;
        this.management = builder.management;
        this.nfs = builder.nfs;
        this.smb = builder.smb;
    }

    public final SvmEndpoint iscsi() {
        return this.iscsi;
    }

    public final SvmEndpoint management() {
        return this.management;
    }

    public final SvmEndpoint nfs() {
        return this.nfs;
    }

    public final SvmEndpoint smb() {
        return this.smb;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.iscsi());
        hashCode = 31 * hashCode + Objects.hashCode(this.management());
        hashCode = 31 * hashCode + Objects.hashCode(this.nfs());
        hashCode = 31 * hashCode + Objects.hashCode(this.smb());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SvmEndpoints)) {
            return false;
        }
        SvmEndpoints other = (SvmEndpoints)obj;
        return Objects.equals(this.iscsi(), other.iscsi()) && Objects.equals(this.management(), other.management()) && Objects.equals(this.nfs(), other.nfs()) && Objects.equals(this.smb(), other.smb());
    }

    public final String toString() {
        return ToString.builder((String)"SvmEndpoints").add("Iscsi", (Object)this.iscsi()).add("Management", (Object)this.management()).add("Nfs", (Object)this.nfs()).add("Smb", (Object)this.smb()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Iscsi": {
                return Optional.ofNullable(clazz.cast(this.iscsi()));
            }
            case "Management": {
                return Optional.ofNullable(clazz.cast(this.management()));
            }
            case "Nfs": {
                return Optional.ofNullable(clazz.cast(this.nfs()));
            }
            case "Smb": {
                return Optional.ofNullable(clazz.cast(this.smb()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SvmEndpoints, T> g) {
        return obj -> g.apply((SvmEndpoints)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SvmEndpoint iscsi;
        private SvmEndpoint management;
        private SvmEndpoint nfs;
        private SvmEndpoint smb;

        private BuilderImpl() {
        }

        private BuilderImpl(SvmEndpoints model) {
            this.iscsi(model.iscsi);
            this.management(model.management);
            this.nfs(model.nfs);
            this.smb(model.smb);
        }

        public final SvmEndpoint.Builder getIscsi() {
            return this.iscsi != null ? this.iscsi.toBuilder() : null;
        }

        public final void setIscsi(SvmEndpoint.BuilderImpl iscsi) {
            this.iscsi = iscsi != null ? iscsi.build() : null;
        }

        @Override
        public final Builder iscsi(SvmEndpoint iscsi) {
            this.iscsi = iscsi;
            return this;
        }

        public final SvmEndpoint.Builder getManagement() {
            return this.management != null ? this.management.toBuilder() : null;
        }

        public final void setManagement(SvmEndpoint.BuilderImpl management) {
            this.management = management != null ? management.build() : null;
        }

        @Override
        public final Builder management(SvmEndpoint management) {
            this.management = management;
            return this;
        }

        public final SvmEndpoint.Builder getNfs() {
            return this.nfs != null ? this.nfs.toBuilder() : null;
        }

        public final void setNfs(SvmEndpoint.BuilderImpl nfs) {
            this.nfs = nfs != null ? nfs.build() : null;
        }

        @Override
        public final Builder nfs(SvmEndpoint nfs) {
            this.nfs = nfs;
            return this;
        }

        public final SvmEndpoint.Builder getSmb() {
            return this.smb != null ? this.smb.toBuilder() : null;
        }

        public final void setSmb(SvmEndpoint.BuilderImpl smb) {
            this.smb = smb != null ? smb.build() : null;
        }

        @Override
        public final Builder smb(SvmEndpoint smb) {
            this.smb = smb;
            return this;
        }

        public SvmEndpoints build() {
            return new SvmEndpoints(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SvmEndpoints> {
        public Builder iscsi(SvmEndpoint var1);

        default public Builder iscsi(Consumer<SvmEndpoint.Builder> iscsi) {
            return this.iscsi((SvmEndpoint)((SvmEndpoint.Builder)SvmEndpoint.builder().applyMutation(iscsi)).build());
        }

        public Builder management(SvmEndpoint var1);

        default public Builder management(Consumer<SvmEndpoint.Builder> management) {
            return this.management((SvmEndpoint)((SvmEndpoint.Builder)SvmEndpoint.builder().applyMutation(management)).build());
        }

        public Builder nfs(SvmEndpoint var1);

        default public Builder nfs(Consumer<SvmEndpoint.Builder> nfs) {
            return this.nfs((SvmEndpoint)((SvmEndpoint.Builder)SvmEndpoint.builder().applyMutation(nfs)).build());
        }

        public Builder smb(SvmEndpoint var1);

        default public Builder smb(Consumer<SvmEndpoint.Builder> smb) {
            return this.smb((SvmEndpoint)((SvmEndpoint.Builder)SvmEndpoint.builder().applyMutation(smb)).build());
        }
    }
}

