/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.Tag;
import software.amazon.awssdk.services.fsx.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteFileSystemLustreConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeleteFileSystemLustreConfiguration> {
    private static final SdkField<Boolean> SKIP_FINAL_BACKUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SkipFinalBackup").getter(DeleteFileSystemLustreConfiguration.getter(DeleteFileSystemLustreConfiguration::skipFinalBackup)).setter(DeleteFileSystemLustreConfiguration.setter(Builder::skipFinalBackup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkipFinalBackup").build()}).build();
    private static final SdkField<List<Tag>> FINAL_BACKUP_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FinalBackupTags").getter(DeleteFileSystemLustreConfiguration.getter(DeleteFileSystemLustreConfiguration::finalBackupTags)).setter(DeleteFileSystemLustreConfiguration.setter(Builder::finalBackupTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalBackupTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SKIP_FINAL_BACKUP_FIELD, FINAL_BACKUP_TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean skipFinalBackup;
    private final List<Tag> finalBackupTags;

    private DeleteFileSystemLustreConfiguration(BuilderImpl builder) {
        this.skipFinalBackup = builder.skipFinalBackup;
        this.finalBackupTags = builder.finalBackupTags;
    }

    public final Boolean skipFinalBackup() {
        return this.skipFinalBackup;
    }

    public final boolean hasFinalBackupTags() {
        return this.finalBackupTags != null && !(this.finalBackupTags instanceof SdkAutoConstructList);
    }

    public final List<Tag> finalBackupTags() {
        return this.finalBackupTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.skipFinalBackup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFinalBackupTags() ? this.finalBackupTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFileSystemLustreConfiguration)) {
            return false;
        }
        DeleteFileSystemLustreConfiguration other = (DeleteFileSystemLustreConfiguration)obj;
        return Objects.equals(this.skipFinalBackup(), other.skipFinalBackup()) && this.hasFinalBackupTags() == other.hasFinalBackupTags() && Objects.equals(this.finalBackupTags(), other.finalBackupTags());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteFileSystemLustreConfiguration").add("SkipFinalBackup", (Object)this.skipFinalBackup()).add("FinalBackupTags", this.hasFinalBackupTags() ? this.finalBackupTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SkipFinalBackup": {
                return Optional.ofNullable(clazz.cast(this.skipFinalBackup()));
            }
            case "FinalBackupTags": {
                return Optional.ofNullable(clazz.cast(this.finalBackupTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteFileSystemLustreConfiguration, T> g) {
        return obj -> g.apply((DeleteFileSystemLustreConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean skipFinalBackup;
        private List<Tag> finalBackupTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFileSystemLustreConfiguration model) {
            this.skipFinalBackup(model.skipFinalBackup);
            this.finalBackupTags(model.finalBackupTags);
        }

        public final Boolean getSkipFinalBackup() {
            return this.skipFinalBackup;
        }

        public final void setSkipFinalBackup(Boolean skipFinalBackup) {
            this.skipFinalBackup = skipFinalBackup;
        }

        @Override
        @Transient
        public final Builder skipFinalBackup(Boolean skipFinalBackup) {
            this.skipFinalBackup = skipFinalBackup;
            return this;
        }

        public final List<Tag.Builder> getFinalBackupTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.finalBackupTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFinalBackupTags(Collection<Tag.BuilderImpl> finalBackupTags) {
            this.finalBackupTags = TagsCopier.copyFromBuilder(finalBackupTags);
        }

        @Override
        @Transient
        public final Builder finalBackupTags(Collection<Tag> finalBackupTags) {
            this.finalBackupTags = TagsCopier.copy(finalBackupTags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder finalBackupTags(Tag ... finalBackupTags) {
            this.finalBackupTags(Arrays.asList(finalBackupTags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder finalBackupTags(Consumer<Tag.Builder> ... finalBackupTags) {
            this.finalBackupTags(Stream.of(finalBackupTags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DeleteFileSystemLustreConfiguration build() {
            return new DeleteFileSystemLustreConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeleteFileSystemLustreConfiguration> {
        public Builder skipFinalBackup(Boolean var1);

        public Builder finalBackupTags(Collection<Tag> var1);

        public Builder finalBackupTags(Tag ... var1);

        public Builder finalBackupTags(Consumer<Tag.Builder> ... var1);
    }
}

