/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.AutoImportPolicyType;
import software.amazon.awssdk.services.fsx.model.DataCompressionType;
import software.amazon.awssdk.services.fsx.model.DriveCacheType;
import software.amazon.awssdk.services.fsx.model.LustreDeploymentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFileSystemLustreConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateFileSystemLustreConfiguration> {
    private static final SdkField<String> WEEKLY_MAINTENANCE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WeeklyMaintenanceStartTime").getter(CreateFileSystemLustreConfiguration.getter(CreateFileSystemLustreConfiguration::weeklyMaintenanceStartTime)).setter(CreateFileSystemLustreConfiguration.setter(Builder::weeklyMaintenanceStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceStartTime").build()}).build();
    private static final SdkField<String> IMPORT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImportPath").getter(CreateFileSystemLustreConfiguration.getter(CreateFileSystemLustreConfiguration::importPath)).setter(CreateFileSystemLustreConfiguration.setter(Builder::importPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportPath").build()}).build();
    private static final SdkField<String> EXPORT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportPath").getter(CreateFileSystemLustreConfiguration.getter(CreateFileSystemLustreConfiguration::exportPath)).setter(CreateFileSystemLustreConfiguration.setter(Builder::exportPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportPath").build()}).build();
    private static final SdkField<Integer> IMPORTED_FILE_CHUNK_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ImportedFileChunkSize").getter(CreateFileSystemLustreConfiguration.getter(CreateFileSystemLustreConfiguration::importedFileChunkSize)).setter(CreateFileSystemLustreConfiguration.setter(Builder::importedFileChunkSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportedFileChunkSize").build()}).build();
    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentType").getter(CreateFileSystemLustreConfiguration.getter(CreateFileSystemLustreConfiguration::deploymentTypeAsString)).setter(CreateFileSystemLustreConfiguration.setter(Builder::deploymentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentType").build()}).build();
    private static final SdkField<String> AUTO_IMPORT_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoImportPolicy").getter(CreateFileSystemLustreConfiguration.getter(CreateFileSystemLustreConfiguration::autoImportPolicyAsString)).setter(CreateFileSystemLustreConfiguration.setter(Builder::autoImportPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoImportPolicy").build()}).build();
    private static final SdkField<Integer> PER_UNIT_STORAGE_THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PerUnitStorageThroughput").getter(CreateFileSystemLustreConfiguration.getter(CreateFileSystemLustreConfiguration::perUnitStorageThroughput)).setter(CreateFileSystemLustreConfiguration.setter(Builder::perUnitStorageThroughput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerUnitStorageThroughput").build()}).build();
    private static final SdkField<String> DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DailyAutomaticBackupStartTime").getter(CreateFileSystemLustreConfiguration.getter(CreateFileSystemLustreConfiguration::dailyAutomaticBackupStartTime)).setter(CreateFileSystemLustreConfiguration.setter(Builder::dailyAutomaticBackupStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailyAutomaticBackupStartTime").build()}).build();
    private static final SdkField<Integer> AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AutomaticBackupRetentionDays").getter(CreateFileSystemLustreConfiguration.getter(CreateFileSystemLustreConfiguration::automaticBackupRetentionDays)).setter(CreateFileSystemLustreConfiguration.setter(Builder::automaticBackupRetentionDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticBackupRetentionDays").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_TO_BACKUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTagsToBackups").getter(CreateFileSystemLustreConfiguration.getter(CreateFileSystemLustreConfiguration::copyTagsToBackups)).setter(CreateFileSystemLustreConfiguration.setter(Builder::copyTagsToBackups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToBackups").build()}).build();
    private static final SdkField<String> DRIVE_CACHE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DriveCacheType").getter(CreateFileSystemLustreConfiguration.getter(CreateFileSystemLustreConfiguration::driveCacheTypeAsString)).setter(CreateFileSystemLustreConfiguration.setter(Builder::driveCacheType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DriveCacheType").build()}).build();
    private static final SdkField<String> DATA_COMPRESSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataCompressionType").getter(CreateFileSystemLustreConfiguration.getter(CreateFileSystemLustreConfiguration::dataCompressionTypeAsString)).setter(CreateFileSystemLustreConfiguration.setter(Builder::dataCompressionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCompressionType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEEKLY_MAINTENANCE_START_TIME_FIELD, IMPORT_PATH_FIELD, EXPORT_PATH_FIELD, IMPORTED_FILE_CHUNK_SIZE_FIELD, DEPLOYMENT_TYPE_FIELD, AUTO_IMPORT_POLICY_FIELD, PER_UNIT_STORAGE_THROUGHPUT_FIELD, DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD, AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD, COPY_TAGS_TO_BACKUPS_FIELD, DRIVE_CACHE_TYPE_FIELD, DATA_COMPRESSION_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String weeklyMaintenanceStartTime;
    private final String importPath;
    private final String exportPath;
    private final Integer importedFileChunkSize;
    private final String deploymentType;
    private final String autoImportPolicy;
    private final Integer perUnitStorageThroughput;
    private final String dailyAutomaticBackupStartTime;
    private final Integer automaticBackupRetentionDays;
    private final Boolean copyTagsToBackups;
    private final String driveCacheType;
    private final String dataCompressionType;

    private CreateFileSystemLustreConfiguration(BuilderImpl builder) {
        this.weeklyMaintenanceStartTime = builder.weeklyMaintenanceStartTime;
        this.importPath = builder.importPath;
        this.exportPath = builder.exportPath;
        this.importedFileChunkSize = builder.importedFileChunkSize;
        this.deploymentType = builder.deploymentType;
        this.autoImportPolicy = builder.autoImportPolicy;
        this.perUnitStorageThroughput = builder.perUnitStorageThroughput;
        this.dailyAutomaticBackupStartTime = builder.dailyAutomaticBackupStartTime;
        this.automaticBackupRetentionDays = builder.automaticBackupRetentionDays;
        this.copyTagsToBackups = builder.copyTagsToBackups;
        this.driveCacheType = builder.driveCacheType;
        this.dataCompressionType = builder.dataCompressionType;
    }

    public final String weeklyMaintenanceStartTime() {
        return this.weeklyMaintenanceStartTime;
    }

    public final String importPath() {
        return this.importPath;
    }

    public final String exportPath() {
        return this.exportPath;
    }

    public final Integer importedFileChunkSize() {
        return this.importedFileChunkSize;
    }

    public final LustreDeploymentType deploymentType() {
        return LustreDeploymentType.fromValue(this.deploymentType);
    }

    public final String deploymentTypeAsString() {
        return this.deploymentType;
    }

    public final AutoImportPolicyType autoImportPolicy() {
        return AutoImportPolicyType.fromValue(this.autoImportPolicy);
    }

    public final String autoImportPolicyAsString() {
        return this.autoImportPolicy;
    }

    public final Integer perUnitStorageThroughput() {
        return this.perUnitStorageThroughput;
    }

    public final String dailyAutomaticBackupStartTime() {
        return this.dailyAutomaticBackupStartTime;
    }

    public final Integer automaticBackupRetentionDays() {
        return this.automaticBackupRetentionDays;
    }

    public final Boolean copyTagsToBackups() {
        return this.copyTagsToBackups;
    }

    public final DriveCacheType driveCacheType() {
        return DriveCacheType.fromValue(this.driveCacheType);
    }

    public final String driveCacheTypeAsString() {
        return this.driveCacheType;
    }

    public final DataCompressionType dataCompressionType() {
        return DataCompressionType.fromValue(this.dataCompressionType);
    }

    public final String dataCompressionTypeAsString() {
        return this.dataCompressionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.weeklyMaintenanceStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.importPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.importedFileChunkSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoImportPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.perUnitStorageThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.dailyAutomaticBackupStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticBackupRetentionDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsToBackups());
        hashCode = 31 * hashCode + Objects.hashCode(this.driveCacheTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataCompressionTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFileSystemLustreConfiguration)) {
            return false;
        }
        CreateFileSystemLustreConfiguration other = (CreateFileSystemLustreConfiguration)obj;
        return Objects.equals(this.weeklyMaintenanceStartTime(), other.weeklyMaintenanceStartTime()) && Objects.equals(this.importPath(), other.importPath()) && Objects.equals(this.exportPath(), other.exportPath()) && Objects.equals(this.importedFileChunkSize(), other.importedFileChunkSize()) && Objects.equals(this.deploymentTypeAsString(), other.deploymentTypeAsString()) && Objects.equals(this.autoImportPolicyAsString(), other.autoImportPolicyAsString()) && Objects.equals(this.perUnitStorageThroughput(), other.perUnitStorageThroughput()) && Objects.equals(this.dailyAutomaticBackupStartTime(), other.dailyAutomaticBackupStartTime()) && Objects.equals(this.automaticBackupRetentionDays(), other.automaticBackupRetentionDays()) && Objects.equals(this.copyTagsToBackups(), other.copyTagsToBackups()) && Objects.equals(this.driveCacheTypeAsString(), other.driveCacheTypeAsString()) && Objects.equals(this.dataCompressionTypeAsString(), other.dataCompressionTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFileSystemLustreConfiguration").add("WeeklyMaintenanceStartTime", (Object)this.weeklyMaintenanceStartTime()).add("ImportPath", (Object)this.importPath()).add("ExportPath", (Object)this.exportPath()).add("ImportedFileChunkSize", (Object)this.importedFileChunkSize()).add("DeploymentType", (Object)this.deploymentTypeAsString()).add("AutoImportPolicy", (Object)this.autoImportPolicyAsString()).add("PerUnitStorageThroughput", (Object)this.perUnitStorageThroughput()).add("DailyAutomaticBackupStartTime", (Object)this.dailyAutomaticBackupStartTime()).add("AutomaticBackupRetentionDays", (Object)this.automaticBackupRetentionDays()).add("CopyTagsToBackups", (Object)this.copyTagsToBackups()).add("DriveCacheType", (Object)this.driveCacheTypeAsString()).add("DataCompressionType", (Object)this.dataCompressionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WeeklyMaintenanceStartTime": {
                return Optional.ofNullable(clazz.cast(this.weeklyMaintenanceStartTime()));
            }
            case "ImportPath": {
                return Optional.ofNullable(clazz.cast(this.importPath()));
            }
            case "ExportPath": {
                return Optional.ofNullable(clazz.cast(this.exportPath()));
            }
            case "ImportedFileChunkSize": {
                return Optional.ofNullable(clazz.cast(this.importedFileChunkSize()));
            }
            case "DeploymentType": {
                return Optional.ofNullable(clazz.cast(this.deploymentTypeAsString()));
            }
            case "AutoImportPolicy": {
                return Optional.ofNullable(clazz.cast(this.autoImportPolicyAsString()));
            }
            case "PerUnitStorageThroughput": {
                return Optional.ofNullable(clazz.cast(this.perUnitStorageThroughput()));
            }
            case "DailyAutomaticBackupStartTime": {
                return Optional.ofNullable(clazz.cast(this.dailyAutomaticBackupStartTime()));
            }
            case "AutomaticBackupRetentionDays": {
                return Optional.ofNullable(clazz.cast(this.automaticBackupRetentionDays()));
            }
            case "CopyTagsToBackups": {
                return Optional.ofNullable(clazz.cast(this.copyTagsToBackups()));
            }
            case "DriveCacheType": {
                return Optional.ofNullable(clazz.cast(this.driveCacheTypeAsString()));
            }
            case "DataCompressionType": {
                return Optional.ofNullable(clazz.cast(this.dataCompressionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFileSystemLustreConfiguration, T> g) {
        return obj -> g.apply((CreateFileSystemLustreConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String weeklyMaintenanceStartTime;
        private String importPath;
        private String exportPath;
        private Integer importedFileChunkSize;
        private String deploymentType;
        private String autoImportPolicy;
        private Integer perUnitStorageThroughput;
        private String dailyAutomaticBackupStartTime;
        private Integer automaticBackupRetentionDays;
        private Boolean copyTagsToBackups;
        private String driveCacheType;
        private String dataCompressionType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFileSystemLustreConfiguration model) {
            this.weeklyMaintenanceStartTime(model.weeklyMaintenanceStartTime);
            this.importPath(model.importPath);
            this.exportPath(model.exportPath);
            this.importedFileChunkSize(model.importedFileChunkSize);
            this.deploymentType(model.deploymentType);
            this.autoImportPolicy(model.autoImportPolicy);
            this.perUnitStorageThroughput(model.perUnitStorageThroughput);
            this.dailyAutomaticBackupStartTime(model.dailyAutomaticBackupStartTime);
            this.automaticBackupRetentionDays(model.automaticBackupRetentionDays);
            this.copyTagsToBackups(model.copyTagsToBackups);
            this.driveCacheType(model.driveCacheType);
            this.dataCompressionType(model.dataCompressionType);
        }

        public final String getWeeklyMaintenanceStartTime() {
            return this.weeklyMaintenanceStartTime;
        }

        public final void setWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
        }

        @Override
        @Transient
        public final Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            return this;
        }

        public final String getImportPath() {
            return this.importPath;
        }

        public final void setImportPath(String importPath) {
            this.importPath = importPath;
        }

        @Override
        @Transient
        public final Builder importPath(String importPath) {
            this.importPath = importPath;
            return this;
        }

        public final String getExportPath() {
            return this.exportPath;
        }

        public final void setExportPath(String exportPath) {
            this.exportPath = exportPath;
        }

        @Override
        @Transient
        public final Builder exportPath(String exportPath) {
            this.exportPath = exportPath;
            return this;
        }

        public final Integer getImportedFileChunkSize() {
            return this.importedFileChunkSize;
        }

        public final void setImportedFileChunkSize(Integer importedFileChunkSize) {
            this.importedFileChunkSize = importedFileChunkSize;
        }

        @Override
        @Transient
        public final Builder importedFileChunkSize(Integer importedFileChunkSize) {
            this.importedFileChunkSize = importedFileChunkSize;
            return this;
        }

        public final String getDeploymentType() {
            return this.deploymentType;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        @Override
        @Transient
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        @Transient
        public final Builder deploymentType(LustreDeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final String getAutoImportPolicy() {
            return this.autoImportPolicy;
        }

        public final void setAutoImportPolicy(String autoImportPolicy) {
            this.autoImportPolicy = autoImportPolicy;
        }

        @Override
        @Transient
        public final Builder autoImportPolicy(String autoImportPolicy) {
            this.autoImportPolicy = autoImportPolicy;
            return this;
        }

        @Override
        @Transient
        public final Builder autoImportPolicy(AutoImportPolicyType autoImportPolicy) {
            this.autoImportPolicy(autoImportPolicy == null ? null : autoImportPolicy.toString());
            return this;
        }

        public final Integer getPerUnitStorageThroughput() {
            return this.perUnitStorageThroughput;
        }

        public final void setPerUnitStorageThroughput(Integer perUnitStorageThroughput) {
            this.perUnitStorageThroughput = perUnitStorageThroughput;
        }

        @Override
        @Transient
        public final Builder perUnitStorageThroughput(Integer perUnitStorageThroughput) {
            this.perUnitStorageThroughput = perUnitStorageThroughput;
            return this;
        }

        public final String getDailyAutomaticBackupStartTime() {
            return this.dailyAutomaticBackupStartTime;
        }

        public final void setDailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
        }

        @Override
        @Transient
        public final Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
            return this;
        }

        public final Integer getAutomaticBackupRetentionDays() {
            return this.automaticBackupRetentionDays;
        }

        public final void setAutomaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
        }

        @Override
        @Transient
        public final Builder automaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
            return this;
        }

        public final Boolean getCopyTagsToBackups() {
            return this.copyTagsToBackups;
        }

        public final void setCopyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
        }

        @Override
        @Transient
        public final Builder copyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
            return this;
        }

        public final String getDriveCacheType() {
            return this.driveCacheType;
        }

        public final void setDriveCacheType(String driveCacheType) {
            this.driveCacheType = driveCacheType;
        }

        @Override
        @Transient
        public final Builder driveCacheType(String driveCacheType) {
            this.driveCacheType = driveCacheType;
            return this;
        }

        @Override
        @Transient
        public final Builder driveCacheType(DriveCacheType driveCacheType) {
            this.driveCacheType(driveCacheType == null ? null : driveCacheType.toString());
            return this;
        }

        public final String getDataCompressionType() {
            return this.dataCompressionType;
        }

        public final void setDataCompressionType(String dataCompressionType) {
            this.dataCompressionType = dataCompressionType;
        }

        @Override
        @Transient
        public final Builder dataCompressionType(String dataCompressionType) {
            this.dataCompressionType = dataCompressionType;
            return this;
        }

        @Override
        @Transient
        public final Builder dataCompressionType(DataCompressionType dataCompressionType) {
            this.dataCompressionType(dataCompressionType == null ? null : dataCompressionType.toString());
            return this;
        }

        public CreateFileSystemLustreConfiguration build() {
            return new CreateFileSystemLustreConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateFileSystemLustreConfiguration> {
        public Builder weeklyMaintenanceStartTime(String var1);

        public Builder importPath(String var1);

        public Builder exportPath(String var1);

        public Builder importedFileChunkSize(Integer var1);

        public Builder deploymentType(String var1);

        public Builder deploymentType(LustreDeploymentType var1);

        public Builder autoImportPolicy(String var1);

        public Builder autoImportPolicy(AutoImportPolicyType var1);

        public Builder perUnitStorageThroughput(Integer var1);

        public Builder dailyAutomaticBackupStartTime(String var1);

        public Builder automaticBackupRetentionDays(Integer var1);

        public Builder copyTagsToBackups(Boolean var1);

        public Builder driveCacheType(String var1);

        public Builder driveCacheType(DriveCacheType var1);

        public Builder dataCompressionType(String var1);

        public Builder dataCompressionType(DataCompressionType var1);
    }
}

