/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.FSxRequest;
import software.amazon.awssdk.services.fsx.model.UpdateOntapVolumeConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateVolumeRequest
extends FSxRequest
implements ToCopyableBuilder<Builder, UpdateVolumeRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(UpdateVolumeRequest.getter(UpdateVolumeRequest::clientRequestToken)).setter(UpdateVolumeRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeId").getter(UpdateVolumeRequest.getter(UpdateVolumeRequest::volumeId)).setter(UpdateVolumeRequest.setter(Builder::volumeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").build()}).build();
    private static final SdkField<UpdateOntapVolumeConfiguration> ONTAP_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OntapConfiguration").getter(UpdateVolumeRequest.getter(UpdateVolumeRequest::ontapConfiguration)).setter(UpdateVolumeRequest.setter(Builder::ontapConfiguration)).constructor(UpdateOntapVolumeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OntapConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD, VOLUME_ID_FIELD, ONTAP_CONFIGURATION_FIELD));
    private final String clientRequestToken;
    private final String volumeId;
    private final UpdateOntapVolumeConfiguration ontapConfiguration;

    private UpdateVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.volumeId = builder.volumeId;
        this.ontapConfiguration = builder.ontapConfiguration;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String volumeId() {
        return this.volumeId;
    }

    public final UpdateOntapVolumeConfiguration ontapConfiguration() {
        return this.ontapConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ontapConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVolumeRequest)) {
            return false;
        }
        UpdateVolumeRequest other = (UpdateVolumeRequest)((Object)obj);
        return Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.volumeId(), other.volumeId()) && Objects.equals(this.ontapConfiguration(), other.ontapConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateVolumeRequest").add("ClientRequestToken", (Object)this.clientRequestToken()).add("VolumeId", (Object)this.volumeId()).add("OntapConfiguration", (Object)this.ontapConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "VolumeId": {
                return Optional.ofNullable(clazz.cast(this.volumeId()));
            }
            case "OntapConfiguration": {
                return Optional.ofNullable(clazz.cast(this.ontapConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateVolumeRequest, T> g) {
        return obj -> g.apply((UpdateVolumeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxRequest.BuilderImpl
    implements Builder {
        private String clientRequestToken;
        private String volumeId;
        private UpdateOntapVolumeConfiguration ontapConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVolumeRequest model) {
            super(model);
            this.clientRequestToken(model.clientRequestToken);
            this.volumeId(model.volumeId);
            this.ontapConfiguration(model.ontapConfiguration);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        @Transient
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final UpdateOntapVolumeConfiguration.Builder getOntapConfiguration() {
            return this.ontapConfiguration != null ? this.ontapConfiguration.toBuilder() : null;
        }

        public final void setOntapConfiguration(UpdateOntapVolumeConfiguration.BuilderImpl ontapConfiguration) {
            this.ontapConfiguration = ontapConfiguration != null ? ontapConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder ontapConfiguration(UpdateOntapVolumeConfiguration ontapConfiguration) {
            this.ontapConfiguration = ontapConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVolumeRequest build() {
            return new UpdateVolumeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FSxRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateVolumeRequest> {
        public Builder clientRequestToken(String var1);

        public Builder volumeId(String var1);

        public Builder ontapConfiguration(UpdateOntapVolumeConfiguration var1);

        default public Builder ontapConfiguration(Consumer<UpdateOntapVolumeConfiguration.Builder> ontapConfiguration) {
            return this.ontapConfiguration((UpdateOntapVolumeConfiguration)((UpdateOntapVolumeConfiguration.Builder)UpdateOntapVolumeConfiguration.builder().applyMutation(ontapConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

